/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.analysis.AnalysisMode;
import org.elasticsearch.index.analysis.AnalyzerComponents;
import org.elasticsearch.index.analysis.AnalyzerComponentsProvider;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;

public final class CustomAnalyzer
extends Analyzer
implements AnalyzerComponentsProvider {
    private final AnalyzerComponents components;
    private final int positionIncrementGap;
    private final int offsetGap;
    private final AnalysisMode analysisMode;

    public CustomAnalyzer(TokenizerFactory tokenizerFactory, CharFilterFactory[] charFilters, TokenFilterFactory[] tokenFilters) {
        this(tokenizerFactory, charFilters, tokenFilters, 0, -1);
    }

    public CustomAnalyzer(TokenizerFactory tokenizerFactory, CharFilterFactory[] charFilters, TokenFilterFactory[] tokenFilters, int positionIncrementGap, int offsetGap) {
        this.components = new AnalyzerComponents(tokenizerFactory, charFilters, tokenFilters);
        this.positionIncrementGap = positionIncrementGap;
        this.offsetGap = offsetGap;
        AnalysisMode mode = AnalysisMode.ALL;
        for (TokenFilterFactory f : tokenFilters) {
            mode = mode.merge(f.getAnalysisMode());
        }
        this.analysisMode = mode;
    }

    public TokenizerFactory tokenizerFactory() {
        return this.components.getTokenizerFactory();
    }

    public TokenFilterFactory[] tokenFilters() {
        return this.components.getTokenFilters();
    }

    public CharFilterFactory[] charFilters() {
        return this.components.getCharFilters();
    }

    public int getPositionIncrementGap(String fieldName) {
        return this.positionIncrementGap;
    }

    public int getOffsetGap(String field) {
        if (this.offsetGap < 0) {
            return super.getOffsetGap(field);
        }
        return this.offsetGap;
    }

    public AnalysisMode getAnalysisMode() {
        return this.analysisMode;
    }

    @Override
    public AnalyzerComponents getComponents() {
        return this.components;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer tokenizer;
        Tokenizer tokenStream = tokenizer = this.tokenizerFactory().create();
        for (TokenFilterFactory tokenFilter : this.tokenFilters()) {
            tokenStream = tokenFilter.create((TokenStream)tokenStream);
        }
        return new Analyzer.TokenStreamComponents(tokenizer, (TokenStream)tokenStream);
    }

    protected Reader initReader(String fieldName, Reader reader) {
        Object[] charFilters = this.charFilters();
        if (!CollectionUtils.isEmpty(charFilters)) {
            for (Object charFilter : charFilters) {
                reader = charFilter.create(reader);
            }
        }
        return reader;
    }

    protected Reader initReaderForNormalization(String fieldName, Reader reader) {
        for (CharFilterFactory charFilter : this.charFilters()) {
            reader = charFilter.normalize(reader);
        }
        return reader;
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenStream result = in;
        for (TokenFilterFactory filter : this.tokenFilters()) {
            result = filter.normalize(result);
        }
        return result;
    }
}

