/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.util.EPUBVersion;
import java.util.HashSet;

public final class OCFFilenameChecker {
    private static final HashSet<String> restricted30CharacterSet;

    private OCFFilenameChecker() {
    }

    public static String checkCompatiblyEscaped(String str, Report report, EPUBVersion version) {
        char[] chars;
        if (str.matches("^[^:/?#]+://.*")) {
            return "";
        }
        String test = OCFFilenameChecker.checkNonAsciiFilename(str, report);
        if (str.endsWith(".")) {
            report.message(MessageId.PKG_011, EPUBLocation.create(str), new Object[0]);
            test = test + ".";
        }
        boolean spaces = false;
        char[] ascciGraphic = new char[]{'<', '>', '\"', '{', '}', '|', '^', '`', '*', '?'};
        String result = "";
        for (char c : chars = str.toCharArray()) {
            for (char a : ascciGraphic) {
                if (c != a) continue;
                result = result + "\"" + Character.toString(c) + "\",";
                test = test + Character.toString(c);
            }
            if (!Character.isSpaceChar(c)) continue;
            spaces = true;
            test = test + Character.toString(c);
        }
        if (result.length() > 1) {
            result = result.substring(0, result.length() - 1);
            report.message(MessageId.PKG_009, EPUBLocation.create(str), result);
        }
        if (spaces) {
            report.message(MessageId.PKG_010, EPUBLocation.create(str), new Object[0]);
        }
        if (version == EPUBVersion.VERSION_3) {
            OCFFilenameChecker.checkCompatiblyEscaped30(str, test, report);
        }
        return test;
    }

    private static String checkNonAsciiFilename(String str, Report report) {
        String nonAscii = str.replaceAll("[\\p{ASCII}]", "");
        if (nonAscii.length() > 0) {
            report.message(MessageId.PKG_012, EPUBLocation.create(str), nonAscii);
        }
        return nonAscii;
    }

    private static String checkCompatiblyEscaped30(String str, String test, Report report) {
        char[] chars;
        String result = "";
        for (char c : chars = str.toCharArray()) {
            String unicodeType;
            if (Character.isISOControl(c)) {
                result = result + "\"" + Character.toString(c) + "\",";
                test = test + Character.toString(c);
            }
            if (c == '\u007f') {
                result = result + "\"" + Character.toString(c) + "\",";
                test = test + Character.toString(c);
            }
            if (!restricted30CharacterSet.contains(unicodeType = Character.UnicodeBlock.of(c).toString())) continue;
            result = result + "\"" + Character.toString(c) + "\",";
        }
        if (result.length() > 1) {
            result = result.substring(0, result.length() - 1);
            report.message(MessageId.PKG_009, EPUBLocation.create(str), result);
        }
        return test;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("PRIVATE_USE_AREA");
        set.add("ARABIC_PRESENTATION_FORMS_A");
        set.add("SPECIALS");
        set.add("SUPPLEMENTARY_PRIVATE_USE_AREA_A");
        set.add("SUPPLEMENTARY_PRIVATE_USE_AREA_B");
        set.add("VARIATION_SELECTORS_SUPPLEMENT");
        set.add("TAGS");
        restricted30CharacterSet = set;
    }
}

