'' FreeBASIC binding for mingw-w64-v4.0.4
''
'' based on the C header files:
''   DISCLAIMER
''   This file has no copyright assigned and is placed in the Public Domain.
''   This file is part of the mingw-w64 runtime package.
''
''   The mingw-w64 runtime package and its code is distributed in the hope that it 
''   will be useful but WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESSED OR 
''   IMPLIED ARE HEREBY DISCLAIMED.  This includes but is not limited to 
''   warranties of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
''
'' translated to FreeBASIC by:
''   Copyright © 2015 FreeBASIC development team

#pragma once

extern "C"

extern GUID_DEVINTERFACE_DISK as const GUID
extern GUID_DEVINTERFACE_CDROM as const GUID
extern GUID_DEVINTERFACE_PARTITION as const GUID
extern GUID_DEVINTERFACE_TAPE as const GUID
extern GUID_DEVINTERFACE_WRITEONCEDISK as const GUID
extern GUID_DEVINTERFACE_VOLUME as const GUID
extern GUID_DEVINTERFACE_MEDIUMCHANGER as const GUID
extern GUID_DEVINTERFACE_FLOPPY as const GUID
extern GUID_DEVINTERFACE_CDCHANGER as const GUID
extern GUID_DEVINTERFACE_STORAGEPORT as const GUID
extern GUID_DEVINTERFACE_COMPORT as const GUID
extern GUID_DEVINTERFACE_SERENUM_BUS_ENUMERATOR as const GUID
extern DiskClassGuid alias "GUID_DEVINTERFACE_DISK" as const GUID
extern CdRomClassGuid alias "GUID_DEVINTERFACE_CDROM" as const GUID
extern PartitionClassGuid alias "GUID_DEVINTERFACE_PARTITION" as const GUID
extern TapeClassGuid alias "GUID_DEVINTERFACE_TAPE" as const GUID
extern WriteOnceDiskClassGuid alias "GUID_DEVINTERFACE_WRITEONCEDISK" as const GUID
extern VolumeClassGuid alias "GUID_DEVINTERFACE_VOLUME" as const GUID
extern MediumChangerClassGuid alias "GUID_DEVINTERFACE_MEDIUMCHANGER" as const GUID
extern FloppyClassGuid alias "GUID_DEVINTERFACE_FLOPPY" as const GUID
extern CdChangerClassGuid alias "GUID_DEVINTERFACE_CDCHANGER" as const GUID
extern StoragePortClassGuid alias "GUID_DEVINTERFACE_STORAGEPORT" as const GUID
extern GUID_CLASS_COMPORT alias "GUID_DEVINTERFACE_COMPORT" as const GUID
extern GUID_SERENUM_BUS_ENUMERATOR alias "GUID_DEVINTERFACE_SERENUM_BUS_ENUMERATOR" as const GUID
#define _WINIOCTL_
#define _DEVIOCTL_
type DEVICE_TYPE as DWORD

const FILE_DEVICE_BEEP = &h00000001
const FILE_DEVICE_CD_ROM = &h00000002
const FILE_DEVICE_CD_ROM_FILE_SYSTEM = &h00000003
const FILE_DEVICE_CONTROLLER = &h00000004
const FILE_DEVICE_DATALINK = &h00000005
const FILE_DEVICE_DFS = &h00000006
const FILE_DEVICE_DISK = &h00000007
const FILE_DEVICE_DISK_FILE_SYSTEM = &h00000008
const FILE_DEVICE_FILE_SYSTEM = &h00000009
const FILE_DEVICE_INPORT_PORT = &h0000000a
const FILE_DEVICE_KEYBOARD = &h0000000b
const FILE_DEVICE_MAILSLOT = &h0000000c
const FILE_DEVICE_MIDI_IN = &h0000000d
const FILE_DEVICE_MIDI_OUT = &h0000000e
const FILE_DEVICE_MOUSE = &h0000000f
const FILE_DEVICE_MULTI_UNC_PROVIDER = &h00000010
const FILE_DEVICE_NAMED_PIPE = &h00000011
const FILE_DEVICE_NETWORK = &h00000012
const FILE_DEVICE_NETWORK_BROWSER = &h00000013
const FILE_DEVICE_NETWORK_FILE_SYSTEM = &h00000014
const FILE_DEVICE_NULL = &h00000015
const FILE_DEVICE_PARALLEL_PORT = &h00000016
const FILE_DEVICE_PHYSICAL_NETCARD = &h00000017
const FILE_DEVICE_PRINTER = &h00000018
const FILE_DEVICE_SCANNER = &h00000019
const FILE_DEVICE_SERIAL_MOUSE_PORT = &h0000001a
const FILE_DEVICE_SERIAL_PORT = &h0000001b
const FILE_DEVICE_SCREEN = &h0000001c
const FILE_DEVICE_SOUND = &h0000001d
const FILE_DEVICE_STREAMS = &h0000001e
const FILE_DEVICE_TAPE = &h0000001f
const FILE_DEVICE_TAPE_FILE_SYSTEM = &h00000020
const FILE_DEVICE_TRANSPORT = &h00000021
const FILE_DEVICE_UNKNOWN = &h00000022
const FILE_DEVICE_VIDEO = &h00000023
const FILE_DEVICE_VIRTUAL_DISK = &h00000024
const FILE_DEVICE_WAVE_IN = &h00000025
const FILE_DEVICE_WAVE_OUT = &h00000026
const FILE_DEVICE_8042_PORT = &h00000027
const FILE_DEVICE_NETWORK_REDIRECTOR = &h00000028
const FILE_DEVICE_BATTERY = &h00000029
const FILE_DEVICE_BUS_EXTENDER = &h0000002a
const FILE_DEVICE_MODEM = &h0000002b
const FILE_DEVICE_VDM = &h0000002c
const FILE_DEVICE_MASS_STORAGE = &h0000002d
const FILE_DEVICE_SMB = &h0000002e
const FILE_DEVICE_KS = &h0000002f
const FILE_DEVICE_CHANGER = &h00000030
const FILE_DEVICE_SMARTCARD = &h00000031
const FILE_DEVICE_ACPI = &h00000032
const FILE_DEVICE_DVD = &h00000033
const FILE_DEVICE_FULLSCREEN_VIDEO = &h00000034
const FILE_DEVICE_DFS_FILE_SYSTEM = &h00000035
const FILE_DEVICE_DFS_VOLUME = &h00000036
const FILE_DEVICE_SERENUM = &h00000037
const FILE_DEVICE_TERMSRV = &h00000038
const FILE_DEVICE_KSEC = &h00000039
const FILE_DEVICE_FIPS = &h0000003A
const FILE_DEVICE_INFINIBAND = &h0000003B
#define CTL_CODE(DeviceType, Function, Method, Access) (((((DeviceType) shl 16) or ((Access) shl 14)) or ((Function) shl 2)) or (Method))
#define DEVICE_TYPE_FROM_CTL_CODE(ctrlCode) (cast(DWORD, ctrlCode and &hffff0000) shr 16)
const METHOD_BUFFERED = 0
const METHOD_IN_DIRECT = 1
const METHOD_OUT_DIRECT = 2
const METHOD_NEITHER = 3
const METHOD_DIRECT_TO_HARDWARE = METHOD_IN_DIRECT
const METHOD_DIRECT_FROM_HARDWARE = METHOD_OUT_DIRECT
const FILE_ANY_ACCESS = 0
const FILE_SPECIAL_ACCESS = FILE_ANY_ACCESS
const FILE_READ_ACCESS = &h0001
const FILE_WRITE_ACCESS = &h0002
#define _NTDDSTOR_H_
const IOCTL_STORAGE_BASE = FILE_DEVICE_MASS_STORAGE
#define IOCTL_STORAGE_CHECK_VERIFY CTL_CODE(IOCTL_STORAGE_BASE, &h0200, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_CHECK_VERIFY2 CTL_CODE(IOCTL_STORAGE_BASE, &h0200, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_MEDIA_REMOVAL CTL_CODE(IOCTL_STORAGE_BASE, &h0201, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_EJECT_MEDIA CTL_CODE(IOCTL_STORAGE_BASE, &h0202, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_LOAD_MEDIA CTL_CODE(IOCTL_STORAGE_BASE, &h0203, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_LOAD_MEDIA2 CTL_CODE(IOCTL_STORAGE_BASE, &h0203, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_RESERVE CTL_CODE(IOCTL_STORAGE_BASE, &h0204, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_RELEASE CTL_CODE(IOCTL_STORAGE_BASE, &h0205, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_FIND_NEW_DEVICES CTL_CODE(IOCTL_STORAGE_BASE, &h0206, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_EJECTION_CONTROL CTL_CODE(IOCTL_STORAGE_BASE, &h0250, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_MCN_CONTROL CTL_CODE(IOCTL_STORAGE_BASE, &h0251, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_GET_MEDIA_TYPES CTL_CODE(IOCTL_STORAGE_BASE, &h0300, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_GET_MEDIA_TYPES_EX CTL_CODE(IOCTL_STORAGE_BASE, &h0301, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_GET_MEDIA_SERIAL_NUMBER CTL_CODE(IOCTL_STORAGE_BASE, &h0304, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_GET_HOTPLUG_INFO CTL_CODE(IOCTL_STORAGE_BASE, &h0305, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_SET_HOTPLUG_INFO CTL_CODE(IOCTL_STORAGE_BASE, &h0306, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_STORAGE_RESET_BUS CTL_CODE(IOCTL_STORAGE_BASE, &h0400, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_RESET_DEVICE CTL_CODE(IOCTL_STORAGE_BASE, &h0401, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_BREAK_RESERVATION CTL_CODE(IOCTL_STORAGE_BASE, &h0405, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_GET_DEVICE_NUMBER CTL_CODE(IOCTL_STORAGE_BASE, &h0420, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_PREDICT_FAILURE CTL_CODE(IOCTL_STORAGE_BASE, &h0440, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_READ_CAPACITY CTL_CODE(IOCTL_STORAGE_BASE, &h0450, METHOD_BUFFERED, FILE_READ_ACCESS)
#define OBSOLETE_IOCTL_STORAGE_RESET_BUS CTL_CODE(IOCTL_STORAGE_BASE, &h0400, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define OBSOLETE_IOCTL_STORAGE_RESET_DEVICE CTL_CODE(IOCTL_STORAGE_BASE, &h0401, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)

type _STORAGE_READ_CAPACITY
	Version as ULONG
	Size as ULONG
	BlockLength as ULONG
	NumberOfBlocks as LARGE_INTEGER
	DiskLength as LARGE_INTEGER
end type

type STORAGE_READ_CAPACITY as _STORAGE_READ_CAPACITY
type PSTORAGE_READ_CAPACITY as _STORAGE_READ_CAPACITY ptr

#if _WIN32_WINNT = &h0602
	#define IOCTL_STORAGE_MANAGE_DATA_SET_ATTRIBUTES CTL_CODE(IOCTL_STORAGE_BASE, &h0501, METHOD_BUFFERED, FILE_WRITE_ACCESS)
	const DeviceDsmActionFlag_NonDestructive = &h80000000
	const DeviceDsmAction_None = 0
	const DeviceDsmAction_Trim = 1
	const DeviceDsmAction_Notification = 2 or DeviceDsmActionFlag_NonDestructive
	#define IsDsmActionNonDestructive(x) cast(WINBOOLEAN, -((((x) and DeviceDsmActionFlag_NonDestructive) = 0) = 0))
	const DEVICE_DSM_FLAG_ENTIRE_DATA_SET_RANGE = &h00000001
	type DEVICE_DATA_MANAGEMENT_SET_ACTION as DWORD

	type _DEVICE_MANAGE_DATA_SET_ATTRIBUTES
		Size as DWORD
		Action as DEVICE_DATA_MANAGEMENT_SET_ACTION
		Flags as DWORD
		ParameterBlockOffset as DWORD
		ParameterBlockLength as DWORD
		DataSetRangesOffset as DWORD
		DataSetRangesLength as DWORD
	end type

	type DEVICE_MANAGE_DATA_SET_ATTRIBUTES as _DEVICE_MANAGE_DATA_SET_ATTRIBUTES
	type PDEVICE_MANAGE_DATA_SET_ATTRIBUTES as _DEVICE_MANAGE_DATA_SET_ATTRIBUTES ptr

	type _DEVICE_DATA_SET_RANGE
		StartingOffset as LONGLONG
		LengthInBytes as DWORDLONG
	end type

	type DEVICE_DATA_SET_RANGE as _DEVICE_DATA_SET_RANGE
	type PDEVICE_DATA_SET_RANGE as _DEVICE_DATA_SET_RANGE ptr
#endif

type _STORAGE_HOTPLUG_INFO
	Size as DWORD
	MediaRemovable as WINBOOLEAN
	MediaHotplug as WINBOOLEAN
	DeviceHotplug as WINBOOLEAN
	WriteCacheEnableOverride as WINBOOLEAN
end type

type STORAGE_HOTPLUG_INFO as _STORAGE_HOTPLUG_INFO
type PSTORAGE_HOTPLUG_INFO as _STORAGE_HOTPLUG_INFO ptr

type _STORAGE_DEVICE_NUMBER
	DeviceType as DWORD
	DeviceNumber as DWORD
	PartitionNumber as DWORD
end type

type STORAGE_DEVICE_NUMBER as _STORAGE_DEVICE_NUMBER
type PSTORAGE_DEVICE_NUMBER as _STORAGE_DEVICE_NUMBER ptr

type _STORAGE_BUS_RESET_REQUEST
	PathId as UBYTE
end type

type STORAGE_BUS_RESET_REQUEST as _STORAGE_BUS_RESET_REQUEST
type PSTORAGE_BUS_RESET_REQUEST as _STORAGE_BUS_RESET_REQUEST ptr

type STORAGE_BREAK_RESERVATION_REQUEST
	Length as DWORD
	_unused as UBYTE
	PathId as UBYTE
	TargetId as UBYTE
	Lun as UBYTE
end type

type PSTORAGE_BREAK_RESERVATION_REQUEST as STORAGE_BREAK_RESERVATION_REQUEST ptr

type _PREVENT_MEDIA_REMOVAL
	PreventMediaRemoval as WINBOOLEAN
end type

type PREVENT_MEDIA_REMOVAL as _PREVENT_MEDIA_REMOVAL
type PPREVENT_MEDIA_REMOVAL as _PREVENT_MEDIA_REMOVAL ptr

type _CLASS_MEDIA_CHANGE_CONTEXT
	MediaChangeCount as DWORD
	NewState as DWORD
end type

type CLASS_MEDIA_CHANGE_CONTEXT as _CLASS_MEDIA_CHANGE_CONTEXT
type PCLASS_MEDIA_CHANGE_CONTEXT as _CLASS_MEDIA_CHANGE_CONTEXT ptr

type _TAPE_STATISTICS
	Version as DWORD
	Flags as DWORD
	RecoveredWrites as LARGE_INTEGER
	UnrecoveredWrites as LARGE_INTEGER
	RecoveredReads as LARGE_INTEGER
	UnrecoveredReads as LARGE_INTEGER
	CompressionRatioReads as UBYTE
	CompressionRatioWrites as UBYTE
end type

type TAPE_STATISTICS as _TAPE_STATISTICS
type PTAPE_STATISTICS as _TAPE_STATISTICS ptr
const RECOVERED_WRITES_VALID = &h00000001
const UNRECOVERED_WRITES_VALID = &h00000002
const RECOVERED_READS_VALID = &h00000004
const UNRECOVERED_READS_VALID = &h00000008
const WRITE_COMPRESSION_INFO_VALID = &h00000010
const READ_COMPRESSION_INFO_VALID = &h00000020

type _TAPE_GET_STATISTICS
	Operation as DWORD
end type

type TAPE_GET_STATISTICS as _TAPE_GET_STATISTICS
type PTAPE_GET_STATISTICS as _TAPE_GET_STATISTICS ptr
const TAPE_RETURN_STATISTICS = 0
const TAPE_RETURN_ENV_INFO = 1
const TAPE_RESET_STATISTICS = 2

type _STORAGE_MEDIA_TYPE as long
enum
	DDS_4mm = &h20
	MiniQic
	Travan
	QIC
	MP_8mm
	AME_8mm
	AIT1_8mm
	DLT
	NCTP
	IBM_3480
	IBM_3490E
	IBM_Magstar_3590
	IBM_Magstar_MP
	STK_DATA_D3
	SONY_DTF
	DV_6mm
	DMI
	SONY_D2
	CLEANER_CARTRIDGE
	CD_ROM
	CD_R
	CD_RW
	DVD_ROM
	DVD_R
	DVD_RW
	MO_3_RW
	MO_5_WO
	MO_5_RW
	MO_5_LIMDOW
	PC_5_WO
	PC_5_RW
	PD_5_RW
	ABL_5_WO
	PINNACLE_APEX_5_RW
	SONY_12_WO
	PHILIPS_12_WO
	HITACHI_12_WO
	CYGNET_12_WO
	KODAK_14_WO
	MO_NFR_525
	NIKON_12_RW
	IOMEGA_ZIP
	IOMEGA_JAZ
	SYQUEST_EZ135
	SYQUEST_EZFLYER
	SYQUEST_SYJET
	AVATAR_F2
	MP2_8mm
	DST_S
	DST_M
	DST_L
	VXATape_1
	VXATape_2
	STK_9840
	LTO_Ultrium
	LTO_Accelis
	DVD_RAM
	AIT_8mm
	ADR_1
	ADR_2
	STK_9940
	SAIT
	VXATape
end enum

type STORAGE_MEDIA_TYPE as _STORAGE_MEDIA_TYPE
type PSTORAGE_MEDIA_TYPE as _STORAGE_MEDIA_TYPE ptr
const MEDIA_ERASEABLE = &h00000001
const MEDIA_WRITE_ONCE = &h00000002
const MEDIA_READ_ONLY = &h00000004
const MEDIA_READ_WRITE = &h00000008
const MEDIA_WRITE_PROTECTED = &h00000100
const MEDIA_CURRENTLY_MOUNTED = &h80000000

type _STORAGE_BUS_TYPE as long
enum
	BusTypeUnknown = &h00
	BusTypeScsi = &h1
	BusTypeAtapi = &h2
	BusTypeAta = &h3
	BusType1394 = &h4
	BusTypeSsa = &h5
	BusTypeFibre = &h6
	BusTypeUsb = &h7
	BusTypeRAID = &h8

	#if _WIN32_WINNT = &h0602
		BusTypeiScsi = &h9
		BusTypeSas = &hA
		BusTypeSata = &hB
		BusTypeSd = &hC
		BusTypeMmc = &hD
		BusTypeVirtual = &hE
		BusTypeFileBackedVirtual = &hF
	#endif

	BusTypeMax
	BusTypeMaxReserved = &h7F
end enum

type STORAGE_BUS_TYPE as _STORAGE_BUS_TYPE
type PSTORAGE_BUS_TYPE as _STORAGE_BUS_TYPE ptr

type _DEVICE_MEDIA_INFO_DeviceSpecific_DiskInfo
	Cylinders as LARGE_INTEGER
	MediaType as STORAGE_MEDIA_TYPE
	TracksPerCylinder as DWORD
	SectorsPerTrack as DWORD
	BytesPerSector as DWORD
	NumberMediaSides as DWORD
	MediaCharacteristics as DWORD
end type

type _DEVICE_MEDIA_INFO_DeviceSpecific_RemovableDiskInfo
	Cylinders as LARGE_INTEGER
	MediaType as STORAGE_MEDIA_TYPE
	TracksPerCylinder as DWORD
	SectorsPerTrack as DWORD
	BytesPerSector as DWORD
	NumberMediaSides as DWORD
	MediaCharacteristics as DWORD
end type

type _DEVICE_MEDIA_INFO_DeviceSpecific_TapeInfo_BusSpecificData_ScsiInformation
	MediumType as UBYTE
	DensityCode as UBYTE
end type

union _DEVICE_MEDIA_INFO_DeviceSpecific_TapeInfo_BusSpecificData
	ScsiInformation as _DEVICE_MEDIA_INFO_DeviceSpecific_TapeInfo_BusSpecificData_ScsiInformation
end union

type _DEVICE_MEDIA_INFO_DeviceSpecific_TapeInfo
	MediaType as STORAGE_MEDIA_TYPE
	MediaCharacteristics as DWORD
	CurrentBlockSize as DWORD
	BusType as STORAGE_BUS_TYPE
	BusSpecificData as _DEVICE_MEDIA_INFO_DeviceSpecific_TapeInfo_BusSpecificData
end type

union _DEVICE_MEDIA_INFO_DeviceSpecific
	DiskInfo as _DEVICE_MEDIA_INFO_DeviceSpecific_DiskInfo
	RemovableDiskInfo as _DEVICE_MEDIA_INFO_DeviceSpecific_RemovableDiskInfo
	TapeInfo as _DEVICE_MEDIA_INFO_DeviceSpecific_TapeInfo
end union

type _DEVICE_MEDIA_INFO
	DeviceSpecific as _DEVICE_MEDIA_INFO_DeviceSpecific
end type

type DEVICE_MEDIA_INFO as _DEVICE_MEDIA_INFO
type PDEVICE_MEDIA_INFO as _DEVICE_MEDIA_INFO ptr

type _GET_MEDIA_TYPES
	DeviceType as DWORD
	MediaInfoCount as DWORD
	MediaInfo(0 to 0) as DEVICE_MEDIA_INFO
end type

type GET_MEDIA_TYPES as _GET_MEDIA_TYPES
type PGET_MEDIA_TYPES as _GET_MEDIA_TYPES ptr

type _STORAGE_PREDICT_FAILURE
	PredictFailure as DWORD
	VendorSpecific(0 to 511) as UBYTE
end type

type STORAGE_PREDICT_FAILURE as _STORAGE_PREDICT_FAILURE
type PSTORAGE_PREDICT_FAILURE as _STORAGE_PREDICT_FAILURE ptr
#define _NTDDDISK_H_
const IOCTL_DISK_BASE = FILE_DEVICE_DISK
#define IOCTL_DISK_GET_DRIVE_GEOMETRY CTL_CODE(IOCTL_DISK_BASE, &h0000, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_GET_PARTITION_INFO CTL_CODE(IOCTL_DISK_BASE, &h0001, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_SET_PARTITION_INFO CTL_CODE(IOCTL_DISK_BASE, &h0002, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_GET_DRIVE_LAYOUT CTL_CODE(IOCTL_DISK_BASE, &h0003, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_SET_DRIVE_LAYOUT CTL_CODE(IOCTL_DISK_BASE, &h0004, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_VERIFY CTL_CODE(IOCTL_DISK_BASE, &h0005, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_FORMAT_TRACKS CTL_CODE(IOCTL_DISK_BASE, &h0006, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_REASSIGN_BLOCKS CTL_CODE(IOCTL_DISK_BASE, &h0007, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_PERFORMANCE CTL_CODE(IOCTL_DISK_BASE, &h0008, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_IS_WRITABLE CTL_CODE(IOCTL_DISK_BASE, &h0009, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_LOGGING CTL_CODE(IOCTL_DISK_BASE, &h000a, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_FORMAT_TRACKS_EX CTL_CODE(IOCTL_DISK_BASE, &h000b, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_HISTOGRAM_STRUCTURE CTL_CODE(IOCTL_DISK_BASE, &h000c, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_HISTOGRAM_DATA CTL_CODE(IOCTL_DISK_BASE, &h000d, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_HISTOGRAM_RESET CTL_CODE(IOCTL_DISK_BASE, &h000e, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_REQUEST_STRUCTURE CTL_CODE(IOCTL_DISK_BASE, &h000f, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_REQUEST_DATA CTL_CODE(IOCTL_DISK_BASE, &h0010, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_PERFORMANCE_OFF CTL_CODE(IOCTL_DISK_BASE, &h0018, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_CONTROLLER_NUMBER CTL_CODE(IOCTL_DISK_BASE, &h0011, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define SMART_GET_VERSION CTL_CODE(IOCTL_DISK_BASE, &h0020, METHOD_BUFFERED, FILE_READ_ACCESS)
#define SMART_SEND_DRIVE_COMMAND CTL_CODE(IOCTL_DISK_BASE, &h0021, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define SMART_RCV_DRIVE_DATA CTL_CODE(IOCTL_DISK_BASE, &h0022, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_GET_PARTITION_INFO_EX CTL_CODE(IOCTL_DISK_BASE, &h0012, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_SET_PARTITION_INFO_EX CTL_CODE(IOCTL_DISK_BASE, &h0013, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_GET_DRIVE_LAYOUT_EX CTL_CODE(IOCTL_DISK_BASE, &h0014, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_SET_DRIVE_LAYOUT_EX CTL_CODE(IOCTL_DISK_BASE, &h0015, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_CREATE_DISK CTL_CODE(IOCTL_DISK_BASE, &h0016, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_GET_LENGTH_INFO CTL_CODE(IOCTL_DISK_BASE, &h0017, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_GET_DRIVE_GEOMETRY_EX CTL_CODE(IOCTL_DISK_BASE, &h0028, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_REASSIGN_BLOCKS_EX CTL_CODE(IOCTL_DISK_BASE, &h0029, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_UPDATE_DRIVE_SIZE CTL_CODE(IOCTL_DISK_BASE, &h0032, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_GROW_PARTITION CTL_CODE(IOCTL_DISK_BASE, &h0034, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_GET_CACHE_INFORMATION CTL_CODE(IOCTL_DISK_BASE, &h0035, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_SET_CACHE_INFORMATION CTL_CODE(IOCTL_DISK_BASE, &h0036, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define OBSOLETE_DISK_GET_WRITE_CACHE_STATE CTL_CODE(IOCTL_DISK_BASE, &h0037, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_DELETE_DRIVE_LAYOUT CTL_CODE(IOCTL_DISK_BASE, &h0040, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_UPDATE_PROPERTIES CTL_CODE(IOCTL_DISK_BASE, &h0050, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_RESET_SNAPSHOT_INFO CTL_CODE(IOCTL_DISK_BASE, &h0084, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_FORMAT_DRIVE CTL_CODE(IOCTL_DISK_BASE, &h00f3, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_DISK_SENSE_DEVICE CTL_CODE(IOCTL_DISK_BASE, &h00f8, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_CHECK_VERIFY CTL_CODE(IOCTL_DISK_BASE, &h0200, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_MEDIA_REMOVAL CTL_CODE(IOCTL_DISK_BASE, &h0201, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_EJECT_MEDIA CTL_CODE(IOCTL_DISK_BASE, &h0202, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_LOAD_MEDIA CTL_CODE(IOCTL_DISK_BASE, &h0203, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_RESERVE CTL_CODE(IOCTL_DISK_BASE, &h0204, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_RELEASE CTL_CODE(IOCTL_DISK_BASE, &h0205, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_FIND_NEW_DEVICES CTL_CODE(IOCTL_DISK_BASE, &h0206, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_GET_MEDIA_TYPES CTL_CODE(IOCTL_DISK_BASE, &h0300, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_QUERY_PROPERTY CTL_CODE(IOCTL_STORAGE_BASE, &h0500, METHOD_BUFFERED, FILE_ANY_ACCESS)
const PARTITION_ENTRY_UNUSED = &h00
const PARTITION_FAT_12 = &h01
const PARTITION_XENIX_1 = &h02
const PARTITION_XENIX_2 = &h03
const PARTITION_FAT_16 = &h04
const PARTITION_EXTENDED = &h05
const PARTITION_HUGE = &h06
const PARTITION_IFS = &h07
const PARTITION_OS2BOOTMGR = &h0A
const PARTITION_FAT32 = &h0B
const PARTITION_FAT32_XINT13 = &h0C
const PARTITION_XINT13 = &h0E
const PARTITION_XINT13_EXTENDED = &h0F
const PARTITION_PREP = &h41
const PARTITION_LDM = &h42
const PARTITION_UNIX = &h63
const VALID_NTFT = &hC0
const PARTITION_NTFT = &h80
#define IsRecognizedPartition(PartitionType) ((((((((((((((PartitionType and PARTITION_NTFT) andalso ((PartitionType and (not &hC0)) = PARTITION_FAT_12)) orelse ((PartitionType and PARTITION_NTFT) andalso ((PartitionType and (not &hC0)) = PARTITION_IFS))) orelse ((PartitionType and PARTITION_NTFT) andalso ((PartitionType and (not &hC0)) = PARTITION_HUGE))) orelse ((PartitionType and PARTITION_NTFT) andalso ((PartitionType and (not &hC0)) = PARTITION_FAT32))) orelse ((PartitionType and PARTITION_NTFT) andalso ((PartitionType and (not &hC0)) = PARTITION_FAT32_XINT13))) orelse ((PartitionType and PARTITION_NTFT) andalso ((PartitionType and (not &hC0)) = PARTITION_XINT13))) orelse ((PartitionType) = PARTITION_FAT_12)) orelse ((PartitionType) = PARTITION_FAT_16)) orelse ((PartitionType) = PARTITION_IFS)) orelse ((PartitionType) = PARTITION_HUGE)) orelse ((PartitionType) = PARTITION_FAT32)) orelse ((PartitionType) = PARTITION_FAT32_XINT13)) orelse ((PartitionType) = PARTITION_XINT13))
#define IsContainerPartition(PartitionType) ((PartitionType = PARTITION_EXTENDED) orelse (PartitionType = PARTITION_XINT13_EXTENDED))
#define IsFTPartition(PartitionType) (((PartitionType) and PARTITION_NTFT) andalso IsRecognizedPartition(PartitionType))

type _MEDIA_TYPE as long
enum
	Unknown
	F5_1Pt2_512
	F3_1Pt44_512
	F3_2Pt88_512
	F3_20Pt8_512
	F3_720_512
	F5_360_512
	F5_320_512
	F5_320_1024
	F5_180_512
	F5_160_512
	RemovableMedia
	FixedMedia
	F3_120M_512
	F3_640_512
	F5_640_512
	F5_720_512
	F3_1Pt2_512
	F3_1Pt23_1024
	F5_1Pt23_1024
	F3_128Mb_512
	F3_230Mb_512
	F8_256_128
	F3_200Mb_512
	F3_240M_512
	F3_32M_512
end enum

type MEDIA_TYPE as _MEDIA_TYPE
type PMEDIA_TYPE as _MEDIA_TYPE ptr

type _FORMAT_PARAMETERS
	MediaType as MEDIA_TYPE
	StartCylinderNumber as DWORD
	EndCylinderNumber as DWORD
	StartHeadNumber as DWORD
	EndHeadNumber as DWORD
end type

type FORMAT_PARAMETERS as _FORMAT_PARAMETERS
type PFORMAT_PARAMETERS as _FORMAT_PARAMETERS ptr
type BAD_TRACK_NUMBER as WORD
type PBAD_TRACK_NUMBER as WORD ptr

type _FORMAT_EX_PARAMETERS
	MediaType as MEDIA_TYPE
	StartCylinderNumber as DWORD
	EndCylinderNumber as DWORD
	StartHeadNumber as DWORD
	EndHeadNumber as DWORD
	FormatGapLength as WORD
	SectorsPerTrack as WORD
	SectorNumber(0 to 0) as WORD
end type

type FORMAT_EX_PARAMETERS as _FORMAT_EX_PARAMETERS
type PFORMAT_EX_PARAMETERS as _FORMAT_EX_PARAMETERS ptr

type _DISK_GEOMETRY
	Cylinders as LARGE_INTEGER
	MediaType as MEDIA_TYPE
	TracksPerCylinder as DWORD
	SectorsPerTrack as DWORD
	BytesPerSector as DWORD
end type

type DISK_GEOMETRY as _DISK_GEOMETRY
type PDISK_GEOMETRY as _DISK_GEOMETRY ptr
#define WMI_DISK_GEOMETRY_GUID (&h25007f51, &h57c2, &h11d1, (&ha5, &h28, &h0, &ha0, &hc9, &h6, &h29, &h10))

type _PARTITION_INFORMATION
	StartingOffset as LARGE_INTEGER
	PartitionLength as LARGE_INTEGER
	HiddenSectors as DWORD
	PartitionNumber as DWORD
	PartitionType as UBYTE
	BootIndicator as WINBOOLEAN
	RecognizedPartition as WINBOOLEAN
	RewritePartition as WINBOOLEAN
end type

type PARTITION_INFORMATION as _PARTITION_INFORMATION
type PPARTITION_INFORMATION as _PARTITION_INFORMATION ptr

type _SET_PARTITION_INFORMATION
	PartitionType as UBYTE
end type

type SET_PARTITION_INFORMATION as _SET_PARTITION_INFORMATION
type PSET_PARTITION_INFORMATION as _SET_PARTITION_INFORMATION ptr

type _DRIVE_LAYOUT_INFORMATION
	PartitionCount as DWORD
	Signature as DWORD
	PartitionEntry(0 to 0) as PARTITION_INFORMATION
end type

type DRIVE_LAYOUT_INFORMATION as _DRIVE_LAYOUT_INFORMATION
type PDRIVE_LAYOUT_INFORMATION as _DRIVE_LAYOUT_INFORMATION ptr

type _VERIFY_INFORMATION
	StartingOffset as LARGE_INTEGER
	Length as DWORD
end type

type VERIFY_INFORMATION as _VERIFY_INFORMATION
type PVERIFY_INFORMATION as _VERIFY_INFORMATION ptr

type _REASSIGN_BLOCKS
	Reserved as WORD
	Count as WORD
	BlockNumber(0 to 0) as DWORD
end type

type REASSIGN_BLOCKS as _REASSIGN_BLOCKS
type PREASSIGN_BLOCKS as _REASSIGN_BLOCKS ptr

type _REASSIGN_BLOCKS_EX field = 1
	Reserved as WORD
	Count as WORD
	BlockNumber(0 to 0) as LARGE_INTEGER
end type

type REASSIGN_BLOCKS_EX as _REASSIGN_BLOCKS_EX
type PREASSIGN_BLOCKS_EX as _REASSIGN_BLOCKS_EX ptr

type _PARTITION_STYLE as long
enum
	PARTITION_STYLE_MBR
	PARTITION_STYLE_GPT
	PARTITION_STYLE_RAW
end enum

type PARTITION_STYLE as _PARTITION_STYLE

type _PARTITION_INFORMATION_GPT
	PartitionType as GUID
	PartitionId as GUID
	Attributes as DWORD64
	Name as wstring * 36
end type

type PARTITION_INFORMATION_GPT as _PARTITION_INFORMATION_GPT
type PPARTITION_INFORMATION_GPT as _PARTITION_INFORMATION_GPT ptr
const GPT_ATTRIBUTE_PLATFORM_REQUIRED = &h0000000000000001
const GPT_BASIC_DATA_ATTRIBUTE_NO_DRIVE_LETTER = &h8000000000000000
const GPT_BASIC_DATA_ATTRIBUTE_HIDDEN = &h4000000000000000
const GPT_BASIC_DATA_ATTRIBUTE_SHADOW_COPY = &h2000000000000000
const GPT_BASIC_DATA_ATTRIBUTE_READ_ONLY = &h1000000000000000

type _PARTITION_INFORMATION_MBR
	PartitionType as UBYTE
	BootIndicator as WINBOOLEAN
	RecognizedPartition as WINBOOLEAN
	HiddenSectors as DWORD
end type

type PARTITION_INFORMATION_MBR as _PARTITION_INFORMATION_MBR
type PPARTITION_INFORMATION_MBR as _PARTITION_INFORMATION_MBR ptr
type SET_PARTITION_INFORMATION_MBR as SET_PARTITION_INFORMATION
type SET_PARTITION_INFORMATION_GPT as PARTITION_INFORMATION_GPT

type _SET_PARTITION_INFORMATION_EX
	PartitionStyle as PARTITION_STYLE

	union
		Mbr as SET_PARTITION_INFORMATION_MBR
		Gpt as SET_PARTITION_INFORMATION_GPT
	end union
end type

type SET_PARTITION_INFORMATION_EX as _SET_PARTITION_INFORMATION_EX
type PSET_PARTITION_INFORMATION_EX as _SET_PARTITION_INFORMATION_EX ptr

type _CREATE_DISK_GPT
	DiskId as GUID
	MaxPartitionCount as DWORD
end type

type CREATE_DISK_GPT as _CREATE_DISK_GPT
type PCREATE_DISK_GPT as _CREATE_DISK_GPT ptr

type _CREATE_DISK_MBR
	Signature as DWORD
end type

type CREATE_DISK_MBR as _CREATE_DISK_MBR
type PCREATE_DISK_MBR as _CREATE_DISK_MBR ptr

type _CREATE_DISK
	PartitionStyle as PARTITION_STYLE

	union
		Mbr as CREATE_DISK_MBR
		Gpt as CREATE_DISK_GPT
	end union
end type

type CREATE_DISK as _CREATE_DISK
type PCREATE_DISK as _CREATE_DISK ptr

type _GET_LENGTH_INFORMATION
	Length as LARGE_INTEGER
end type

type GET_LENGTH_INFORMATION as _GET_LENGTH_INFORMATION
type PGET_LENGTH_INFORMATION as _GET_LENGTH_INFORMATION ptr

type _PARTITION_INFORMATION_EX
	PartitionStyle as PARTITION_STYLE
	StartingOffset as LARGE_INTEGER
	PartitionLength as LARGE_INTEGER
	PartitionNumber as DWORD
	RewritePartition as WINBOOLEAN

	union
		Mbr as PARTITION_INFORMATION_MBR
		Gpt as PARTITION_INFORMATION_GPT
	end union
end type

type PARTITION_INFORMATION_EX as _PARTITION_INFORMATION_EX
type PPARTITION_INFORMATION_EX as _PARTITION_INFORMATION_EX ptr

type _DRIVE_LAYOUT_INFORMATION_GPT
	DiskId as GUID
	StartingUsableOffset as LARGE_INTEGER
	UsableLength as LARGE_INTEGER
	MaxPartitionCount as DWORD
end type

type DRIVE_LAYOUT_INFORMATION_GPT as _DRIVE_LAYOUT_INFORMATION_GPT
type PDRIVE_LAYOUT_INFORMATION_GPT as _DRIVE_LAYOUT_INFORMATION_GPT ptr

type _DRIVE_LAYOUT_INFORMATION_MBR
	Signature as DWORD
end type

type DRIVE_LAYOUT_INFORMATION_MBR as _DRIVE_LAYOUT_INFORMATION_MBR
type PDRIVE_LAYOUT_INFORMATION_MBR as _DRIVE_LAYOUT_INFORMATION_MBR ptr

type _DRIVE_LAYOUT_INFORMATION_EX
	PartitionStyle as DWORD
	PartitionCount as DWORD

	union
		Mbr as DRIVE_LAYOUT_INFORMATION_MBR
		Gpt as DRIVE_LAYOUT_INFORMATION_GPT
	end union

	PartitionEntry(0 to 0) as PARTITION_INFORMATION_EX
end type

type DRIVE_LAYOUT_INFORMATION_EX as _DRIVE_LAYOUT_INFORMATION_EX
type PDRIVE_LAYOUT_INFORMATION_EX as _DRIVE_LAYOUT_INFORMATION_EX ptr

type _DETECTION_TYPE as long
enum
	DetectNone
	DetectInt13
	DetectExInt13
end enum

type DETECTION_TYPE as _DETECTION_TYPE

type _DISK_INT13_INFO
	DriveSelect as WORD
	MaxCylinders as DWORD
	SectorsPerTrack as WORD
	MaxHeads as WORD
	NumberDrives as WORD
end type

type DISK_INT13_INFO as _DISK_INT13_INFO
type PDISK_INT13_INFO as _DISK_INT13_INFO ptr

type _DISK_EX_INT13_INFO
	ExBufferSize as WORD
	ExFlags as WORD
	ExCylinders as DWORD
	ExHeads as DWORD
	ExSectorsPerTrack as DWORD
	ExSectorsPerDrive as DWORD64
	ExSectorSize as WORD
	ExReserved as WORD
end type

type DISK_EX_INT13_INFO as _DISK_EX_INT13_INFO
type PDISK_EX_INT13_INFO as _DISK_EX_INT13_INFO ptr

type _DISK_DETECTION_INFO
	SizeOfDetectInfo as DWORD
	DetectionType as DETECTION_TYPE

	union
		type
			Int13 as DISK_INT13_INFO
			ExInt13 as DISK_EX_INT13_INFO
		end type
	end union
end type

type DISK_DETECTION_INFO as _DISK_DETECTION_INFO
type PDISK_DETECTION_INFO as _DISK_DETECTION_INFO ptr

type _DISK_PARTITION_INFO_Mbr
	Signature as DWORD
	CheckSum as DWORD
end type

type _DISK_PARTITION_INFO_Gpt
	DiskId as GUID
end type

type _DISK_PARTITION_INFO
	SizeOfPartitionInfo as DWORD
	PartitionStyle as PARTITION_STYLE

	union
		Mbr as _DISK_PARTITION_INFO_Mbr
		Gpt as _DISK_PARTITION_INFO_Gpt
	end union
end type

type DISK_PARTITION_INFO as _DISK_PARTITION_INFO
type PDISK_PARTITION_INFO as _DISK_PARTITION_INFO ptr
#define DiskGeometryGetPartition(Geometry) cast(PDISK_PARTITION_INFO, (Geometry)->Data)
#define DiskGeometryGetDetect(Geometry) cast(PDISK_DETECTION_INFO, cast(DWORD_PTR, DiskGeometryGetPartition(Geometry)) + DiskGeometryGetPartition(Geometry)->SizeOfPartitionInfo)

type _DISK_GEOMETRY_EX
	Geometry as DISK_GEOMETRY
	DiskSize as LARGE_INTEGER
	Data(0 to 0) as UBYTE
end type

type DISK_GEOMETRY_EX as _DISK_GEOMETRY_EX
type PDISK_GEOMETRY_EX as _DISK_GEOMETRY_EX ptr

type _DISK_CONTROLLER_NUMBER
	ControllerNumber as DWORD
	DiskNumber as DWORD
end type

type DISK_CONTROLLER_NUMBER as _DISK_CONTROLLER_NUMBER
type PDISK_CONTROLLER_NUMBER as _DISK_CONTROLLER_NUMBER ptr

type DISK_CACHE_RETENTION_PRIORITY as long
enum
	EqualPriority
	KeepPrefetchedData
	KeepReadData
end enum

type _DISK_CACHE_INFORMATION_ScalarPrefetch
	Minimum as WORD
	Maximum as WORD
	MaximumBlocks as WORD
end type

type _DISK_CACHE_INFORMATION_BlockPrefetch
	Minimum as WORD
	Maximum as WORD
end type

type _DISK_CACHE_INFORMATION
	ParametersSavable as WINBOOLEAN
	ReadCacheEnabled as WINBOOLEAN
	WriteCacheEnabled as WINBOOLEAN
	ReadRetentionPriority as DISK_CACHE_RETENTION_PRIORITY
	WriteRetentionPriority as DISK_CACHE_RETENTION_PRIORITY
	DisablePrefetchTransferLength as WORD
	PrefetchScalar as WINBOOLEAN

	union
		ScalarPrefetch as _DISK_CACHE_INFORMATION_ScalarPrefetch
		BlockPrefetch as _DISK_CACHE_INFORMATION_BlockPrefetch
	end union
end type

type DISK_CACHE_INFORMATION as _DISK_CACHE_INFORMATION
type PDISK_CACHE_INFORMATION as _DISK_CACHE_INFORMATION ptr

type _DISK_GROW_PARTITION
	PartitionNumber as DWORD
	BytesToGrow as LARGE_INTEGER
end type

type DISK_GROW_PARTITION as _DISK_GROW_PARTITION
type PDISK_GROW_PARTITION as _DISK_GROW_PARTITION ptr
const HIST_NO_OF_BUCKETS = 24

type _HISTOGRAM_BUCKET
	Reads as DWORD
	Writes as DWORD
end type

type HISTOGRAM_BUCKET as _HISTOGRAM_BUCKET
type PHISTOGRAM_BUCKET as _HISTOGRAM_BUCKET ptr
#define HISTOGRAM_BUCKET_SIZE sizeof(HISTOGRAM_BUCKET)

type _DISK_HISTOGRAM
	DiskSize as LARGE_INTEGER
	Start as LARGE_INTEGER
	as LARGE_INTEGER End
	Average as LARGE_INTEGER
	AverageRead as LARGE_INTEGER
	AverageWrite as LARGE_INTEGER
	Granularity as DWORD
	Size as DWORD
	ReadCount as DWORD
	WriteCount as DWORD
	Histogram as PHISTOGRAM_BUCKET
end type

type DISK_HISTOGRAM as _DISK_HISTOGRAM
type PDISK_HISTOGRAM as _DISK_HISTOGRAM ptr
#define DISK_HISTOGRAM_SIZE sizeof(DISK_HISTOGRAM)

type _DISK_PERFORMANCE
	BytesRead as LARGE_INTEGER
	BytesWritten as LARGE_INTEGER
	ReadTime as LARGE_INTEGER
	WriteTime as LARGE_INTEGER
	IdleTime as LARGE_INTEGER
	ReadCount as DWORD
	WriteCount as DWORD
	QueueDepth as DWORD
	SplitCount as DWORD
	QueryTime as LARGE_INTEGER
	StorageDeviceNumber as DWORD
	StorageManagerName as wstring * 8
end type

type DISK_PERFORMANCE as _DISK_PERFORMANCE
type PDISK_PERFORMANCE as _DISK_PERFORMANCE ptr

type _DISK_RECORD
	ByteOffset as LARGE_INTEGER
	StartTime as LARGE_INTEGER
	EndTime as LARGE_INTEGER
	VirtualAddress as PVOID
	NumberOfBytes as DWORD
	DeviceNumber as UBYTE
	ReadRequest as WINBOOLEAN
end type

type DISK_RECORD as _DISK_RECORD
type PDISK_RECORD as _DISK_RECORD ptr

type _DISK_LOGGING
	Function as UBYTE
	BufferAddress as PVOID
	BufferSize as DWORD
end type

type DISK_LOGGING as _DISK_LOGGING
type PDISK_LOGGING as _DISK_LOGGING ptr
const DISK_LOGGING_START = 0
const DISK_LOGGING_STOP = 1
const DISK_LOGGING_DUMP = 2
const DISK_BINNING = 3

type _BIN_TYPES as long
enum
	RequestSize
	RequestLocation
end enum

type BIN_TYPES as _BIN_TYPES

type _BIN_RANGE
	StartValue as LARGE_INTEGER
	Length as LARGE_INTEGER
end type

type BIN_RANGE as _BIN_RANGE
type PBIN_RANGE as _BIN_RANGE ptr

type _PERF_BIN
	NumberOfBins as DWORD
	TypeOfBin as DWORD
	BinsRanges(0 to 0) as BIN_RANGE
end type

type PERF_BIN as _PERF_BIN
type PPERF_BIN as _PERF_BIN ptr

type _BIN_COUNT
	BinRange as BIN_RANGE
	BinCount as DWORD
end type

type BIN_COUNT as _BIN_COUNT
type PBIN_COUNT as _BIN_COUNT ptr

type _BIN_RESULTS
	NumberOfBins as DWORD
	BinCounts(0 to 0) as BIN_COUNT
end type

type BIN_RESULTS as _BIN_RESULTS
type PBIN_RESULTS as _BIN_RESULTS ptr

type _GETVERSIONINPARAMS field = 1
	bVersion as UBYTE
	bRevision as UBYTE
	bReserved as UBYTE
	bIDEDeviceMap as UBYTE
	fCapabilities as DWORD
	dwReserved(0 to 3) as DWORD
end type

type GETVERSIONINPARAMS as _GETVERSIONINPARAMS
type PGETVERSIONINPARAMS as _GETVERSIONINPARAMS ptr
type LPGETVERSIONINPARAMS as _GETVERSIONINPARAMS ptr

const CAP_ATA_ID_CMD = 1
const CAP_ATAPI_ID_CMD = 2
const CAP_SMART_CMD = 4

type _IDEREGS field = 1
	bFeaturesReg as UBYTE
	bSectorCountReg as UBYTE
	bSectorNumberReg as UBYTE
	bCylLowReg as UBYTE
	bCylHighReg as UBYTE
	bDriveHeadReg as UBYTE
	bCommandReg as UBYTE
	bReserved as UBYTE
end type

type IDEREGS as _IDEREGS
type PIDEREGS as _IDEREGS ptr
type LPIDEREGS as _IDEREGS ptr

const ATAPI_ID_CMD = &hA1
const ID_CMD = &hEC
const SMART_CMD = &hB0
const SMART_CYL_LOW = &h4F
const SMART_CYL_HI = &hC2

type _SENDCMDINPARAMS field = 1
	cBufferSize as DWORD
	irDriveRegs as IDEREGS
	bDriveNumber as UBYTE
	bReserved(0 to 2) as UBYTE
	dwReserved(0 to 3) as DWORD
	bBuffer(0 to 0) as UBYTE
end type

type SENDCMDINPARAMS as _SENDCMDINPARAMS
type PSENDCMDINPARAMS as _SENDCMDINPARAMS ptr
type LPSENDCMDINPARAMS as _SENDCMDINPARAMS ptr

type _DRIVERSTATUS field = 1
	bDriverError as UBYTE
	bIDEError as UBYTE
	bReserved(0 to 1) as UBYTE
	dwReserved(0 to 1) as DWORD
end type

type DRIVERSTATUS as _DRIVERSTATUS
type PDRIVERSTATUS as _DRIVERSTATUS ptr
type LPDRIVERSTATUS as _DRIVERSTATUS ptr

const SMART_NO_ERROR = 0
const SMART_IDE_ERROR = 1
const SMART_INVALID_FLAG = 2
const SMART_INVALID_COMMAND = 3
const SMART_INVALID_BUFFER = 4
const SMART_INVALID_DRIVE = 5
const SMART_INVALID_IOCTL = 6
const SMART_ERROR_NO_MEM = 7
const SMART_INVALID_REGISTER = 8
const SMART_NOT_SUPPORTED = 9
const SMART_NO_IDE_DEVICE = 10
const SMART_OFFLINE_ROUTINE_OFFLINE = 0
const SMART_SHORT_SELFTEST_OFFLINE = 1
const SMART_EXTENDED_SELFTEST_OFFLINE = 2
const SMART_ABORT_OFFLINE_SELFTEST = 127
const SMART_SHORT_SELFTEST_CAPTIVE = 129
const SMART_EXTENDED_SELFTEST_CAPTIVE = 130

type _SENDCMDOUTPARAMS field = 1
	cBufferSize as DWORD
	DriverStatus as DRIVERSTATUS
	bBuffer(0 to 0) as UBYTE
end type

type SENDCMDOUTPARAMS as _SENDCMDOUTPARAMS
type PSENDCMDOUTPARAMS as _SENDCMDOUTPARAMS ptr
type LPSENDCMDOUTPARAMS as _SENDCMDOUTPARAMS ptr

const READ_ATTRIBUTE_BUFFER_SIZE = 512
const IDENTIFY_BUFFER_SIZE = 512
const READ_THRESHOLD_BUFFER_SIZE = 512
const SMART_LOG_SECTOR_SIZE = 512
const READ_ATTRIBUTES = &hD0
const READ_THRESHOLDS = &hD1
const ENABLE_DISABLE_AUTOSAVE = &hD2
const SAVE_ATTRIBUTE_VALUES = &hD3
const EXECUTE_OFFLINE_DIAGS = &hD4
const SMART_READ_LOG = &hD5
const SMART_WRITE_LOG = &hd6
const ENABLE_SMART = &hD8
const DISABLE_SMART = &hD9
const RETURN_SMART_STATUS = &hDA
const ENABLE_DISABLE_AUTO_OFFLINE = &hDB
const IOCTL_CHANGER_BASE = FILE_DEVICE_CHANGER
#define IOCTL_CHANGER_GET_PARAMETERS CTL_CODE(IOCTL_CHANGER_BASE, &h0000, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_GET_STATUS CTL_CODE(IOCTL_CHANGER_BASE, &h0001, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_GET_PRODUCT_DATA CTL_CODE(IOCTL_CHANGER_BASE, &h0002, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_SET_ACCESS CTL_CODE(IOCTL_CHANGER_BASE, &h0004, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_CHANGER_GET_ELEMENT_STATUS CTL_CODE(IOCTL_CHANGER_BASE, &h0005, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_CHANGER_INITIALIZE_ELEMENT_STATUS CTL_CODE(IOCTL_CHANGER_BASE, &h0006, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_SET_POSITION CTL_CODE(IOCTL_CHANGER_BASE, &h0007, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_EXCHANGE_MEDIUM CTL_CODE(IOCTL_CHANGER_BASE, &h0008, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_MOVE_MEDIUM CTL_CODE(IOCTL_CHANGER_BASE, &h0009, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_REINITIALIZE_TRANSPORT CTL_CODE(IOCTL_CHANGER_BASE, &h000A, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CHANGER_QUERY_VOLUME_TAGS CTL_CODE(IOCTL_CHANGER_BASE, &h000B, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
const MAX_VOLUME_ID_SIZE = 36
const MAX_VOLUME_TEMPLATE_SIZE = 40
const VENDOR_ID_LENGTH = 8
const PRODUCT_ID_LENGTH = 16
const REVISION_LENGTH = 4
const SERIAL_NUMBER_LENGTH = 32

type _ELEMENT_TYPE as long
enum
	AllElements
	ChangerTransport
	ChangerSlot
	ChangerIEPort
	ChangerDrive
	ChangerDoor
	ChangerKeypad
	ChangerMaxElement
end enum

type ELEMENT_TYPE as _ELEMENT_TYPE
type PELEMENT_TYPE as _ELEMENT_TYPE ptr

type _CHANGER_ELEMENT
	ElementType as ELEMENT_TYPE
	ElementAddress as DWORD
end type

type CHANGER_ELEMENT as _CHANGER_ELEMENT
type PCHANGER_ELEMENT as _CHANGER_ELEMENT ptr

type _CHANGER_ELEMENT_LIST
	Element as CHANGER_ELEMENT
	NumberOfElements as DWORD
end type

type CHANGER_ELEMENT_LIST as _CHANGER_ELEMENT_LIST
type PCHANGER_ELEMENT_LIST as _CHANGER_ELEMENT_LIST ptr
const CHANGER_BAR_CODE_SCANNER_INSTALLED = &h00000001
const CHANGER_INIT_ELEM_STAT_WITH_RANGE = &h00000002
const CHANGER_CLOSE_IEPORT = &h00000004
const CHANGER_OPEN_IEPORT = &h00000008
const CHANGER_STATUS_NON_VOLATILE = &h00000010
const CHANGER_EXCHANGE_MEDIA = &h00000020
const CHANGER_CLEANER_SLOT = &h00000040
const CHANGER_LOCK_UNLOCK = &h00000080
const CHANGER_CARTRIDGE_MAGAZINE = &h00000100
const CHANGER_MEDIUM_FLIP = &h00000200
const CHANGER_POSITION_TO_ELEMENT = &h00000400
const CHANGER_REPORT_IEPORT_STATE = &h00000800
const CHANGER_STORAGE_DRIVE = &h00001000
const CHANGER_STORAGE_IEPORT = &h00002000
const CHANGER_STORAGE_SLOT = &h00004000
const CHANGER_STORAGE_TRANSPORT = &h00008000
const CHANGER_DRIVE_CLEANING_REQUIRED = &h00010000
const CHANGER_PREDISMOUNT_EJECT_REQUIRED = &h00020000
const CHANGER_CLEANER_ACCESS_NOT_VALID = &h00040000
const CHANGER_PREMOUNT_EJECT_REQUIRED = &h00080000
const CHANGER_VOLUME_IDENTIFICATION = &h00100000
const CHANGER_VOLUME_SEARCH = &h00200000
const CHANGER_VOLUME_ASSERT = &h00400000
const CHANGER_VOLUME_REPLACE = &h00800000
const CHANGER_VOLUME_UNDEFINE = &h01000000
const CHANGER_SERIAL_NUMBER_VALID = &h04000000
const CHANGER_DEVICE_REINITIALIZE_CAPABLE = &h08000000
const CHANGER_KEYPAD_ENABLE_DISABLE = &h10000000
const CHANGER_DRIVE_EMPTY_ON_DOOR_ACCESS = &h20000000
const CHANGER_RESERVED_BIT = &h80000000
const CHANGER_PREDISMOUNT_ALIGN_TO_SLOT = &h80000001
const CHANGER_PREDISMOUNT_ALIGN_TO_DRIVE = &h80000002
const CHANGER_CLEANER_AUTODISMOUNT = &h80000004
const CHANGER_TRUE_EXCHANGE_CAPABLE = &h80000008
const CHANGER_SLOTS_USE_TRAYS = &h80000010
const CHANGER_RTN_MEDIA_TO_ORIGINAL_ADDR = &h80000020
const CHANGER_CLEANER_OPS_NOT_SUPPORTED = &h80000040
const CHANGER_IEPORT_USER_CONTROL_OPEN = &h80000080
const CHANGER_IEPORT_USER_CONTROL_CLOSE = &h80000100
const CHANGER_MOVE_EXTENDS_IEPORT = &h80000200
const CHANGER_MOVE_RETRACTS_IEPORT = &h80000400
const CHANGER_TO_TRANSPORT = &h01
const CHANGER_TO_SLOT = &h02
const CHANGER_TO_IEPORT = &h04
const CHANGER_TO_DRIVE = &h08
const LOCK_UNLOCK_IEPORT = &h01
const LOCK_UNLOCK_DOOR = &h02
const LOCK_UNLOCK_KEYPAD = &h04

type _GET_CHANGER_PARAMETERS
	Size as DWORD
	NumberTransportElements as WORD
	NumberStorageElements as WORD
	NumberCleanerSlots as WORD
	NumberIEElements as WORD
	NumberDataTransferElements as WORD
	NumberOfDoors as WORD
	FirstSlotNumber as WORD
	FirstDriveNumber as WORD
	FirstTransportNumber as WORD
	FirstIEPortNumber as WORD
	FirstCleanerSlotAddress as WORD
	MagazineSize as WORD
	DriveCleanTimeout as DWORD
	Features0 as DWORD
	Features1 as DWORD
	MoveFromTransport as UBYTE
	MoveFromSlot as UBYTE
	MoveFromIePort as UBYTE
	MoveFromDrive as UBYTE
	ExchangeFromTransport as UBYTE
	ExchangeFromSlot as UBYTE
	ExchangeFromIePort as UBYTE
	ExchangeFromDrive as UBYTE
	LockUnlockCapabilities as UBYTE
	PositionCapabilities as UBYTE
	Reserved1(0 to 1) as UBYTE
	Reserved2(0 to 1) as DWORD
end type

type GET_CHANGER_PARAMETERS as _GET_CHANGER_PARAMETERS
type PGET_CHANGER_PARAMETERS as _GET_CHANGER_PARAMETERS ptr

type _CHANGER_PRODUCT_DATA
	VendorId(0 to 7) as UBYTE
	ProductId(0 to 15) as UBYTE
	Revision(0 to 3) as UBYTE
	SerialNumber(0 to 31) as UBYTE
	DeviceType as UBYTE
end type

type CHANGER_PRODUCT_DATA as _CHANGER_PRODUCT_DATA
type PCHANGER_PRODUCT_DATA as _CHANGER_PRODUCT_DATA ptr
const LOCK_ELEMENT = 0
const UNLOCK_ELEMENT = 1
const EXTEND_IEPORT = 2
const RETRACT_IEPORT = 3

type _CHANGER_SET_ACCESS
	Element as CHANGER_ELEMENT
	Control as DWORD
end type

type CHANGER_SET_ACCESS as _CHANGER_SET_ACCESS
type PCHANGER_SET_ACCESS as _CHANGER_SET_ACCESS ptr

type _CHANGER_READ_ELEMENT_STATUS
	ElementList as CHANGER_ELEMENT_LIST
	VolumeTagInfo as WINBOOLEAN
end type

type CHANGER_READ_ELEMENT_STATUS as _CHANGER_READ_ELEMENT_STATUS
type PCHANGER_READ_ELEMENT_STATUS as _CHANGER_READ_ELEMENT_STATUS ptr

type _CHANGER_ELEMENT_STATUS
	Element as CHANGER_ELEMENT
	SrcElementAddress as CHANGER_ELEMENT
	Flags as DWORD
	ExceptionCode as DWORD
	TargetId as UBYTE
	Lun as UBYTE
	Reserved as WORD
	PrimaryVolumeID(0 to 35) as UBYTE
	AlternateVolumeID(0 to 35) as UBYTE
end type

type CHANGER_ELEMENT_STATUS as _CHANGER_ELEMENT_STATUS
type PCHANGER_ELEMENT_STATUS as _CHANGER_ELEMENT_STATUS ptr

type _CHANGER_ELEMENT_STATUS_EX
	Element as CHANGER_ELEMENT
	SrcElementAddress as CHANGER_ELEMENT
	Flags as DWORD
	ExceptionCode as DWORD
	TargetId as UBYTE
	Lun as UBYTE
	Reserved as WORD
	PrimaryVolumeID(0 to 35) as UBYTE
	AlternateVolumeID(0 to 35) as UBYTE
	VendorIdentification(0 to 7) as UBYTE
	ProductIdentification(0 to 15) as UBYTE
	SerialNumber(0 to 31) as UBYTE
end type

type CHANGER_ELEMENT_STATUS_EX as _CHANGER_ELEMENT_STATUS_EX
type PCHANGER_ELEMENT_STATUS_EX as _CHANGER_ELEMENT_STATUS_EX ptr
const ELEMENT_STATUS_FULL = &h00000001
const ELEMENT_STATUS_IMPEXP = &h00000002
const ELEMENT_STATUS_EXCEPT = &h00000004
const ELEMENT_STATUS_ACCESS = &h00000008
const ELEMENT_STATUS_EXENAB = &h00000010
const ELEMENT_STATUS_INENAB = &h00000020
const ELEMENT_STATUS_PRODUCT_DATA = &h00000040
const ELEMENT_STATUS_LUN_VALID = &h00001000
const ELEMENT_STATUS_ID_VALID = &h00002000
const ELEMENT_STATUS_NOT_BUS = &h00008000
const ELEMENT_STATUS_INVERT = &h00400000
const ELEMENT_STATUS_SVALID = &h00800000
const ELEMENT_STATUS_PVOLTAG = &h10000000
const ELEMENT_STATUS_AVOLTAG = &h20000000
const ERROR_LABEL_UNREADABLE = &h00000001
const ERROR_LABEL_QUESTIONABLE = &h00000002
const ERROR_SLOT_NOT_PRESENT = &h00000004
const ERROR_DRIVE_NOT_INSTALLED = &h00000008
const ERROR_TRAY_MALFUNCTION = &h00000010
const ERROR_INIT_STATUS_NEEDED = &h00000011
const ERROR_UNHANDLED_ERROR = &hFFFFFFFF

type _CHANGER_INITIALIZE_ELEMENT_STATUS
	ElementList as CHANGER_ELEMENT_LIST
	BarCodeScan as WINBOOLEAN
end type

type CHANGER_INITIALIZE_ELEMENT_STATUS as _CHANGER_INITIALIZE_ELEMENT_STATUS
type PCHANGER_INITIALIZE_ELEMENT_STATUS as _CHANGER_INITIALIZE_ELEMENT_STATUS ptr

type _CHANGER_SET_POSITION
	Transport as CHANGER_ELEMENT
	Destination as CHANGER_ELEMENT
	Flip as WINBOOLEAN
end type

type CHANGER_SET_POSITION as _CHANGER_SET_POSITION
type PCHANGER_SET_POSITION as _CHANGER_SET_POSITION ptr

type _CHANGER_EXCHANGE_MEDIUM
	Transport as CHANGER_ELEMENT
	Source as CHANGER_ELEMENT
	Destination1 as CHANGER_ELEMENT
	Destination2 as CHANGER_ELEMENT
	Flip1 as WINBOOLEAN
	Flip2 as WINBOOLEAN
end type

type CHANGER_EXCHANGE_MEDIUM as _CHANGER_EXCHANGE_MEDIUM
type PCHANGER_EXCHANGE_MEDIUM as _CHANGER_EXCHANGE_MEDIUM ptr

type _CHANGER_MOVE_MEDIUM
	Transport as CHANGER_ELEMENT
	Source as CHANGER_ELEMENT
	Destination as CHANGER_ELEMENT
	Flip as WINBOOLEAN
end type

type CHANGER_MOVE_MEDIUM as _CHANGER_MOVE_MEDIUM
type PCHANGER_MOVE_MEDIUM as _CHANGER_MOVE_MEDIUM ptr

type _CHANGER_SEND_VOLUME_TAG_INFORMATION
	StartingElement as CHANGER_ELEMENT
	ActionCode as DWORD
	VolumeIDTemplate(0 to 39) as UBYTE
end type

type CHANGER_SEND_VOLUME_TAG_INFORMATION as _CHANGER_SEND_VOLUME_TAG_INFORMATION
type PCHANGER_SEND_VOLUME_TAG_INFORMATION as _CHANGER_SEND_VOLUME_TAG_INFORMATION ptr

type _READ_ELEMENT_ADDRESS_INFO
	NumberOfElements as DWORD
	ElementStatus(0 to 0) as CHANGER_ELEMENT_STATUS
end type

type READ_ELEMENT_ADDRESS_INFO as _READ_ELEMENT_ADDRESS_INFO
type PREAD_ELEMENT_ADDRESS_INFO as _READ_ELEMENT_ADDRESS_INFO ptr
const SEARCH_ALL = &h0
const SEARCH_PRIMARY = &h1
const SEARCH_ALTERNATE = &h2
const SEARCH_ALL_NO_SEQ = &h4
const SEARCH_PRI_NO_SEQ = &h5
const SEARCH_ALT_NO_SEQ = &h6
const ASSERT_PRIMARY = &h8
const ASSERT_ALTERNATE = &h9
const REPLACE_PRIMARY = &hA
const REPLACE_ALTERNATE = &hB
const UNDEFINE_PRIMARY = &hC
const UNDEFINE_ALTERNATE = &hD

type _CHANGER_DEVICE_PROBLEM_TYPE as long
enum
	DeviceProblemNone
	DeviceProblemHardware
	DeviceProblemCHMError
	DeviceProblemDoorOpen
	DeviceProblemCalibrationError
	DeviceProblemTargetFailure
	DeviceProblemCHMMoveError
	DeviceProblemCHMZeroError
	DeviceProblemCartridgeInsertError
	DeviceProblemPositionError
	DeviceProblemSensorError
	DeviceProblemCartridgeEjectError
	DeviceProblemGripperError
	DeviceProblemDriveError
end enum

type CHANGER_DEVICE_PROBLEM_TYPE as _CHANGER_DEVICE_PROBLEM_TYPE
type PCHANGER_DEVICE_PROBLEM_TYPE as _CHANGER_DEVICE_PROBLEM_TYPE ptr
#define IOCTL_SERIAL_LSRMST_INSERT CTL_CODE(FILE_DEVICE_SERIAL_PORT, 31, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SERENUM_EXPOSE_HARDWARE CTL_CODE(FILE_DEVICE_SERENUM, 128, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SERENUM_REMOVE_HARDWARE CTL_CODE(FILE_DEVICE_SERENUM, 129, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SERENUM_PORT_DESC CTL_CODE(FILE_DEVICE_SERENUM, 130, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SERENUM_GET_PORT_NAME CTL_CODE(FILE_DEVICE_SERENUM, 131, METHOD_BUFFERED, FILE_ANY_ACCESS)
const SERIAL_LSRMST_ESCAPE = cast(UBYTE, &h00)
const SERIAL_LSRMST_LSR_DATA = cast(UBYTE, &h01)
const SERIAL_LSRMST_LSR_NODATA = cast(UBYTE, &h02)
const SERIAL_LSRMST_MST = cast(UBYTE, &h03)
const SERIAL_IOC_FCR_FIFO_ENABLE = cast(DWORD, &h00000001)
const SERIAL_IOC_FCR_RCVR_RESET = cast(DWORD, &h00000002)
const SERIAL_IOC_FCR_XMIT_RESET = cast(DWORD, &h00000004)
const SERIAL_IOC_FCR_DMA_MODE = cast(DWORD, &h00000008)
const SERIAL_IOC_FCR_RES1 = cast(DWORD, &h00000010)
const SERIAL_IOC_FCR_RES2 = cast(DWORD, &h00000020)
const SERIAL_IOC_FCR_RCVR_TRIGGER_LSB = cast(DWORD, &h00000040)
const SERIAL_IOC_FCR_RCVR_TRIGGER_MSB = cast(DWORD, &h00000080)
const SERIAL_IOC_MCR_DTR = cast(DWORD, &h00000001)
const SERIAL_IOC_MCR_RTS = cast(DWORD, &h00000002)
const SERIAL_IOC_MCR_OUT1 = cast(DWORD, &h00000004)
const SERIAL_IOC_MCR_OUT2 = cast(DWORD, &h00000008)
const SERIAL_IOC_MCR_LOOP = cast(DWORD, &h00000010)
#define _FILESYSTEMFSCTL_
#define FSCTL_REQUEST_OPLOCK_LEVEL_1 CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 0, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_REQUEST_OPLOCK_LEVEL_2 CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 1, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_REQUEST_BATCH_OPLOCK CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 2, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_OPLOCK_BREAK_ACKNOWLEDGE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 3, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_OPBATCH_ACK_CLOSE_PENDING CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 4, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_OPLOCK_BREAK_NOTIFY CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 5, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_LOCK_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 6, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_UNLOCK_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 7, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_DISMOUNT_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 8, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_IS_VOLUME_MOUNTED CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 10, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_IS_PATHNAME_VALID CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 11, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_MARK_VOLUME_DIRTY CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 12, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_QUERY_RETRIEVAL_POINTERS CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 14, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_GET_COMPRESSION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 15, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_SET_COMPRESSION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 16, METHOD_BUFFERED, FILE_READ_DATA or FILE_WRITE_DATA)
#define FSCTL_MARK_AS_SYSTEM_HIVE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 19, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_OPLOCK_BREAK_ACK_NO_2 CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 20, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_INVALIDATE_VOLUMES CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 21, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_QUERY_FAT_BPB CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 22, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_REQUEST_FILTER_OPLOCK CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 23, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_FILESYSTEM_GET_STATISTICS CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 24, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_GET_NTFS_VOLUME_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 25, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_GET_NTFS_FILE_RECORD CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 26, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_GET_VOLUME_BITMAP CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 27, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_GET_RETRIEVAL_POINTERS CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 28, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_MOVE_FILE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 29, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
#define FSCTL_IS_VOLUME_DIRTY CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 30, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_ALLOW_EXTENDED_DASD_IO CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 32, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_FIND_FILES_BY_SID CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 35, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_SET_OBJECT_ID CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 38, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
#define FSCTL_GET_OBJECT_ID CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 39, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_DELETE_OBJECT_ID CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 40, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
#define FSCTL_SET_REPARSE_POINT CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 41, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
#define FSCTL_GET_REPARSE_POINT CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 42, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_DELETE_REPARSE_POINT CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 43, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
#define FSCTL_ENUM_USN_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 44, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_SECURITY_ID_CHECK CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 45, METHOD_NEITHER, FILE_READ_DATA)
#define FSCTL_READ_USN_JOURNAL CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 46, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_SET_OBJECT_ID_EXTENDED CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 47, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
#define FSCTL_CREATE_OR_GET_OBJECT_ID CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 48, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_SET_SPARSE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 49, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
#define FSCTL_SET_ZERO_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 50, METHOD_BUFFERED, FILE_WRITE_DATA)
#define FSCTL_QUERY_ALLOCATED_RANGES CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 51, METHOD_NEITHER, FILE_READ_DATA)
#define FSCTL_SET_ENCRYPTION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 53, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_ENCRYPTION_FSCTL_IO CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 54, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_WRITE_RAW_ENCRYPTED CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 55, METHOD_NEITHER, FILE_SPECIAL_ACCESS)
#define FSCTL_READ_RAW_ENCRYPTED CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 56, METHOD_NEITHER, FILE_SPECIAL_ACCESS)
#define FSCTL_CREATE_USN_JOURNAL CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 57, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_READ_FILE_USN_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 58, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_WRITE_USN_CLOSE_RECORD CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 59, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_EXTEND_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 60, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_QUERY_USN_JOURNAL CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 61, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_DELETE_USN_JOURNAL CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 62, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_MARK_HANDLE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 63, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_SIS_COPYFILE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 64, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_SIS_LINK_FILES CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 65, METHOD_BUFFERED, FILE_READ_DATA or FILE_WRITE_DATA)
#define FSCTL_HSM_MSG CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 66, METHOD_BUFFERED, FILE_READ_DATA or FILE_WRITE_DATA)
#define FSCTL_HSM_DATA CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 68, METHOD_NEITHER, FILE_READ_DATA or FILE_WRITE_DATA)
#define FSCTL_RECALL_FILE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 69, METHOD_NEITHER, FILE_ANY_ACCESS)
#define FSCTL_READ_FROM_PLEX CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 71, METHOD_OUT_DIRECT, FILE_READ_DATA)
#define FSCTL_FILE_PREFETCH CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 72, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)

type _PATHNAME_BUFFER
	PathNameLength as DWORD
	Name as wstring * 1
end type

type PATHNAME_BUFFER as _PATHNAME_BUFFER
type PPATHNAME_BUFFER as _PATHNAME_BUFFER ptr

type _FSCTL_QUERY_FAT_BPB_BUFFER
	First0x24BytesOfBootSector(0 to 35) as UBYTE
end type

type FSCTL_QUERY_FAT_BPB_BUFFER as _FSCTL_QUERY_FAT_BPB_BUFFER
type PFSCTL_QUERY_FAT_BPB_BUFFER as _FSCTL_QUERY_FAT_BPB_BUFFER ptr

type NTFS_VOLUME_DATA_BUFFER
	VolumeSerialNumber as LARGE_INTEGER
	NumberSectors as LARGE_INTEGER
	TotalClusters as LARGE_INTEGER
	FreeClusters as LARGE_INTEGER
	TotalReserved as LARGE_INTEGER
	BytesPerSector as DWORD
	BytesPerCluster as DWORD
	BytesPerFileRecordSegment as DWORD
	ClustersPerFileRecordSegment as DWORD
	MftValidDataLength as LARGE_INTEGER
	MftStartLcn as LARGE_INTEGER
	Mft2StartLcn as LARGE_INTEGER
	MftZoneStart as LARGE_INTEGER
	MftZoneEnd as LARGE_INTEGER
end type

type PNTFS_VOLUME_DATA_BUFFER as NTFS_VOLUME_DATA_BUFFER ptr

type NTFS_EXTENDED_VOLUME_DATA
	ByteCount as DWORD
	MajorVersion as WORD
	MinorVersion as WORD
end type

type PNTFS_EXTENDED_VOLUME_DATA as NTFS_EXTENDED_VOLUME_DATA ptr

type STARTING_LCN_INPUT_BUFFER
	StartingLcn as LARGE_INTEGER
end type

type PSTARTING_LCN_INPUT_BUFFER as STARTING_LCN_INPUT_BUFFER ptr

type VOLUME_BITMAP_BUFFER
	StartingLcn as LARGE_INTEGER
	BitmapSize as LARGE_INTEGER
	Buffer(0 to 0) as UBYTE
end type

type PVOLUME_BITMAP_BUFFER as VOLUME_BITMAP_BUFFER ptr

type STARTING_VCN_INPUT_BUFFER
	StartingVcn as LARGE_INTEGER
end type

type PSTARTING_VCN_INPUT_BUFFER as STARTING_VCN_INPUT_BUFFER ptr

type RETRIEVAL_POINTERS_BUFFER_Extents
	NextVcn as LARGE_INTEGER
	Lcn as LARGE_INTEGER
end type

type RETRIEVAL_POINTERS_BUFFER
	ExtentCount as DWORD
	StartingVcn as LARGE_INTEGER
	Extents(0 to 0) as RETRIEVAL_POINTERS_BUFFER_Extents
end type

type PRETRIEVAL_POINTERS_BUFFER as RETRIEVAL_POINTERS_BUFFER ptr

type NTFS_FILE_RECORD_INPUT_BUFFER
	FileReferenceNumber as LARGE_INTEGER
end type

type PNTFS_FILE_RECORD_INPUT_BUFFER as NTFS_FILE_RECORD_INPUT_BUFFER ptr

type NTFS_FILE_RECORD_OUTPUT_BUFFER
	FileReferenceNumber as LARGE_INTEGER
	FileRecordLength as DWORD
	FileRecordBuffer(0 to 0) as UBYTE
end type

type PNTFS_FILE_RECORD_OUTPUT_BUFFER as NTFS_FILE_RECORD_OUTPUT_BUFFER ptr

type MOVE_FILE_DATA
	FileHandle as HANDLE
	StartingVcn as LARGE_INTEGER
	StartingLcn as LARGE_INTEGER
	ClusterCount as DWORD
end type

type PMOVE_FILE_DATA as MOVE_FILE_DATA ptr

#ifdef __FB_64BIT__
	type _MOVE_FILE_DATA32
		FileHandle as UINT32
		StartingVcn as LARGE_INTEGER
		StartingLcn as LARGE_INTEGER
		ClusterCount as DWORD
	end type

	type MOVE_FILE_DATA32 as _MOVE_FILE_DATA32
	type PMOVE_FILE_DATA32 as _MOVE_FILE_DATA32 ptr
#endif

type FIND_BY_SID_DATA
	Restart as DWORD
	Sid as SID
end type

type PFIND_BY_SID_DATA as FIND_BY_SID_DATA ptr

type FIND_BY_SID_OUTPUT
	NextEntryOffset as DWORD
	FileIndex as DWORD
	FileNameLength as DWORD
	FileName as wstring * 1
end type

type PFIND_BY_SID_OUTPUT as FIND_BY_SID_OUTPUT ptr

type MFT_ENUM_DATA
	StartFileReferenceNumber as DWORDLONG
	LowUsn as USN
	HighUsn as USN
end type

type PMFT_ENUM_DATA as MFT_ENUM_DATA ptr

type CREATE_USN_JOURNAL_DATA
	MaximumSize as DWORDLONG
	AllocationDelta as DWORDLONG
end type

type PCREATE_USN_JOURNAL_DATA as CREATE_USN_JOURNAL_DATA ptr

type READ_USN_JOURNAL_DATA
	StartUsn as USN
	ReasonMask as DWORD
	ReturnOnlyOnClose as DWORD
	Timeout as DWORDLONG
	BytesToWaitFor as DWORDLONG
	UsnJournalID as DWORDLONG
end type

type PREAD_USN_JOURNAL_DATA as READ_USN_JOURNAL_DATA ptr

type USN_RECORD
	RecordLength as DWORD
	MajorVersion as WORD
	MinorVersion as WORD
	FileReferenceNumber as DWORDLONG
	ParentFileReferenceNumber as DWORDLONG
	Usn as USN
	TimeStamp as LARGE_INTEGER
	Reason as DWORD
	SourceInfo as DWORD
	SecurityId as DWORD
	FileAttributes as DWORD
	FileNameLength as WORD
	FileNameOffset as WORD
	FileName as wstring * 1
end type

type PUSN_RECORD as USN_RECORD ptr
const USN_PAGE_SIZE = &h1000
const USN_REASON_DATA_OVERWRITE = &h00000001
const USN_REASON_DATA_EXTEND = &h00000002
const USN_REASON_DATA_TRUNCATION = &h00000004
const USN_REASON_NAMED_DATA_OVERWRITE = &h00000010
const USN_REASON_NAMED_DATA_EXTEND = &h00000020
const USN_REASON_NAMED_DATA_TRUNCATION = &h00000040
const USN_REASON_FILE_CREATE = &h00000100
const USN_REASON_FILE_DELETE = &h00000200
const USN_REASON_EA_CHANGE = &h00000400
const USN_REASON_SECURITY_CHANGE = &h00000800
const USN_REASON_RENAME_OLD_NAME = &h00001000
const USN_REASON_RENAME_NEW_NAME = &h00002000
const USN_REASON_INDEXABLE_CHANGE = &h00004000
const USN_REASON_BASIC_INFO_CHANGE = &h00008000
const USN_REASON_HARD_LINK_CHANGE = &h00010000
const USN_REASON_COMPRESSION_CHANGE = &h00020000
const USN_REASON_ENCRYPTION_CHANGE = &h00040000
const USN_REASON_OBJECT_ID_CHANGE = &h00080000
const USN_REASON_REPARSE_POINT_CHANGE = &h00100000
const USN_REASON_STREAM_CHANGE = &h00200000
const USN_REASON_CLOSE = &h80000000

type USN_JOURNAL_DATA
	UsnJournalID as DWORDLONG
	FirstUsn as USN
	NextUsn as USN
	LowestValidUsn as USN
	MaxUsn as USN
	MaximumSize as DWORDLONG
	AllocationDelta as DWORDLONG
end type

type PUSN_JOURNAL_DATA as USN_JOURNAL_DATA ptr

type DELETE_USN_JOURNAL_DATA
	UsnJournalID as DWORDLONG
	DeleteFlags as DWORD
end type

type PDELETE_USN_JOURNAL_DATA as DELETE_USN_JOURNAL_DATA ptr
const USN_DELETE_FLAG_DELETE = &h00000001
const USN_DELETE_FLAG_NOTIFY = &h00000002
const USN_DELETE_VALID_FLAGS = &h00000003

type MARK_HANDLE_INFO
	UsnSourceInfo as DWORD
	VolumeHandle as HANDLE
	HandleInfo as DWORD
end type

type PMARK_HANDLE_INFO as MARK_HANDLE_INFO ptr

#ifdef __FB_64BIT__
	type MARK_HANDLE_INFO32
		UsnSourceInfo as DWORD
		VolumeHandle as UINT32
		HandleInfo as DWORD
	end type

	type PMARK_HANDLE_INFO32 as MARK_HANDLE_INFO32 ptr
#endif

const USN_SOURCE_DATA_MANAGEMENT = &h00000001
const USN_SOURCE_AUXILIARY_DATA = &h00000002
const USN_SOURCE_REPLICATION_MANAGEMENT = &h00000004
const MARK_HANDLE_PROTECT_CLUSTERS = &h00000001
const MARK_HANDLE_TXF_SYSTEM_LOG = &h00000004
const MARK_HANDLE_NOT_TXF_SYSTEM_LOG = &h00000008
const MARK_HANDLE_REALTIME = &h00000020
const MARK_HANDLE_NOT_REALTIME = &h00000040

type BULK_SECURITY_TEST_DATA
	DesiredAccess as ACCESS_MASK
	SecurityIds(0 to 0) as DWORD
end type

type PBULK_SECURITY_TEST_DATA as BULK_SECURITY_TEST_DATA ptr
const VOLUME_IS_DIRTY = &h00000001
const VOLUME_UPGRADE_SCHEDULED = &h00000002

type _FILE_PREFETCH
	as DWORD Type
	Count as DWORD
	Prefetch(0 to 0) as DWORDLONG
end type

type FILE_PREFETCH as _FILE_PREFETCH
type PFILE_PREFETCH as _FILE_PREFETCH ptr
const FILE_PREFETCH_TYPE_FOR_CREATE = &h1

type _FILESYSTEM_STATISTICS
	FileSystemType as WORD
	Version as WORD
	SizeOfCompleteStructure as DWORD
	UserFileReads as DWORD
	UserFileReadBytes as DWORD
	UserDiskReads as DWORD
	UserFileWrites as DWORD
	UserFileWriteBytes as DWORD
	UserDiskWrites as DWORD
	MetaDataReads as DWORD
	MetaDataReadBytes as DWORD
	MetaDataDiskReads as DWORD
	MetaDataWrites as DWORD
	MetaDataWriteBytes as DWORD
	MetaDataDiskWrites as DWORD
end type

type FILESYSTEM_STATISTICS as _FILESYSTEM_STATISTICS
type PFILESYSTEM_STATISTICS as _FILESYSTEM_STATISTICS ptr
const FILESYSTEM_STATISTICS_TYPE_NTFS = 1
const FILESYSTEM_STATISTICS_TYPE_FAT = 2

type _FAT_STATISTICS
	CreateHits as DWORD
	SuccessfulCreates as DWORD
	FailedCreates as DWORD
	NonCachedReads as DWORD
	NonCachedReadBytes as DWORD
	NonCachedWrites as DWORD
	NonCachedWriteBytes as DWORD
	NonCachedDiskReads as DWORD
	NonCachedDiskWrites as DWORD
end type

type FAT_STATISTICS as _FAT_STATISTICS
type PFAT_STATISTICS as _FAT_STATISTICS ptr

type _EXFAT_STATISTICS
	CreateHits as DWORD
	SuccessfulCreates as DWORD
	FailedCreates as DWORD
	NonCachedReads as DWORD
	NonCachedReadBytes as DWORD
	NonCachedWrites as DWORD
	NonCachedWriteBytes as DWORD
	NonCachedDiskReads as DWORD
	NonCachedDiskWrites as DWORD
end type

type EXFAT_STATISTICS as _EXFAT_STATISTICS
type PEXFAT_STATISTICS as _EXFAT_STATISTICS ptr

type _NTFS_STATISTICS_MftWritesUserLevel
	Write as WORD
	Create as WORD
	SetInfo as WORD
	Flush as WORD
end type

type _NTFS_STATISTICS_Mft2WritesUserLevel
	Write as WORD
	Create as WORD
	SetInfo as WORD
	Flush as WORD
end type

type _NTFS_STATISTICS_BitmapWritesUserLevel
	Write as WORD
	Create as WORD
	SetInfo as WORD
end type

type _NTFS_STATISTICS_MftBitmapWritesUserLevel
	Write as WORD
	Create as WORD
	SetInfo as WORD
	Flush as WORD
end type

type _NTFS_STATISTICS_Allocate
	Calls as DWORD
	Clusters as DWORD
	Hints as DWORD
	RunsReturned as DWORD
	HintsHonored as DWORD
	HintsClusters as DWORD
	Cache as DWORD
	CacheClusters as DWORD
	CacheMiss as DWORD
	CacheMissClusters as DWORD
end type

type _NTFS_STATISTICS
	LogFileFullExceptions as DWORD
	OtherExceptions as DWORD
	MftReads as DWORD
	MftReadBytes as DWORD
	MftWrites as DWORD
	MftWriteBytes as DWORD
	MftWritesUserLevel as _NTFS_STATISTICS_MftWritesUserLevel
	MftWritesFlushForLogFileFull as WORD
	MftWritesLazyWriter as WORD
	MftWritesUserRequest as WORD
	Mft2Writes as DWORD
	Mft2WriteBytes as DWORD
	Mft2WritesUserLevel as _NTFS_STATISTICS_Mft2WritesUserLevel
	Mft2WritesFlushForLogFileFull as WORD
	Mft2WritesLazyWriter as WORD
	Mft2WritesUserRequest as WORD
	RootIndexReads as DWORD
	RootIndexReadBytes as DWORD
	RootIndexWrites as DWORD
	RootIndexWriteBytes as DWORD
	BitmapReads as DWORD
	BitmapReadBytes as DWORD
	BitmapWrites as DWORD
	BitmapWriteBytes as DWORD
	BitmapWritesFlushForLogFileFull as WORD
	BitmapWritesLazyWriter as WORD
	BitmapWritesUserRequest as WORD
	BitmapWritesUserLevel as _NTFS_STATISTICS_BitmapWritesUserLevel
	MftBitmapReads as DWORD
	MftBitmapReadBytes as DWORD
	MftBitmapWrites as DWORD
	MftBitmapWriteBytes as DWORD
	MftBitmapWritesFlushForLogFileFull as WORD
	MftBitmapWritesLazyWriter as WORD
	MftBitmapWritesUserRequest as WORD
	MftBitmapWritesUserLevel as _NTFS_STATISTICS_MftBitmapWritesUserLevel
	UserIndexReads as DWORD
	UserIndexReadBytes as DWORD
	UserIndexWrites as DWORD
	UserIndexWriteBytes as DWORD
	LogFileReads as DWORD
	LogFileReadBytes as DWORD
	LogFileWrites as DWORD
	LogFileWriteBytes as DWORD
	Allocate as _NTFS_STATISTICS_Allocate
end type

type NTFS_STATISTICS as _NTFS_STATISTICS
type PNTFS_STATISTICS as _NTFS_STATISTICS ptr

type _FILE_OBJECTID_BUFFER
	ObjectId(0 to 15) as UBYTE

	union
		type
			BirthVolumeId(0 to 15) as UBYTE
			BirthObjectId(0 to 15) as UBYTE
			DomainId(0 to 15) as UBYTE
		end type

		ExtendedInfo(0 to 47) as UBYTE
	end union
end type

type FILE_OBJECTID_BUFFER as _FILE_OBJECTID_BUFFER
type PFILE_OBJECTID_BUFFER as _FILE_OBJECTID_BUFFER ptr

type _FILE_SET_SPARSE_BUFFER
	SetSparse as WINBOOLEAN
end type

type FILE_SET_SPARSE_BUFFER as _FILE_SET_SPARSE_BUFFER
type PFILE_SET_SPARSE_BUFFER as _FILE_SET_SPARSE_BUFFER ptr

type _FILE_ZERO_DATA_INFORMATION
	FileOffset as LARGE_INTEGER
	BeyondFinalZero as LARGE_INTEGER
end type

type FILE_ZERO_DATA_INFORMATION as _FILE_ZERO_DATA_INFORMATION
type PFILE_ZERO_DATA_INFORMATION as _FILE_ZERO_DATA_INFORMATION ptr

type _FILE_ALLOCATED_RANGE_BUFFER
	FileOffset as LARGE_INTEGER
	Length as LARGE_INTEGER
end type

type FILE_ALLOCATED_RANGE_BUFFER as _FILE_ALLOCATED_RANGE_BUFFER
type PFILE_ALLOCATED_RANGE_BUFFER as _FILE_ALLOCATED_RANGE_BUFFER ptr

type _ENCRYPTION_BUFFER
	EncryptionOperation as DWORD
	as UBYTE Private(0 to 0)
end type

type ENCRYPTION_BUFFER as _ENCRYPTION_BUFFER
type PENCRYPTION_BUFFER as _ENCRYPTION_BUFFER ptr
const FILE_SET_ENCRYPTION = &h00000001
const FILE_CLEAR_ENCRYPTION = &h00000002
const STREAM_SET_ENCRYPTION = &h00000003
const STREAM_CLEAR_ENCRYPTION = &h00000004
const MAXIMUM_ENCRYPTION_VALUE = &h00000004

type _DECRYPTION_STATUS_BUFFER
	NoEncryptedStreams as WINBOOLEAN
end type

type DECRYPTION_STATUS_BUFFER as _DECRYPTION_STATUS_BUFFER
type PDECRYPTION_STATUS_BUFFER as _DECRYPTION_STATUS_BUFFER ptr
const ENCRYPTION_FORMAT_DEFAULT = &h01
const COMPRESSION_FORMAT_SPARSE = &h4000

type _REQUEST_RAW_ENCRYPTED_DATA
	FileOffset as LONGLONG
	Length as DWORD
end type

type REQUEST_RAW_ENCRYPTED_DATA as _REQUEST_RAW_ENCRYPTED_DATA
type PREQUEST_RAW_ENCRYPTED_DATA as _REQUEST_RAW_ENCRYPTED_DATA ptr

type _ENCRYPTED_DATA_INFO
	StartingFileOffset as DWORDLONG
	OutputBufferOffset as DWORD
	BytesWithinFileSize as DWORD
	BytesWithinValidDataLength as DWORD
	CompressionFormat as WORD
	DataUnitShift as UBYTE
	ChunkShift as UBYTE
	ClusterShift as UBYTE
	EncryptionFormat as UBYTE
	NumberOfDataBlocks as WORD
	DataBlockSize(0 to 0) as DWORD
end type

type ENCRYPTED_DATA_INFO as _ENCRYPTED_DATA_INFO
type PENCRYPTED_DATA_INFO as ENCRYPTED_DATA_INFO ptr

type _PLEX_READ_DATA_REQUEST
	ByteOffset as LARGE_INTEGER
	ByteLength as DWORD
	PlexNumber as DWORD
end type

type PLEX_READ_DATA_REQUEST as _PLEX_READ_DATA_REQUEST
type PPLEX_READ_DATA_REQUEST as _PLEX_READ_DATA_REQUEST ptr

type _SI_COPYFILE
	SourceFileNameLength as DWORD
	DestinationFileNameLength as DWORD
	Flags as DWORD
	FileNameBuffer as wstring * 1
end type

type SI_COPYFILE as _SI_COPYFILE
type PSI_COPYFILE as _SI_COPYFILE ptr
const COPYFILE_SIS_LINK = &h0001
const COPYFILE_SIS_REPLACE = &h0002
const COPYFILE_SIS_FLAGS = &h0003

type _STORAGE_DESCRIPTOR_HEADER
	Version as DWORD
	Size as DWORD
end type

type STORAGE_DESCRIPTOR_HEADER as _STORAGE_DESCRIPTOR_HEADER
type PSTORAGE_DESCRIPTOR_HEADER as _STORAGE_DESCRIPTOR_HEADER ptr

type _STORAGE_PROPERTY_ID as long
enum
	StorageDeviceProperty = 0
	StorageAdapterProperty = 1
	StorageDeviceIdProperty = 2
	StorageDeviceUniqueIdProperty = 3
	StorageDeviceWriteCacheProperty = 4
	StorageMiniportProperty = 5
	StorageAccessAlignmentProperty = 6
	StorageDeviceSeekPenaltyProperty = 7
	StorageDeviceTrimProperty = 8
end enum

type STORAGE_PROPERTY_ID as _STORAGE_PROPERTY_ID
type PSTORAGE_PROPERTY_ID as _STORAGE_PROPERTY_ID ptr

type _STORAGE_QUERY_TYPE as long
enum
	PropertyStandardQuery = 0
	PropertyExistsQuery = 1
	PropertyMaskQuery = 2
	PropertyQueryMaxDefined = 3
end enum

type STORAGE_QUERY_TYPE as _STORAGE_QUERY_TYPE
type PSTORAGE_QUERY_TYPE as _STORAGE_QUERY_TYPE ptr

type _STORAGE_PROPERTY_QUERY
	PropertyId as STORAGE_PROPERTY_ID
	QueryType as STORAGE_QUERY_TYPE
	AdditionalParameters(0 to 0) as UBYTE
end type

type STORAGE_PROPERTY_QUERY as _STORAGE_PROPERTY_QUERY
type PSTORAGE_PROPERTY_QUERY as _STORAGE_PROPERTY_QUERY ptr

type _STORAGE_DEVICE_DESCRIPTOR
	Version as DWORD
	Size as DWORD
	DeviceType as UBYTE
	DeviceTypeModifier as UBYTE
	RemovableMedia as WINBOOLEAN
	CommandQueueing as WINBOOLEAN
	VendorIdOffset as DWORD
	ProductIdOffset as DWORD
	ProductRevisionOffset as DWORD
	SerialNumberOffset as DWORD
	BusType as STORAGE_BUS_TYPE
	RawPropertiesLength as DWORD
	RawDeviceProperties(0 to 0) as UBYTE
end type

type STORAGE_DEVICE_DESCRIPTOR as _STORAGE_DEVICE_DESCRIPTOR
type PSTORAGE_DEVICE_DESCRIPTOR as _STORAGE_DEVICE_DESCRIPTOR ptr

type _STORAGE_ADAPTER_DESCRIPTOR
	Version as DWORD
	Size as DWORD
	MaximumTransferLength as DWORD
	MaximumPhysicalPages as DWORD
	AlignmentMask as DWORD
	AdapterUsesPio as WINBOOLEAN
	AdapterScansDown as WINBOOLEAN
	CommandQueueing as WINBOOLEAN
	AcceleratedTransfer as WINBOOLEAN
	BusType as UBYTE
	BusMajorVersion as WORD
	BusMinorVersion as WORD
end type

type STORAGE_ADAPTER_DESCRIPTOR as _STORAGE_ADAPTER_DESCRIPTOR
type PSTORAGE_ADAPTER_DESCRIPTOR as _STORAGE_ADAPTER_DESCRIPTOR ptr

type _STORAGE_DEVICE_ID_DESCRIPTOR
	Version as DWORD
	Size as DWORD
	NumberOfIdentifiers as DWORD
	Identifiers(0 to 0) as UBYTE
end type

type STORAGE_DEVICE_ID_DESCRIPTOR as _STORAGE_DEVICE_ID_DESCRIPTOR
type PSTORAGE_DEVICE_ID_DESCRIPTOR as _STORAGE_DEVICE_ID_DESCRIPTOR ptr

type _VOLUME_GET_GPT_ATTRIBUTES_INFORMATION
	GptAttributes as ULONGLONG
end type

type VOLUME_GET_GPT_ATTRIBUTES_INFORMATION as _VOLUME_GET_GPT_ATTRIBUTES_INFORMATION
type PVOLUME_GET_GPT_ATTRIBUTES_INFORMATION as _VOLUME_GET_GPT_ATTRIBUTES_INFORMATION ptr

#if _WIN32_WINNT = &h0602
	#define FSCTL_MAKE_MEDIA_COMPATIBLE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 76, METHOD_BUFFERED, FILE_WRITE_DATA)
	#define FSCTL_SET_DEFECT_MANAGEMENT CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 77, METHOD_BUFFERED, FILE_WRITE_DATA)
	#define FSCTL_QUERY_SPARING_INFO CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 78, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_QUERY_ON_DISK_VOLUME_INFO CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 79, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_SET_VOLUME_COMPRESSION_STATE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 80, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
	#define FSCTL_TXFS_MODIFY_RM CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 81, METHOD_BUFFERED, FILE_WRITE_DATA)
	#define FSCTL_TXFS_QUERY_RM_INFORMATION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 82, METHOD_BUFFERED, FILE_READ_DATA)
	#define FSCTL_TXFS_ROLLFORWARD_REDO CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 84, METHOD_BUFFERED, FILE_WRITE_DATA)
	#define FSCTL_TXFS_ROLLFORWARD_UNDO CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 85, METHOD_BUFFERED, FILE_WRITE_DATA)
	#define FSCTL_TXFS_START_RM CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 86, METHOD_BUFFERED, FILE_WRITE_DATA)
	#define FSCTL_TXFS_SHUTDOWN_RM CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 87, METHOD_BUFFERED, FILE_WRITE_DATA)
	#define FSCTL_TXFS_READ_BACKUP_INFORMATION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 88, METHOD_BUFFERED, FILE_READ_DATA)
	#define FSCTL_TXFS_WRITE_BACKUP_INFORMATION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 89, METHOD_BUFFERED, FILE_WRITE_DATA)
	#define FSCTL_TXFS_CREATE_SECONDARY_RM CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 90, METHOD_BUFFERED, FILE_WRITE_DATA)
	#define FSCTL_TXFS_GET_METADATA_INFO CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 91, METHOD_BUFFERED, FILE_READ_DATA)
	#define FSCTL_TXFS_GET_TRANSACTED_VERSION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 92, METHOD_BUFFERED, FILE_READ_DATA)
	#define FSCTL_TXFS_SAVEPOINT_INFORMATION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 94, METHOD_BUFFERED, FILE_WRITE_DATA)
	#define FSCTL_TXFS_CREATE_MINIVERSION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 95, METHOD_BUFFERED, FILE_WRITE_DATA)
	#define FSCTL_TXFS_TRANSACTION_ACTIVE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 99, METHOD_BUFFERED, FILE_READ_DATA)
	#define FSCTL_SET_ZERO_ON_DEALLOCATION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 101, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
	#define FSCTL_SET_REPAIR CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 102, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_GET_REPAIR CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 103, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_WAIT_FOR_REPAIR CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 104, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_INITIATE_REPAIR CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 106, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_CSC_INTERNAL CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 107, METHOD_NEITHER, FILE_ANY_ACCESS)
	#define FSCTL_SHRINK_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 108, METHOD_BUFFERED, FILE_SPECIAL_ACCESS)
	#define FSCTL_SET_SHORT_NAME_BEHAVIOR CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 109, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_DFSR_SET_GHOST_HANDLE_STATE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 110, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_TXFS_LIST_TRANSACTION_LOCKED_FILES CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 120, METHOD_BUFFERED, FILE_READ_DATA)
	#define FSCTL_TXFS_LIST_TRANSACTIONS CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 121, METHOD_BUFFERED, FILE_READ_DATA)
	#define FSCTL_QUERY_PAGEFILE_ENCRYPTION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 122, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_RESET_VOLUME_ALLOCATION_HINTS CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 123, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_TXFS_READ_BACKUP_INFORMATION2 CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 126, METHOD_BUFFERED, FILE_ANY_ACCESS)
	const SET_REPAIR_ENABLED = &h00000001
	const SET_REPAIR_VOLUME_BITMAP_SCAN = &h00000002
	const SET_REPAIR_DELETE_CROSSLINK = &h00000004
	const SET_REPAIR_WARN_ABOUT_DATA_LOSS = &h00000008
	const SET_REPAIR_DISABLED_AND_BUGCHECK_ON_CORRUPT = &h00000010

	type _FILE_MAKE_COMPATIBLE_BUFFER
		CloseDisc as WINBOOLEAN
	end type

	type FILE_MAKE_COMPATIBLE_BUFFER as _FILE_MAKE_COMPATIBLE_BUFFER
	type PFILE_MAKE_COMPATIBLE_BUFFER as _FILE_MAKE_COMPATIBLE_BUFFER ptr

	type _FILE_SET_DEFECT_MGMT_BUFFER
		Disable as WINBOOLEAN
	end type

	type FILE_SET_DEFECT_MGMT_BUFFER as _FILE_SET_DEFECT_MGMT_BUFFER
	type PFILE_SET_DEFECT_MGMT_BUFFER as _FILE_SET_DEFECT_MGMT_BUFFER ptr

	type _FILE_QUERY_SPARING_BUFFER
		SparingUnitBytes as ULONG
		SoftwareSparing as WINBOOLEAN
		TotalSpareBlocks as ULONG
		FreeSpareBlocks as ULONG
	end type

	type FILE_QUERY_SPARING_BUFFER as _FILE_QUERY_SPARING_BUFFER
	type PFILE_QUERY_SPARING_BUFFER as _FILE_QUERY_SPARING_BUFFER ptr

	type _FILE_QUERY_ON_DISK_VOL_INFO_BUFFER
		DirectoryCount as LARGE_INTEGER
		FileCount as LARGE_INTEGER
		FsFormatMajVersion as WORD
		FsFormatMinVersion as WORD
		FsFormatName as wstring * 12
		FormatTime as LARGE_INTEGER
		LastUpdateTime as LARGE_INTEGER
		CopyrightInfo as wstring * 34
		AbstractInfo as wstring * 34
		FormattingImplementationInfo as wstring * 34
		LastModifyingImplementationInfo as wstring * 34
	end type

	type FILE_QUERY_ON_DISK_VOL_INFO_BUFFER as _FILE_QUERY_ON_DISK_VOL_INFO_BUFFER
	type PFILE_QUERY_ON_DISK_VOL_INFO_BUFFER as _FILE_QUERY_ON_DISK_VOL_INFO_BUFFER ptr
	const SET_REPAIR_ENABLED = &h00000001
	const SET_REPAIR_VOLUME_BITMAP_SCAN = &h00000002
	const SET_REPAIR_DELETE_CROSSLINK = &h00000004
	const SET_REPAIR_WARN_ABOUT_DATA_LOSS = &h00000008
	const SET_REPAIR_DISABLED_AND_BUGCHECK_ON_CORRUPT = &h00000010
	const SET_REPAIR_VALID_MASK = &h0000001F

	type _SHRINK_VOLUME_REQUEST_TYPES as long
	enum
		ShrinkPrepare
		ShrinkCommit
		ShrinkAbort
	end enum

	type SHRINK_VOLUME_REQUEST_TYPES as _SHRINK_VOLUME_REQUEST_TYPES

	type _SHRINK_VOLUME_INFORMATION
		ShrinkRequestType as SHRINK_VOLUME_REQUEST_TYPES
		Flags as DWORDLONG
		NewNumberOfSectors as LONGLONG
	end type

	type SHRINK_VOLUME_INFORMATION as _SHRINK_VOLUME_INFORMATION
	type PSHRINK_VOLUME_INFORMATION as _SHRINK_VOLUME_INFORMATION ptr
	const TXFS_RM_FLAG_LOGGING_MODE = &h00000001
	const TXFS_RM_FLAG_RENAME_RM = &h00000002
	const TXFS_RM_FLAG_LOG_CONTAINER_COUNT_MAX = &h00000004
	const TXFS_RM_FLAG_LOG_CONTAINER_COUNT_MIN = &h00000008
	const TXFS_RM_FLAG_LOG_GROWTH_INCREMENT_NUM_CONTAINERS = &h00000010
	const TXFS_RM_FLAG_LOG_GROWTH_INCREMENT_PERCENT = &h00000020
	const TXFS_RM_FLAG_LOG_AUTO_SHRINK_PERCENTAGE = &h00000040
	const TXFS_RM_FLAG_LOG_NO_CONTAINER_COUNT_MAX = &h00000080
	const TXFS_RM_FLAG_LOG_NO_CONTAINER_COUNT_MIN = &h00000100
	const TXFS_RM_FLAG_GROW_LOG = &h00000400
	const TXFS_RM_FLAG_SHRINK_LOG = &h00000800
	const TXFS_RM_FLAG_ENFORCE_MINIMUM_SIZE = &h00001000
	const TXFS_RM_FLAG_PRESERVE_CHANGES = &h00002000
	const TXFS_RM_FLAG_RESET_RM_AT_NEXT_START = &h00004000
	const TXFS_RM_FLAG_DO_NOT_RESET_RM_AT_NEXT_START = &h00008000
	const TXFS_RM_FLAG_PREFER_CONSISTENCY = &h00010000
	const TXFS_RM_FLAG_PREFER_AVAILABILITY = &h00020000
	const TXFS_LOGGING_MODE_SIMPLE = 1
	const TXFS_LOGGING_MODE_FULL = 2
	const TXFS_TRANSACTION_STATE_NONE = 0
	const TXFS_TRANSACTION_STATE_ACTIVE = 1
	const TXFS_TRANSACTION_STATE_PREPARED = 2
	const TXFS_TRANSACTION_STATE_NOTACTIVE = 3
	const TXFS_MODIFY_RM_VALID_FLAGS = (((((((((((((((TXFS_RM_FLAG_LOGGING_MODE or TXFS_RM_FLAG_RENAME_RM) or TXFS_RM_FLAG_LOG_CONTAINER_COUNT_MAX) or TXFS_RM_FLAG_LOG_CONTAINER_COUNT_MIN) or TXFS_RM_FLAG_LOG_GROWTH_INCREMENT_NUM_CONTAINERS) or TXFS_RM_FLAG_LOG_GROWTH_INCREMENT_PERCENT) or TXFS_RM_FLAG_LOG_AUTO_SHRINK_PERCENTAGE) or TXFS_RM_FLAG_LOG_NO_CONTAINER_COUNT_MAX) or TXFS_RM_FLAG_LOG_NO_CONTAINER_COUNT_MIN) or TXFS_RM_FLAG_SHRINK_LOG) or TXFS_RM_FLAG_GROW_LOG) or TXFS_RM_FLAG_ENFORCE_MINIMUM_SIZE) or TXFS_RM_FLAG_PRESERVE_CHANGES) or TXFS_RM_FLAG_RESET_RM_AT_NEXT_START) or TXFS_RM_FLAG_DO_NOT_RESET_RM_AT_NEXT_START) or TXFS_RM_FLAG_PREFER_CONSISTENCY) or TXFS_RM_FLAG_PREFER_AVAILABILITY

	type _TXFS_MODIFY_RM
		Flags as ULONG
		LogContainerCountMax as ULONG
		LogContainerCountMin as ULONG
		LogContainerCount as ULONG
		LogGrowthIncrement as ULONG
		LogAutoShrinkPercentage as ULONG
		Reserved as ULONGLONG
		LoggingMode as USHORT
	end type

	type TXFS_MODIFY_RM as _TXFS_MODIFY_RM
	type PTXFS_MODIFY_RM as _TXFS_MODIFY_RM ptr
	const TXFS_RM_STATE_NOT_STARTED = 0
	const TXFS_RM_STATE_STARTING = 1
	const TXFS_RM_STATE_ACTIVE = 3
	const TXFS_RM_STATE_SHUTTING_DOWN = 4
	const TXFS_QUERY_RM_INFORMATION_VALID_FLAGS = ((((((TXFS_RM_FLAG_LOG_GROWTH_INCREMENT_NUM_CONTAINERS or TXFS_RM_FLAG_LOG_GROWTH_INCREMENT_PERCENT) or TXFS_RM_FLAG_LOG_NO_CONTAINER_COUNT_MAX) or TXFS_RM_FLAG_LOG_NO_CONTAINER_COUNT_MIN) or TXFS_RM_FLAG_RESET_RM_AT_NEXT_START) or TXFS_RM_FLAG_DO_NOT_RESET_RM_AT_NEXT_START) or TXFS_RM_FLAG_PREFER_CONSISTENCY) or TXFS_RM_FLAG_PREFER_AVAILABILITY

	type _TXFS_QUERY_RM_INFORMATION
		BytesRequired as ULONG
		TailLsn as ULONGLONG
		CurrentLsn as ULONGLONG
		ArchiveTailLsn as ULONGLONG
		LogContainerSize as ULONGLONG
		HighestVirtualClock as LARGE_INTEGER
		LogContainerCount as ULONG
		LogContainerCountMax as ULONG
		LogContainerCountMin as ULONG
		LogGrowthIncrement as ULONG
		LogAutoShrinkPercentage as ULONG
		Flags as ULONG
		LoggingMode as USHORT
		Reserved as USHORT
		RmState as ULONG
		LogCapacity as ULONGLONG
		LogFree as ULONGLONG
		TopsSize as ULONGLONG
		TopsUsed as ULONGLONG
		TransactionCount as ULONGLONG
		OnePCCount as ULONGLONG
		TwoPCCount as ULONGLONG
		NumberLogFileFull as ULONGLONG
		OldestTransactionAge as ULONGLONG
		RMName as GUID
		TmLogPathOffset as ULONG
	end type

	type TXFS_QUERY_RM_INFORMATION as _TXFS_QUERY_RM_INFORMATION
	type PTXFS_QUERY_RM_INFORMATION as _TXFS_QUERY_RM_INFORMATION ptr
	const TXFS_ROLLFORWARD_REDO_FLAG_USE_LAST_REDO_LSN = &h01
	const TXFS_ROLLFORWARD_REDO_FLAG_USE_LAST_VIRTUAL_CLOCK = &h02
	const TXFS_ROLLFORWARD_REDO_VALID_FLAGS = TXFS_ROLLFORWARD_REDO_FLAG_USE_LAST_REDO_LSN or TXFS_ROLLFORWARD_REDO_FLAG_USE_LAST_VIRTUAL_CLOCK

	type _TXFS_ROLLFORWARD_REDO_INFORMATION
		LastVirtualClock as LARGE_INTEGER
		LastRedoLsn as ULONGLONG
		HighestRecoveryLsn as ULONGLONG
		Flags as ULONG
	end type

	type TXFS_ROLLFORWARD_REDO_INFORMATION as _TXFS_ROLLFORWARD_REDO_INFORMATION
	type PTXFS_ROLLFORWARD_REDO_INFORMATION as _TXFS_ROLLFORWARD_REDO_INFORMATION ptr
	const TXFS_START_RM_FLAG_LOG_CONTAINER_COUNT_MAX = &h00000001
	const TXFS_START_RM_FLAG_LOG_CONTAINER_COUNT_MIN = &h00000002
	const TXFS_START_RM_FLAG_LOG_CONTAINER_SIZE = &h00000004
	const TXFS_START_RM_FLAG_LOG_GROWTH_INCREMENT_NUM_CONTAINERS = &h00000008
	const TXFS_START_RM_FLAG_LOG_GROWTH_INCREMENT_PERCENT = &h00000010
	const TXFS_START_RM_FLAG_LOG_AUTO_SHRINK_PERCENTAGE = &h00000020
	const TXFS_START_RM_FLAG_LOG_NO_CONTAINER_COUNT_MAX = &h00000040
	const TXFS_START_RM_FLAG_LOG_NO_CONTAINER_COUNT_MIN = &h00000080
	const TXFS_START_RM_FLAG_RECOVER_BEST_EFFORT = &h00000200
	const TXFS_START_RM_FLAG_LOGGING_MODE = &h00000400
	const TXFS_START_RM_FLAG_PRESERVE_CHANGES = &h00000800
	const TXFS_START_RM_FLAG_PREFER_CONSISTENCY = &h00001000
	const TXFS_START_RM_FLAG_PREFER_AVAILABILITY = &h00002000
	const TXFS_START_RM_VALID_FLAGS = ((((((((((TXFS_START_RM_FLAG_LOG_CONTAINER_COUNT_MAX or TXFS_START_RM_FLAG_LOG_CONTAINER_COUNT_MIN) or TXFS_START_RM_FLAG_LOG_CONTAINER_SIZE) or TXFS_START_RM_FLAG_LOG_GROWTH_INCREMENT_NUM_CONTAINERS) or TXFS_START_RM_FLAG_LOG_GROWTH_INCREMENT_PERCENT) or TXFS_START_RM_FLAG_LOG_AUTO_SHRINK_PERCENTAGE) or TXFS_START_RM_FLAG_RECOVER_BEST_EFFORT) or TXFS_START_RM_FLAG_LOG_NO_CONTAINER_COUNT_MAX) or TXFS_START_RM_FLAG_LOGGING_MODE) or TXFS_START_RM_FLAG_PRESERVE_CHANGES) or TXFS_START_RM_FLAG_PREFER_CONSISTENCY) or TXFS_START_RM_FLAG_PREFER_AVAILABILITY

	type _TXFS_START_RM_INFORMATION
		Flags as ULONG
		LogContainerSize as ULONGLONG
		LogContainerCountMin as ULONG
		LogContainerCountMax as ULONG
		LogGrowthIncrement as ULONG
		LogAutoShrinkPercentage as ULONG
		TmLogPathOffset as ULONG
		TmLogPathLength as USHORT
		LoggingMode as USHORT
		LogPathLength as USHORT
		Reserved as USHORT
		LogPath as wstring * 1
	end type

	type TXFS_START_RM_INFORMATION as _TXFS_START_RM_INFORMATION
	type PTXFS_START_RM_INFORMATION as _TXFS_START_RM_INFORMATION ptr

	type _TXFS_GET_METADATA_INFO_OUT_TxfFileId
		LowPart as LONGLONG
		HighPart as LONGLONG
	end type

	type _TXFS_GET_METADATA_INFO_OUT
		TxfFileId as _TXFS_GET_METADATA_INFO_OUT_TxfFileId
		LockingTransaction as GUID
		LastLsn as ULONGLONG
		TransactionState as ULONG
	end type

	type TXFS_GET_METADATA_INFO_OUT as _TXFS_GET_METADATA_INFO_OUT
	type PTXFS_GET_METADATA_INFO_OUT as _TXFS_GET_METADATA_INFO_OUT ptr
	const TXFS_LIST_TRANSACTION_LOCKED_FILES_ENTRY_FLAG_CREATED = &h00000001
	const TXFS_LIST_TRANSACTION_LOCKED_FILES_ENTRY_FLAG_DELETED = &h000000012

	type _TXFS_LIST_TRANSACTION_LOCKED_FILES_ENTRY
		Offset as ULONGLONG
		NameFlags as ULONG
		FileId as LONGLONG
		Reserved1 as ULONG
		Reserved2 as ULONG
		Reserved3 as LONGLONG
		FileName as wstring * 1
	end type

	type TXFS_LIST_TRANSACTION_LOCKED_FILES_ENTRY as _TXFS_LIST_TRANSACTION_LOCKED_FILES_ENTRY
	type PTXFS_LIST_TRANSACTION_LOCKED_FILES_ENTRY as _TXFS_LIST_TRANSACTION_LOCKED_FILES_ENTRY ptr

	type _TXFS_LIST_TRANSACTION_LOCKED_FILES
		KtmTransaction as GUID
		NumberOfFiles as ULONGLONG
		BufferSizeRequired as ULONGLONG
		Offset as ULONGLONG
	end type

	type TXFS_LIST_TRANSACTION_LOCKED_FILES as _TXFS_LIST_TRANSACTION_LOCKED_FILES
	type PTXFS_LIST_TRANSACTION_LOCKED_FILES as _TXFS_LIST_TRANSACTION_LOCKED_FILES ptr

	type _TXFS_LIST_TRANSACTIONS_ENTRY
		TransactionId as GUID
		TransactionState as ULONG
		Reserved1 as ULONG
		Reserved2 as ULONG
		Reserved3 as LONGLONG
	end type

	type TXFS_LIST_TRANSACTIONS_ENTRY as _TXFS_LIST_TRANSACTIONS_ENTRY
	type PTXFS_LIST_TRANSACTIONS_ENTRY as _TXFS_LIST_TRANSACTIONS_ENTRY ptr

	type _TXFS_LIST_TRANSACTIONS
		NumberOfTransactions as ULONGLONG
		BufferSizeRequired as ULONGLONG
	end type

	type TXFS_LIST_TRANSACTIONS as _TXFS_LIST_TRANSACTIONS
	type PTXFS_LIST_TRANSACTIONS as _TXFS_LIST_TRANSACTIONS ptr

	type _TXFS_READ_BACKUP_INFORMATION_OUT
		union
			BufferLength as ULONG
			Buffer as UCHAR
		end union
	end type

	type TXFS_READ_BACKUP_INFORMATION_OUT as _TXFS_READ_BACKUP_INFORMATION_OUT
	type PTXFS_READ_BACKUP_INFORMATION_OUT as _TXFS_READ_BACKUP_INFORMATION_OUT ptr

	type _TXFS_WRITE_BACKUP_INFORMATION
		Buffer as UCHAR
	end type

	type TXFS_WRITE_BACKUP_INFORMATION as _TXFS_WRITE_BACKUP_INFORMATION
	type PTXFS_WRITE_BACKUP_INFORMATION as _TXFS_WRITE_BACKUP_INFORMATION ptr
	const TXFS_TRANSACTED_VERSION_NONTRANSACTED = &hFFFFFFFE
	const TXFS_TRANSACTED_VERSION_UNCOMMITTED = &hFFFFFFFF

	type _TXFS_GET_TRANSACTED_VERSION
		ThisBaseVersion as ULONG
		LatestVersion as ULONG
		ThisMiniVersion as USHORT
		FirstMiniVersion as USHORT
		LatestMiniVersion as USHORT
	end type

	type TXFS_GET_TRANSACTED_VERSION as _TXFS_GET_TRANSACTED_VERSION
	type PTXFS_GET_TRANSACTED_VERSION as _TXFS_GET_TRANSACTED_VERSION ptr
	const TXFS_SAVEPOINT_SET = 1
	const TXFS_SAVEPOINT_ROLLBACK = 2
	const TXFS_SAVEPOINT_CLEAR = 4
	const TXFS_SAVEPOINT_CLEAR_ALL = 16

	type _TXFS_SAVEPOINT_INFORMATION
		KtmTransaction as HANDLE
		ActionCode as ULONG
		SavepointId as ULONG
	end type

	type TXFS_SAVEPOINT_INFORMATION as _TXFS_SAVEPOINT_INFORMATION
	type PTXFS_SAVEPOINT_INFORMATION as _TXFS_SAVEPOINT_INFORMATION ptr

	type _TXFS_CREATE_MINIVERSION_INFO
		StructureVersion as USHORT
		StructureLength as USHORT
		BaseVersion as ULONG
		MiniVersion as USHORT
	end type

	type TXFS_CREATE_MINIVERSION_INFO as _TXFS_CREATE_MINIVERSION_INFO
	type PTXFS_CREATE_MINIVERSION_INFO as _TXFS_CREATE_MINIVERSION_INFO ptr

	type _TXFS_TRANSACTION_ACTIVE_INFO
		TransactionsActiveAtSnapshot as WINBOOL
	end type

	type TXFS_TRANSACTION_ACTIVE_INFO as _TXFS_TRANSACTION_ACTIVE_INFO
	type PTXFS_TRANSACTION_ACTIVE_INFO as _TXFS_TRANSACTION_ACTIVE_INFO ptr

	type _WRITE_CACHE_TYPE as long
	enum
		WriteCacheTypeUnknown = 0
		WriteCacheTypeNone = 1
		WriteCacheTypeWriteBack = 2
		WriteCacheTypeWriteThrough = 3
	end enum

	type WRITE_CACHE_TYPE as _WRITE_CACHE_TYPE

	type _WRITE_CACHE_ENABLE as long
	enum
		WriteCacheEnableUnknown = 0
		WriteCacheDisabled = 1
		WriteCacheEnabled = 2
	end enum

	type WRITE_CACHE_ENABLE as _WRITE_CACHE_ENABLE

	type _WRITE_CACHE_CHANGE as long
	enum
		WriteCacheChangeUnknown = 0
		WriteCacheNotChangeable = 1
		WriteCacheChangeable = 2
	end enum

	type WRITE_CACHE_CHANGE as _WRITE_CACHE_CHANGE

	type _WRITE_THROUGH as long
	enum
		WriteThroughUnknown = 0
		WriteThroughNotSupported = 1
		WriteThroughSupported = 2
	end enum

	type WRITE_THROUGH as _WRITE_THROUGH

	type _STORAGE_WRITE_CACHE_PROPERTY
		Version as DWORD
		Size as DWORD
		WriteCacheType as WRITE_CACHE_TYPE
		WriteCacheEnabled as WRITE_CACHE_ENABLE
		WriteCacheChangeable as WRITE_CACHE_CHANGE
		WriteThroughSupported as WRITE_THROUGH
		FlushCacheSupported as WINBOOLEAN
		UserDefinedPowerProtection as WINBOOLEAN
		NVCacheEnabled as WINBOOLEAN
	end type

	type STORAGE_WRITE_CACHE_PROPERTY as _STORAGE_WRITE_CACHE_PROPERTY
	type PSTORAGE_WRITE_CACHE_PROPERTY as _STORAGE_WRITE_CACHE_PROPERTY ptr

	type _STORAGE_PORT_CODE_SET as long
	enum
		StoragePortCodeSetReserved = 0
		StoragePortCodeSetStorport = 1
		StoragePortCodeSetSCSIport = 2
	end enum

	type STORAGE_PORT_CODE_SET as _STORAGE_PORT_CODE_SET
	type PSTORAGE_PORT_CODE_SET as _STORAGE_PORT_CODE_SET ptr

	type _STORAGE_MINIPORT_DESCRIPTOR
		Version as DWORD
		Size as DWORD
		Portdriver as STORAGE_PORT_CODE_SET
		LUNResetSupported as WINBOOLEAN
		TargetResetSupported as WINBOOLEAN
	end type

	type STORAGE_MINIPORT_DESCRIPTOR as _STORAGE_MINIPORT_DESCRIPTOR
	type PSTORAGE_MINIPORT_DESCRIPTOR as _STORAGE_MINIPORT_DESCRIPTOR ptr

	type _STORAGE_ACCESS_ALIGNMENT_DESCRIPTOR
		Version as DWORD
		Size as DWORD
		BytesPerCacheLine as DWORD
		BytesOffsetForCacheAlignment as DWORD
		BytesPerLogicalSector as DWORD
		BytesPerPhysicalSector as DWORD
		BytesOffsetForSectorAlignment as DWORD
	end type

	type STORAGE_ACCESS_ALIGNMENT_DESCRIPTOR as _STORAGE_ACCESS_ALIGNMENT_DESCRIPTOR
	type PSTORAGE_ACCESS_ALIGNMENT_DESCRIPTOR as _STORAGE_ACCESS_ALIGNMENT_DESCRIPTOR ptr

	type _DEVICE_SEEK_PENALTY_DESCRIPTOR
		Version as DWORD
		Size as DWORD
		IncursSeekPenalty as WINBOOLEAN
	end type

	type DEVICE_SEEK_PENALTY_DESCRIPTOR as _DEVICE_SEEK_PENALTY_DESCRIPTOR
	type PDEVICE_SEEK_PENALTY_DESCRIPTOR as _DEVICE_SEEK_PENALTY_DESCRIPTOR ptr

	type _DEVICE_TRIM_DESCRIPTOR
		Version as DWORD
		Size as DWORD
		TrimEnabled as WINBOOLEAN
	end type

	type DEVICE_TRIM_DESCRIPTOR as _DEVICE_TRIM_DESCRIPTOR
	type PDEVICE_TRIM_DESCRIPTOR as _DEVICE_TRIM_DESCRIPTOR ptr

	type _REQUEST_OPLOCK_INPUT_BUFFER
		StructureVersion as WORD
		StructureLength as WORD
		RequestedOplockLevel as DWORD
		Flags as DWORD
	end type

	type REQUEST_OPLOCK_INPUT_BUFFER as _REQUEST_OPLOCK_INPUT_BUFFER
	type PREQUEST_OPLOCK_INPUT_BUFFER as _REQUEST_OPLOCK_INPUT_BUFFER ptr

	type _REQUEST_OPLOCK_OUTPUT_BUFFER
		StructureVersion as WORD
		StructureLength as WORD
		OriginalOplockLevel as DWORD
		NewOplockLevel as DWORD
		Flags as DWORD
		AccessMode as ACCESS_MASK
		ShareMode as WORD
	end type

	type REQUEST_OPLOCK_OUTPUT_BUFFER as _REQUEST_OPLOCK_OUTPUT_BUFFER
	type PREQUEST_OPLOCK_OUTPUT_BUFFER as _REQUEST_OPLOCK_OUTPUT_BUFFER ptr

	type _BOOT_AREA_INFO_BootSectors
		Offset as LARGE_INTEGER
	end type

	type _BOOT_AREA_INFO
		BootSectorCount as ULONG
		BootSectors(0 to 1) as _BOOT_AREA_INFO_BootSectors
	end type

	type BOOT_AREA_INFO as _BOOT_AREA_INFO
	type PBOOT_AREA_INFO as _BOOT_AREA_INFO ptr

	type _RETRIEVAL_POINTER_BASE
		FileAreaOffset as LARGE_INTEGER
	end type

	type RETRIEVAL_POINTER_BASE as _RETRIEVAL_POINTER_BASE
	type PRETRIEVAL_POINTER_BASE as _RETRIEVAL_POINTER_BASE ptr

	type _FILE_SYSTEM_RECOGNITION_INFORMATION
		FileSystem as zstring * 9
	end type

	type FILE_SYSTEM_RECOGNITION_INFORMATION as _FILE_SYSTEM_RECOGNITION_INFORMATION
	type PFILE_SYSTEM_RECOGNITION_INFORMATION as _FILE_SYSTEM_RECOGNITION_INFORMATION ptr

	type _FILE_SYSTEM_RECOGNITION_STRUCTURE
		Jmp(0 to 2) as UCHAR
		FsName(0 to 7) as UCHAR
		MustBeZero(0 to 4) as UCHAR
		Identifier as ULONG
		Length as USHORT
		Checksum as USHORT
	end type

	type FILE_SYSTEM_RECOGNITION_STRUCTURE as _FILE_SYSTEM_RECOGNITION_STRUCTURE

	type _LOOKUP_STREAM_FROM_CLUSTER_INPUT
		Flags as DWORD
		NumberOfClusters as DWORD
		Cluster(0 to 0) as LARGE_INTEGER
	end type

	type LOOKUP_STREAM_FROM_CLUSTER_INPUT as _LOOKUP_STREAM_FROM_CLUSTER_INPUT
	type PLOOKUP_STREAM_FROM_CLUSTER_INPUT as _LOOKUP_STREAM_FROM_CLUSTER_INPUT ptr

	type _LOOKUP_STREAM_FROM_CLUSTER_OUTPUT
		Offset as DWORD
		NumberOfMatches as DWORD
		BufferSizeRequired as DWORD
	end type

	type LOOKUP_STREAM_FROM_CLUSTER_OUTPUT as _LOOKUP_STREAM_FROM_CLUSTER_OUTPUT
	type PLOOKUP_STREAM_FROM_CLUSTER_OUTPUT as _LOOKUP_STREAM_FROM_CLUSTER_OUTPUT ptr

	type _LOOKUP_STREAM_FROM_CLUSTER_ENTRY
		OffsetToNext as DWORD
		Flags as DWORD
		Reserved as LARGE_INTEGER
		Cluster as LARGE_INTEGER
		FileName as wstring * 1
	end type

	type LOOKUP_STREAM_FROM_CLUSTER_ENTRY as _LOOKUP_STREAM_FROM_CLUSTER_ENTRY
	type PLOOKUP_STREAM_FROM_CLUSTER_ENTRY as _LOOKUP_STREAM_FROM_CLUSTER_ENTRY ptr
	const LOOKUP_STREAM_FROM_CLUSTER_ENTRY_ATTRIBUTE_MASK = &hff000000
	const LOOKUP_STREAM_FROM_CLUSTER_ENTRY_FLAG_PAGE_FILE = &h00000001
	const LOOKUP_STREAM_FROM_CLUSTER_ENTRY_FLAG_DENY_DEFRAG_SET = &h00000002
	const LOOKUP_STREAM_FROM_CLUSTER_ENTRY_FLAG_FS_SYSTEM_FILE = &h00000004
	const LOOKUP_STREAM_FROM_CLUSTER_ENTRY_FLAG_TXF_SYSTEM_FILE = &h00000008
	const LOOKUP_STREAM_FROM_CLUSTER_ENTRY_ATTRIBUTE_DATA = &h01000000
	const LOOKUP_STREAM_FROM_CLUSTER_ENTRY_ATTRIBUTE_INDEX = &h02000000
	const LOOKUP_STREAM_FROM_CLUSTER_ENTRY_ATTRIBUTE_SYSTEM = &h03000000
	#define FSCTL_QUERY_DEPENDENT_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 124, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_SD_GLOBAL_CHANGE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 125, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_LOOKUP_STREAM_FROM_CLUSTER CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 127, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_TXFS_WRITE_BACKUP_INFORMATION2 CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 128, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_FILE_TYPE_NOTIFICATION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 129, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_GET_BOOT_AREA_INFO CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 140, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_GET_RETRIEVAL_POINTER_BASE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 141, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_SET_PERSISTENT_VOLUME_STATE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 142, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_QUERY_PERSISTENT_VOLUME_STATE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 143, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_REQUEST_OPLOCK CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 144, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_CSV_TUNNEL_REQUEST CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 145, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_IS_CSV_FILE CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 146, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_QUERY_FILE_SYSTEM_RECOGNITION CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 147, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_CSV_GET_VOLUME_PATH_NAME CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 148, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_CSV_GET_VOLUME_NAME_FOR_VOLUME_MOUNT_POINT CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 149, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_CSV_GET_VOLUME_PATH_NAMES_FOR_VOLUME_NAME CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 150, METHOD_BUFFERED, FILE_ANY_ACCESS)
	#define FSCTL_IS_FILE_ON_CSV_VOLUME CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 151, METHOD_BUFFERED, FILE_ANY_ACCESS)
#endif

#define IOCTL_VOLUME_BASE cast(DWORD, asc("V"))
#define IOCTL_VOLUME_GET_VOLUME_DISK_EXTENTS CTL_CODE(IOCTL_VOLUME_BASE, 0, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_SUPPORTS_ONLINE_OFFLINE CTL_CODE(IOCTL_VOLUME_BASE, 1, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_ONLINE CTL_CODE(IOCTL_VOLUME_BASE, 2, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_VOLUME_OFFLINE CTL_CODE(IOCTL_VOLUME_BASE, 3, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
#define IOCTL_VOLUME_IS_OFFLINE CTL_CODE(IOCTL_VOLUME_BASE, 4, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_IS_IO_CAPABLE CTL_CODE(IOCTL_VOLUME_BASE, 5, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_QUERY_FAILOVER_SET CTL_CODE(IOCTL_VOLUME_BASE, 6, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_QUERY_VOLUME_NUMBER CTL_CODE(IOCTL_VOLUME_BASE, 7, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_LOGICAL_TO_PHYSICAL CTL_CODE(IOCTL_VOLUME_BASE, 8, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_PHYSICAL_TO_LOGICAL CTL_CODE(IOCTL_VOLUME_BASE, 9, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_IS_CLUSTERED CTL_CODE(IOCTL_VOLUME_BASE, 12, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_GET_GPT_ATTRIBUTES CTL_CODE(IOCTL_VOLUME_BASE, 14, METHOD_BUFFERED, FILE_ANY_ACCESS)

type _DISK_EXTENT
	DiskNumber as DWORD
	StartingOffset as LARGE_INTEGER
	ExtentLength as LARGE_INTEGER
end type

type DISK_EXTENT as _DISK_EXTENT
type PDISK_EXTENT as _DISK_EXTENT ptr

type _VOLUME_DISK_EXTENTS
	NumberOfDiskExtents as DWORD
	Extents(0 to 0) as DISK_EXTENT
end type

type VOLUME_DISK_EXTENTS as _VOLUME_DISK_EXTENTS
type PVOLUME_DISK_EXTENTS as _VOLUME_DISK_EXTENTS ptr

end extern
