/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.wizard.PanelManager;
import docking.wizard.WizardManager;
import docking.wizard.WizardPanel;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.ProjectAccessPanel;
import ghidra.framework.main.ProjectTypePanel;
import ghidra.framework.main.RepositoryPanel;
import ghidra.framework.main.SelectProjectPanel;
import ghidra.framework.main.ServerInfoPanel;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.remote.User;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.UserAccessException;
import java.awt.Dimension;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

class NewProjectPanelManager
implements PanelManager {
    private WizardManager wizardMgr;
    private String[] knownUsers;
    private ProjectTypePanel projectTypePanel = new ProjectTypePanel(this);
    private SelectProjectPanel selectProjectPanel = new SelectProjectPanel(this);
    private ServerInfoPanel serverPanel = new ServerInfoPanel(this);
    private RepositoryPanel repositoryPanel;
    private ProjectAccessPanel projectAccessPanel;
    private WizardPanel currentWizardPanel;
    private boolean includeAnonymousAccessControl = false;
    private ProjectManager projectMgr;
    private RepositoryServerAdapter server;
    private RepositoryAdapter repository;
    private ServerInfo serverInfo;
    private ProjectLocator newProjectLocator;
    private String statusMessage;
    private PluginTool tool;
    static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(80, 120, 0, 120);

    NewProjectPanelManager(FrontEndTool tool) {
        this.projectMgr = tool.getProjectManager();
        this.tool = tool;
    }

    public boolean canFinish() {
        if (!this.projectTypePanel.isValidInformation()) {
            return false;
        }
        if (!this.projectTypePanel.isSharedProject() && this.selectProjectPanel.isValidInformation()) {
            return true;
        }
        if (this.repositoryPanel == null) {
            return false;
        }
        return this.repositoryPanel.isValidInformation() && (this.projectAccessPanel == null || this.projectAccessPanel != null && this.projectAccessPanel.isValidInformation()) && this.selectProjectPanel.isValidInformation();
    }

    public boolean hasNextPanel() {
        if (this.currentWizardPanel == this.selectProjectPanel && this.selectProjectPanel.isValidInformation() && this.projectTypePanel.isValidInformation() && !this.projectTypePanel.isSharedProject()) {
            return false;
        }
        return this.currentWizardPanel != this.selectProjectPanel;
    }

    public boolean hasPreviousPanel() {
        return this.currentWizardPanel != this.projectTypePanel;
    }

    public WizardPanel getInitialPanel() {
        this.currentWizardPanel = this.projectTypePanel;
        return this.currentWizardPanel;
    }

    public WizardPanel getNextPanel() {
        if (this.currentWizardPanel == null) {
            this.currentWizardPanel = this.projectTypePanel;
        } else if (this.currentWizardPanel == this.projectTypePanel) {
            if (this.projectTypePanel.isSharedProject()) {
                this.currentWizardPanel = this.serverPanel;
                this.serverPanel.setServerInfo(this.projectMgr.getMostRecentServerInfo());
            } else {
                this.server = null;
                this.serverInfo = null;
                this.currentWizardPanel = this.selectProjectPanel;
            }
        } else if (this.currentWizardPanel == this.serverPanel) {
            int portNumber;
            String serverName = this.serverPanel.getServerName();
            if (!this.isServerInfoValid(serverName, portNumber = this.serverPanel.getPortNumber())) {
                return this.serverPanel;
            }
            try {
                this.knownUsers = this.server.getAllUsers();
                String[] repositoryNames = this.server.getRepositoryNames();
                this.includeAnonymousAccessControl = this.server.anonymousAccessAllowed();
                if (this.repositoryPanel == null) {
                    this.repositoryPanel = new RepositoryPanel(this, serverName, repositoryNames, this.server.isReadOnly());
                }
                this.currentWizardPanel = this.repositoryPanel;
            }
            catch (RemoteException e) {
                this.statusMessage = "Error accessing remote server on " + serverName;
            }
            catch (NotConnectedException e) {
                this.statusMessage = e.getMessage();
                if (this.statusMessage == null) {
                    this.statusMessage = "Not Connected to server " + serverName;
                }
            }
            catch (IOException e) {
                this.statusMessage = "IOException: could not access remote server on " + serverName;
            }
        } else if (this.currentWizardPanel == this.repositoryPanel) {
            if (this.repository != null) {
                this.repository.disconnect();
                this.repository = null;
            }
            String repositoryName = this.repositoryPanel.getRepositoryName();
            this.selectProjectPanel.setProjectName(repositoryName);
            if (!this.repositoryPanel.createRepository()) {
                this.currentWizardPanel = this.selectProjectPanel;
                this.selectProjectPanel.setProjectName(repositoryName);
                this.repository = this.server.getRepository(repositoryName);
                this.statusMessage = this.selectProjectPanel.getStatusMessage();
                return this.currentWizardPanel;
            }
            this.checkNewRepositoryAccessPanel();
            this.currentWizardPanel = this.projectAccessPanel;
        } else if (this.currentWizardPanel == this.projectAccessPanel) {
            this.currentWizardPanel = this.selectProjectPanel;
            this.statusMessage = this.selectProjectPanel.getStatusMessage();
        } else {
            this.currentWizardPanel = null;
        }
        return this.currentWizardPanel;
    }

    private void checkNewRepositoryAccessPanel() {
        String repositoryName = this.repositoryPanel.getRepositoryName();
        if (this.projectAccessPanel != null && this.projectAccessPanel.getRepositoryName().equals(repositoryName)) {
            return;
        }
        ArrayList<User> userList = new ArrayList<User>();
        userList.add(new User(this.server.getUser(), 2));
        try {
            this.projectAccessPanel = new ProjectAccessPanel(this.knownUsers, this.server.getUser(), userList, repositoryName, this.server.anonymousAccessAllowed(), false, this.tool);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error creating project access panel");
        }
    }

    public WizardPanel getPreviousPanel() {
        this.currentWizardPanel = this.currentWizardPanel == this.selectProjectPanel ? (this.projectTypePanel.isSharedProject() ? (this.repositoryPanel.createRepository() ? this.projectAccessPanel : this.repositoryPanel) : this.projectTypePanel) : (this.currentWizardPanel == this.projectAccessPanel ? this.repositoryPanel : (this.currentWizardPanel == this.repositoryPanel ? this.serverPanel : (this.currentWizardPanel == this.serverPanel ? this.projectTypePanel : null)));
        return this.currentWizardPanel;
    }

    public String getStatusMessage() {
        String msg = this.statusMessage;
        this.statusMessage = null;
        return msg;
    }

    public void finish() {
        ProjectLocator projectLocator = this.selectProjectPanel.getProjectLocator();
        if (this.server != null) {
            boolean createNewRepository = this.repositoryPanel.createRepository();
            if (!createNewRepository) {
                if (this.repository == null) {
                    this.repository = this.server.getRepository(this.repositoryPanel.getRepositoryName());
                }
            } else {
                try {
                    this.repository = this.server.createRepository(this.repositoryPanel.getRepositoryName());
                    this.repository.setUserList(this.projectAccessPanel.getProjectUsers(), this.projectAccessPanel.allowAnonymousAccess());
                }
                catch (DuplicateNameException e) {
                    this.statusMessage = "Repository " + this.repositoryPanel.getRepositoryName() + " exists";
                }
                catch (UserAccessException exc) {
                    this.statusMessage = "Could not update the user list: " + exc.getMessage();
                    return;
                }
                catch (NotConnectedException e) {
                    this.statusMessage = e.getMessage();
                    if (this.statusMessage == null) {
                        this.statusMessage = "Not connected to server " + this.serverInfo.getServerName();
                    }
                    return;
                }
                catch (IOException exc) {
                    String msg = exc.getMessage();
                    if (msg == null) {
                        msg = exc.toString();
                    }
                    this.statusMessage = "Error occurred while updating the user list: " + msg;
                    return;
                }
            }
        }
        Preferences.setProperty((String)"LastNewProjectDirectory", (String)projectLocator.getLocation());
        Preferences.store();
        this.newProjectLocator = projectLocator;
        this.wizardMgr.close();
    }

    public void cancel() {
        this.currentWizardPanel = null;
        this.repositoryPanel = null;
        this.projectAccessPanel = null;
        this.server = null;
        if (this.repository != null) {
            this.repository.disconnect();
            this.repository = null;
        }
    }

    public void initialize() {
        this.currentWizardPanel = null;
        this.selectProjectPanel.initialize();
        this.serverPanel.initialize();
        if (this.repositoryPanel != null) {
            this.repositoryPanel.initialize();
        }
        if (this.projectAccessPanel != null) {
            this.projectAccessPanel.initialize();
        }
    }

    public Dimension getPanelSize() {
        return this.getMyPanelSize();
    }

    public void setWizardManager(WizardManager wm) {
        this.wizardMgr = wm;
    }

    public WizardManager getWizardManager() {
        return this.wizardMgr;
    }

    ProjectLocator getNewProjectLocation() {
        return this.newProjectLocator;
    }

    RepositoryAdapter getProjectRepository() {
        return this.repository;
    }

    String getProjectRepositoryName() {
        return this.repositoryPanel.getRepositoryName();
    }

    boolean isSharedProject() {
        return this.projectTypePanel.isSharedProject();
    }

    private boolean isServerInfoValid(String serverName, int portNumber) {
        if (this.server != null && this.serverInfo != null && this.serverInfo.getServerName().equals(serverName) && this.serverInfo.getPortNumber() == portNumber && this.server.isConnected()) {
            return true;
        }
        this.repositoryPanel = null;
        this.server = this.projectMgr.getRepositoryServerAdapter(serverName, portNumber, true);
        if (this.server.isConnected()) {
            this.serverInfo = this.projectMgr.getMostRecentServerInfo();
            return true;
        }
        this.server = null;
        this.serverInfo = null;
        this.statusMessage = "Could not connect to server " + serverName + ", port " + portNumber;
        return false;
    }

    private Dimension getMyPanelSize() {
        ProjectAccessPanel panel1 = new ProjectAccessPanel(new String[]{"nobody"}, "user", new ArrayList<User>(), "MyRepository", true, false, this.tool);
        RepositoryPanel panel2 = new RepositoryPanel(this, "ServerOne", new String[]{"MyRepository", "NewStuff", "Repository_A", "Repository_B"}, false);
        Dimension d1 = panel1.getPreferredSize();
        Dimension d2 = panel2.getPreferredSize();
        return new Dimension(Math.max(d1.width, d2.width), Math.max(d1.height, d2.height));
    }
}

