/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatable;

import ghidra.framework.main.datatable.DomainFileType;
import ghidra.framework.model.DomainFile;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class DomainFileInfo {
    private DomainFile domainFile;
    private String name;
    private String path;
    private Map<String, String> metadata;
    private Date modificationDate;
    private DomainFileType domainFileType;

    public DomainFileInfo(DomainFile domainFile) {
        this.domainFile = domainFile;
        this.path = domainFile.getParent().getPathname();
    }

    private String computeName() {
        Object displayName = this.domainFile.getName();
        if (this.domainFile.isHijacked()) {
            displayName = (String)displayName + " (hijacked)";
        } else if (this.domainFile.isVersioned()) {
            int versionNumber = this.domainFile.getVersion();
            Object versionStr = "" + versionNumber;
            if (versionNumber < 0) {
                versionStr = "?";
            }
            if (this.domainFile.isCheckedOut()) {
                int latestVersionNumber = this.domainFile.getLatestVersion();
                Object latestVersionStr = "" + latestVersionNumber;
                if (latestVersionNumber < 0) {
                    latestVersionStr = "?";
                }
                displayName = (String)displayName + " (" + (String)versionStr + " of " + (String)latestVersionStr + ")";
                if (this.domainFile.modifiedSinceCheckout()) {
                    displayName = (String)displayName + "*";
                }
            } else {
                displayName = (String)displayName + " (" + (String)versionStr + ")";
            }
        }
        return displayName;
    }

    public synchronized String getDisplayName() {
        if (this.name == null) {
            this.name = this.computeName();
        }
        return this.name;
    }

    public synchronized String getPath() {
        if (this.path == null) {
            this.path = this.domainFile.getParent().getPathname();
        }
        return this.path;
    }

    public Icon getIcon() {
        return this.domainFile.getIcon(false);
    }

    public synchronized DomainFileType getDomainFileType() {
        if (this.domainFileType == null) {
            String contentType = this.domainFile.getContentType();
            Icon icon = this.domainFile.getIcon(false);
            boolean isVersioned = this.domainFile.isVersioned();
            this.domainFileType = new DomainFileType(contentType, icon, isVersioned);
        }
        return this.domainFileType;
    }

    public synchronized Date getModificationDate() {
        if (this.modificationDate == null) {
            this.modificationDate = this.getLastModifiedTime();
        }
        return this.modificationDate;
    }

    private Date getLastModifiedTime() {
        long lastModified = this.domainFile.getLastModifiedTime();
        if (lastModified != 0L) {
            return new Date(lastModified);
        }
        return new Date();
    }

    private synchronized Map<String, String> getMetadata() {
        if (this.metadata == null) {
            this.metadata = this.domainFile.getMetadata();
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
        }
        return this.metadata;
    }

    public DomainFile getDomainFile() {
        return this.domainFile;
    }

    public synchronized void clearMetaCache() {
        this.metadata = null;
        this.modificationDate = null;
        this.domainFileType = null;
        this.refresh();
    }

    public synchronized void refresh() {
        this.name = null;
        this.path = null;
    }

    public String getMetaDataValue(String key) {
        Map<String, String> meta = this.getMetadata();
        return meta.get(key);
    }

    public String getName() {
        return this.domainFile.getName();
    }
}

