/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.datatable.ProjectDataActionContext;
import ghidra.framework.main.datatable.ProjectDataContextAction;
import ghidra.framework.model.ProjectData;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import javax.swing.Icon;
import resources.Icons;

public class ProjectDataRefreshAction
extends ProjectDataContextAction {
    private static Icon icon = Icons.REFRESH_ICON;

    public ProjectDataRefreshAction(String owner, String group) {
        super("Refresh", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Refresh"}, icon, group));
        this.setDescription("Refresh folders and files");
        this.setKeyBindingData(new KeyBindingData(116, 0));
        this.setToolBarData(new ToolBarData(icon, group));
        this.setHelpLocation(new HelpLocation(owner, "RefreshFolders"));
        this.markHelpUnnecessary();
    }

    @Override
    protected void actionPerformed(ProjectDataActionContext context) {
        this.refresh(context.getProjectData(), context.getComponent());
    }

    public void refresh(final ProjectData projectData, final Component comp) {
        TaskLauncher.launch((Task)new Task("Refresh folders and files", false, false, true){

            public void run(TaskMonitor monitor) {
                try {
                    projectData.refresh(false);
                }
                catch (IOException e) {
                    ClientUtil.handleException((RepositoryAdapter)projectData.getRepository(), (Exception)e, (String)"Refresh Project Data", (boolean)false, (Component)comp);
                }
            }
        });
    }
}

