/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import java.util.BitSet;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;

public class DomainObjectChangedEvent
extends EventObject
implements Iterable<DomainObjectChangeRecord> {
    private static final long serialVersionUID = 1L;
    private List<DomainObjectChangeRecord> subEvents;
    private BitSet eventBits = new BitSet(255);

    public DomainObjectChangedEvent(DomainObject src, List<DomainObjectChangeRecord> subEvents) {
        super(src);
        this.subEvents = subEvents;
        for (DomainObjectChangeRecord record : subEvents) {
            this.eventBits.set(record.getEventType());
        }
    }

    public int numRecords() {
        return this.subEvents.size();
    }

    public boolean containsEvent(int eventType) {
        return this.eventBits.get(eventType);
    }

    public DomainObjectChangeRecord getChangeRecord(int i) {
        return this.subEvents.get(i);
    }

    @Override
    public Iterator<DomainObjectChangeRecord> iterator() {
        return this.subEvents.iterator();
    }
}

