/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.EmptyBorderToggleButton;
import docking.widgets.HyperlinkComponent;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.label.GIconLabel;
import docking.widgets.label.GLabel;
import ghidra.framework.plugintool.PluginConfigurationModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.dialog.PluginInstallerDialog;
import ghidra.framework.plugintool.util.PluginPackage;
import ghidra.framework.plugintool.util.PluginPackageState;
import ghidra.util.HTMLUtilities;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import resources.ResourceManager;

public class PluginManagerComponent
extends JPanel
implements ChangeListener,
Scrollable {
    private final PluginTool tool;
    private PluginConfigurationModel model;
    private List<PluginPackageComponent> packageComponentList = new ArrayList<PluginPackageComponent>();

    PluginManagerComponent(PluginTool tool) {
        super((LayoutManager)new VerticalLayout(2));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setBackground(Color.WHITE);
        this.tool = tool;
        this.model = new PluginConfigurationModel(tool, this);
        List<PluginPackage> pluginPackages = this.model.getPluginPackages();
        for (PluginPackage pluginPackage : pluginPackages) {
            PluginPackageComponent comp = new PluginPackageComponent(pluginPackage);
            this.packageComponentList.add(comp);
            this.add(comp);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        for (PluginPackageComponent comp : this.packageComponentList) {
            comp.updateCheckBoxState();
        }
    }

    void managePlugins(PluginPackage pluginPackage) {
        PluginInstallerDialog pluginInstallerDialog = new PluginInstallerDialog("Configure " + pluginPackage.getName() + " Plugins", this.tool, this.model.getPluginDescriptions(pluginPackage));
        this.tool.showDialog(pluginInstallerDialog);
    }

    void manageAllPlugins() {
        PluginInstallerDialog pluginTableDialog = new PluginInstallerDialog("Configure All Plugins", this.tool, this.model.getAllPluginDescriptions());
        this.tool.showDialog(pluginTableDialog);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 50;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    static class MyToggleButton
    extends EmptyBorderToggleButton {
        public MyToggleButton(Icon icon) {
            super(icon);
        }

        public void setIcon(Icon newIcon) {
            ImageIcon scaledIcon = ResourceManager.getScaledIcon((Icon)newIcon, (int)32, (int)32, (int)32);
            this.doSetIcon(scaledIcon);
        }
    }

    private class PluginPackageComponent
    extends JPanel {
        private final Color BG;
        private final PluginPackage pluginPackage;
        private final GCheckBox checkBox;

        PluginPackageComponent(PluginPackage pluginPackage) {
            super(new BorderLayout());
            this.BG = Color.white;
            this.setBackground(this.BG);
            this.pluginPackage = pluginPackage;
            this.checkBox = new GCheckBox();
            this.initizalizeCheckBoxSection();
            this.initializeLabelSection();
            this.initializeDescriptionSection();
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            this.updateCheckBoxState();
        }

        private void initizalizeCheckBoxSection() {
            JPanel checkboxPanel = new JPanel((LayoutManager)new HorizontalLayout(0));
            checkboxPanel.setBackground(this.BG);
            this.checkBox.addActionListener(e -> this.checkBoxClicked());
            if (!this.pluginPackage.isfullyAddable()) {
                this.checkBox.setEnabled(false);
            }
            this.checkBox.setBackground(this.BG);
            checkboxPanel.add(Box.createHorizontalStrut(10));
            checkboxPanel.add((Component)this.checkBox);
            checkboxPanel.add(Box.createHorizontalStrut(10));
            GIconLabel iconLabel = new GIconLabel((Icon)ResourceManager.getScaledIcon((Icon)this.pluginPackage.getIcon(), (int)32, (int)32, (int)32));
            iconLabel.setBackground(this.BG);
            checkboxPanel.add((Component)iconLabel);
            checkboxPanel.add(Box.createHorizontalStrut(10));
            checkboxPanel.setPreferredSize(new Dimension(84, 70));
            this.add((Component)checkboxPanel, "West");
        }

        private void initializeLabelSection() {
            JPanel centerPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weightx = 1.0;
            centerPanel.setBackground(this.BG);
            JPanel labelPanel = new JPanel((LayoutManager)new VerticalLayout(3));
            labelPanel.setBackground(this.BG);
            GLabel nameLabel = new GLabel(this.pluginPackage.getName());
            nameLabel.setFont(nameLabel.getFont().deriveFont(18.0f));
            nameLabel.setForeground(Color.BLACK);
            labelPanel.add((Component)nameLabel);
            HyperlinkComponent configureHyperlink = this.createConfigureHyperlink();
            labelPanel.add((Component)configureHyperlink);
            labelPanel.setBorder(BorderFactory.createEmptyBorder(0, 25, 0, 40));
            centerPanel.add((Component)labelPanel, gbc);
            this.add(centerPanel);
        }

        private HyperlinkComponent createConfigureHyperlink() {
            HyperlinkComponent configureHyperlink = new HyperlinkComponent("<html> <a href=\"Configure\">Configure</a>");
            configureHyperlink.addHyperlinkListener("Configure", e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    PluginManagerComponent.this.managePlugins(this.pluginPackage);
                }
            });
            configureHyperlink.setBackground(this.BG);
            return configureHyperlink;
        }

        private String enchanceDescription(String text) {
            return String.format("<html><body style='width: 300px'>%s</body></html>", text);
        }

        private void initializeDescriptionSection() {
            String htmlDescription = this.enchanceDescription(this.pluginPackage.getDescription());
            GHtmlLabel descriptionlabel = new GHtmlLabel(htmlDescription);
            descriptionlabel.setForeground(Color.GRAY);
            descriptionlabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            descriptionlabel.setVerticalAlignment(1);
            descriptionlabel.setToolTipText(HTMLUtilities.toWrappedHTML((String)this.pluginPackage.getDescription(), (int)80));
            this.add((Component)descriptionlabel, "East");
        }

        protected void checkBoxClicked() {
            boolean isSelected = this.checkBox.isSelected();
            if (isSelected) {
                PluginManagerComponent.this.model.addAllPlugins(this.pluginPackage);
            } else {
                PluginManagerComponent.this.model.removeAllPlugins(this.pluginPackage);
            }
        }

        void updateCheckBoxState() {
            this.checkBox.setSelected(PluginManagerComponent.this.model.getPackageState(this.pluginPackage) != PluginPackageState.NO_PLUGINS_LOADED);
        }
    }
}

