/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.tool;

import ghidra.framework.model.Tool;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.framework.project.tool.GhidraTool;
import ghidra.framework.project.tool.ToolManagerImpl;
import ghidra.util.exception.DuplicateNameException;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;

class WorkspaceImpl
implements Workspace {
    private static final int TYPICAL_NUM_RUNNING_TOOLS = 5;
    private String name;
    private ToolManagerImpl toolManager;
    private Set<Tool> runningTools = new HashSet<Tool>(5);
    private boolean isActive;

    WorkspaceImpl(String name, ToolManagerImpl toolManager) {
        this.name = name;
        this.toolManager = toolManager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Tool[] getTools() {
        Tool[] tools = new Tool[this.runningTools.size()];
        this.runningTools.toArray(tools);
        return tools;
    }

    @Override
    public Tool createTool() {
        Tool emptyTool = this.toolManager.createEmptyTool();
        this.runningTools.add(emptyTool);
        emptyTool.setVisible(true);
        this.toolManager.setWorkspaceChanged(this);
        this.toolManager.fireToolAddedEvent(this, emptyTool);
        return emptyTool;
    }

    @Override
    public Tool runTool(ToolTemplate template) {
        Tool tool = this.toolManager.getTool(this, template);
        if (tool != null) {
            tool.setVisible(true);
            if (tool instanceof GhidraTool) {
                GhidraTool gTool = (GhidraTool)tool;
                gTool.checkForNewExtensions();
            }
            this.runningTools.add(tool);
            this.toolManager.setWorkspaceChanged(this);
            this.toolManager.fireToolAddedEvent(this, tool);
        }
        return tool;
    }

    @Override
    public void setName(String newName) throws DuplicateNameException {
        this.toolManager.setWorkspaceName(this, newName);
        this.toolManager.setWorkspaceChanged(this);
        this.name = newName;
    }

    @Override
    public void setActive() {
        this.toolManager.setActiveWorkspace(this);
        this.setVisible(true);
    }

    public String toString() {
        return this.name;
    }

    public Element saveToXml() {
        Element root = new Element("WORKSPACE");
        root.setAttribute("NAME", this.name);
        root.setAttribute("ACTIVE", "" + this.isActive);
        for (Tool tool : this.runningTools) {
            Element elem = new Element("RUNNING_TOOL");
            elem.setAttribute("TOOL_NAME", tool.getToolName());
            elem.addContent((Content)tool.saveWindowingDataToXml());
            elem.addContent((Content)tool.saveDataStateToXml(true));
            root.addContent((Content)elem);
        }
        return root;
    }

    public void restoreFromXml(Element root) {
        String activeStr;
        String tmp = root.getAttributeValue("NAME");
        if (tmp != null) {
            this.name = tmp;
        }
        this.isActive = (activeStr = root.getAttributeValue("ACTIVE")) != null && activeStr.equalsIgnoreCase("true");
        String defaultTool = System.getProperty("ghidra.defaulttool");
        if (defaultTool != null && !defaultTool.equals("")) {
            Tool tool = this.toolManager.getTool(defaultTool);
            this.runningTools.add(tool);
            this.toolManager.fireToolAddedEvent(this, tool);
            return;
        }
        for (Element elememnt : root.getChildren("RUNNING_TOOL")) {
            Tool tool;
            String toolName = elememnt.getAttributeValue("TOOL_NAME");
            if (toolName == null || (tool = this.toolManager.getTool(toolName)) == null) continue;
            tool.setVisible(this.isActive);
            if (tool instanceof GhidraTool) {
                GhidraTool gTool = (GhidraTool)tool;
                gTool.checkForNewExtensions();
            }
            boolean hadChanges = tool.hasConfigChanged();
            Element windowData = elememnt.getChild("ROOT_NODE");
            if (windowData != null) {
                tool.restoreWindowingDataFromXml(windowData);
            }
            Element toolDataElem = elememnt.getChild("DATA_STATE");
            tool.restoreDataStateFromXml(toolDataElem);
            if (hadChanges) {
                tool.setConfigChanged(true);
            }
            this.runningTools.add(tool);
            this.toolManager.fireToolAddedEvent(this, tool);
        }
    }

    void setVisible(boolean state) {
        this.isActive = state;
        Tool[] tools = this.getTools();
        for (int t = 0; t < tools.length; ++t) {
            tools[t].setVisible(state);
        }
    }

    void closeRunningTool(Tool tool) {
        this.runningTools.remove(tool);
        this.toolManager.setWorkspaceChanged(this);
        this.toolManager.toolRemoved(this, tool);
    }

    void close() {
        for (Tool tool : this.runningTools) {
            try {
                tool.exit();
            }
            finally {
                this.toolManager.toolRemoved(this, tool);
            }
        }
        this.runningTools.clear();
    }
}

