/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.symbol.ContextSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.EndSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.EpsilonSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.NameSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.StartSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.Symbol;
import ghidra.app.plugin.processors.sleigh.symbol.SymbolScope;
import ghidra.app.plugin.processors.sleigh.symbol.UseropSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.ValueMapSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.ValueSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeListSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeSymbol;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;

public class SymbolTable {
    private Symbol[] symbollist;
    private UseropSymbol[] userOps;
    private SymbolScope[] table;
    private SymbolScope curscope = null;

    private SymbolScope skipScope(int i) {
        SymbolScope res = this.curscope;
        while (i > 0) {
            if (res.getParent() == null) {
                return res;
            }
            res = res.getParent();
            --i;
        }
        return res;
    }

    private Symbol findSymbolInternal(SymbolScope scope, String nm) {
        while (scope != null) {
            Symbol res = scope.findSymbol(nm);
            if (res != null) {
                return res;
            }
            scope = scope.getParent();
        }
        return null;
    }

    public SymbolScope getCurrentScope() {
        return this.curscope;
    }

    public SymbolScope getGlobalScope() {
        return this.table[0];
    }

    public void setCurrentScope(SymbolScope scope) {
        this.curscope = scope;
    }

    public Symbol findSymbol(String nm) {
        return this.findSymbolInternal(this.curscope, nm);
    }

    public Symbol findSymbol(String nm, int skip) {
        return this.findSymbolInternal(this.skipScope(skip), nm);
    }

    public Symbol findGlobalSymbol(String nm) {
        return this.findSymbolInternal(this.table[0], nm);
    }

    public Symbol[] getSymbolList() {
        return this.symbollist;
    }

    public Symbol findSymbol(int id) {
        return this.symbollist[id];
    }

    public void restoreXml(XmlPullParser parser, SleighLanguage sleigh) throws UnknownInstructionException {
        int id;
        XmlElement subel;
        int i;
        XmlElement el = parser.start(new String[]{"symbol_table"});
        int scopesize = SpecXmlUtils.decodeInt((String)el.getAttribute("scopesize"));
        this.table = new SymbolScope[scopesize];
        int symsize = SpecXmlUtils.decodeInt((String)el.getAttribute("symbolsize"));
        this.symbollist = new Symbol[symsize];
        for (i = 0; i < scopesize; ++i) {
            subel = parser.start(new String[]{"scope"});
            id = SpecXmlUtils.decodeInt((String)subel.getAttribute("id"));
            int parent = SpecXmlUtils.decodeInt((String)subel.getAttribute("parent"));
            SymbolScope sscope = parent == id ? null : this.table[parent];
            this.table[id] = new SymbolScope(sscope, id);
            parser.end(subel);
        }
        this.curscope = this.table[0];
        for (i = 0; i < symsize; ++i) {
            this.restoreSymbolHeader(parser);
        }
        ArrayList<UseropSymbol> userops = new ArrayList<UseropSymbol>();
        subel = parser.peek();
        while (!subel.getName().equals("symbol_table")) {
            id = SpecXmlUtils.decodeInt((String)subel.getAttribute("id"));
            Symbol sym = this.findSymbol(id);
            sym.restoreXml(parser, sleigh);
            if (sym instanceof UseropSymbol) {
                userops.add((UseropSymbol)sym);
            }
            subel = parser.peek();
        }
        this.userOps = new UseropSymbol[userops.size()];
        userops.toArray(this.userOps);
        parser.end(el);
    }

    public void restoreSymbolHeader(XmlPullParser parser) {
        Symbol sym;
        XmlElement el = parser.peek();
        if (el.getName().equals("userop_head")) {
            sym = new UseropSymbol();
        } else if (el.getName().equals("epsilon_sym_head")) {
            sym = new EpsilonSymbol();
        } else if (el.getName().equals("value_sym_head")) {
            sym = new ValueSymbol();
        } else if (el.getName().equals("valuemap_sym_head")) {
            sym = new ValueMapSymbol();
        } else if (el.getName().equals("name_sym_head")) {
            sym = new NameSymbol();
        } else if (el.getName().equals("varnode_sym_head")) {
            sym = new VarnodeSymbol();
        } else if (el.getName().equals("context_sym_head")) {
            sym = new ContextSymbol();
        } else if (el.getName().equals("varlist_sym_head")) {
            sym = new VarnodeListSymbol();
        } else if (el.getName().equals("operand_sym_head")) {
            sym = new OperandSymbol();
        } else if (el.getName().equals("start_sym_head")) {
            sym = new StartSymbol();
        } else if (el.getName().equals("end_sym_head")) {
            sym = new EndSymbol();
        } else if (el.getName().equals("subtable_sym_head")) {
            sym = new SubtableSymbol();
        } else {
            throw new SleighException("Bad symbol xml");
        }
        sym.restoreHeaderXml(parser);
        this.symbollist[sym.getId()] = sym;
        this.table[sym.getScopeId()].addSymbol(sym);
    }

    public int getNumberOfUserDefinedOpNames() {
        return this.userOps.length;
    }

    public String getUserDefinedOpName(int index) {
        if (index < this.userOps.length) {
            return this.userOps[index].getName();
        }
        return null;
    }
}

