/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.app.plugin.processors.sleigh.symbol.ValueSymbol;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ValueMapSymbol
extends ValueSymbol {
    private long[] valuetable;
    private boolean tableisfilled;

    public List<Long> getMap() {
        ArrayList<Long> result = new ArrayList<Long>();
        for (long v : this.valuetable) {
            result.add(v);
        }
        return Collections.unmodifiableList(result);
    }

    private void checkTableFill() {
        long min = this.getPatternValue().minValue();
        long max = this.getPatternValue().maxValue();
        this.tableisfilled = min >= 0L && max < (long)this.valuetable.length;
        for (long element : this.valuetable) {
            if (element != 195935983L) continue;
            this.tableisfilled = false;
        }
    }

    @Override
    public Constructor resolve(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException, UnknownInstructionException {
        long ind;
        if (!(this.tableisfilled || (ind = this.getPatternValue().getValue(walker)) < (long)this.valuetable.length && ind >= 0L && this.valuetable[(int)ind] != 195935983L)) {
            String errmsg = "No corresponding entry in valuetable <" + this.getName() + ">, index=" + ind;
            if (debug != null) {
                debug.append(errmsg + "\n");
            }
            throw new UnknownInstructionException(errmsg);
        }
        return null;
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker walker) throws MemoryAccessException {
        int ind = (int)this.getPatternValue().getValue(walker);
        hand.space = walker.getConstSpace();
        hand.offset_space = null;
        hand.offset_offset = this.valuetable[ind];
        hand.size = 0;
    }

    @Override
    public String print(ParserWalker walker) throws MemoryAccessException {
        int ind = (int)this.getPatternValue().getValue(walker);
        long val = this.valuetable[ind];
        String res = val >= 0L ? "0x" + Long.toHexString(val) : "-0x" + Long.toHexString(-val);
        return res;
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage sleigh) {
        XmlElement valuetab;
        XmlElement el = parser.start(new String[]{"valuemap_sym"});
        this.patval = (PatternValue)PatternExpression.restoreExpression(parser, sleigh);
        ArrayList<String> values = new ArrayList<String>();
        while ((valuetab = parser.softStart(new String[]{"valuetab"})) != null) {
            values.add(valuetab.getAttribute("val"));
            parser.end(valuetab);
        }
        this.valuetable = new long[values.size()];
        for (int i = 0; i < this.valuetable.length; ++i) {
            this.valuetable[i] = SpecXmlUtils.decodeLong((String)((String)values.get(i)));
        }
        this.checkTableFill();
        parser.end(el);
    }
}

