/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.template;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.template.ConstTpl;
import ghidra.program.model.address.AddressFactory;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class VarnodeTpl {
    private ConstTpl space;
    private ConstTpl offset;
    private ConstTpl size;

    protected VarnodeTpl() {
    }

    public VarnodeTpl(ConstTpl space, ConstTpl offset, ConstTpl size) {
        this.space = space;
        this.offset = offset;
        this.size = size;
    }

    public ConstTpl getSpace() {
        return this.space;
    }

    public ConstTpl getOffset() {
        return this.offset;
    }

    public ConstTpl getSize() {
        return this.size;
    }

    public boolean isDynamic(ParserWalker walker) {
        if (this.offset.getType() != 1) {
            return false;
        }
        return walker.getFixedHandle((int)this.offset.getHandleIndex()).offset_space != null;
    }

    public boolean isRelative() {
        return this.offset.getType() == 7;
    }

    public void restoreXml(XmlPullParser parser, AddressFactory factory) {
        XmlElement el = parser.start(new String[]{"varnode_tpl"});
        this.space = new ConstTpl();
        this.space.restoreXml(parser, factory);
        this.offset = new ConstTpl();
        this.offset.restoreXml(parser, factory);
        this.size = new ConstTpl();
        this.size.restoreXml(parser, factory);
        parser.end(el);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.space);
        sb.append('[');
        sb.append(this.offset);
        sb.append(':');
        sb.append(this.size);
        sb.append(']');
        return sb.toString();
    }
}

