/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.Record;
import ghidra.program.database.DBObjectCache;
import ghidra.util.Lock;
import java.util.ConcurrentModificationException;

public abstract class DatabaseObject {
    protected long key;
    private volatile boolean deleted;
    private final DBObjectCache cache;
    private volatile int invalidateCount;

    public DatabaseObject(DBObjectCache cache, long key) {
        this.key = key;
        this.cache = cache;
        if (cache != null) {
            cache.put(this);
            this.invalidateCount = cache.getInvalidateCount();
        }
    }

    public long getKey() {
        return this.key;
    }

    void setDeleted() {
        this.deleted = true;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setInvalid() {
        this.invalidateCount = this.getCurrentValidationCount() - 1;
    }

    private void setValid() {
        this.invalidateCount = this.getCurrentValidationCount();
    }

    private int getCurrentValidationCount() {
        return this.cache != null ? this.cache.getInvalidateCount() : 0;
    }

    protected void keyChanged(long newKey) {
        long oldKey = this.key;
        this.key = newKey;
        if (this.cache != null) {
            this.cache.keyChanged(oldKey, this.key);
        }
    }

    public boolean isInvalid() {
        return this.invalidateCount != this.getCurrentValidationCount();
    }

    public void checkDeleted() {
        if (!this.checkIsValid()) {
            throw new ConcurrentModificationException("Object has been deleted.");
        }
    }

    public boolean checkIsValid() {
        return this.checkIsValid(null);
    }

    public boolean checkIsValid(Record record) {
        if (this.deleted) {
            return false;
        }
        if (this.isInvalid()) {
            this.setValid();
            if (!this.refresh(record)) {
                if (this.cache != null) {
                    this.cache.delete(this.key);
                }
                this.setDeleted();
                this.setInvalid();
            }
        }
        return !this.deleted;
    }

    public boolean validate(Lock lock) {
        if (!this.deleted && !this.isInvalid()) {
            return true;
        }
        lock.acquire();
        try {
            boolean bl = this.checkIsValid();
            return bl;
        }
        finally {
            lock.release();
        }
    }

    protected abstract boolean refresh();

    protected boolean refresh(Record record) {
        return this.refresh();
    }
}

