/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.data.ArrayDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class ArrayDBAdapterV0
extends ArrayDBAdapter {
    private static final String ARRAY_TABLE_NAME = "Arrays";
    private static final int V0_ARRAY_DT_ID_COL = 0;
    private static final int V0_ARRAY_DIM_COL = 1;
    private static final int V0_ARRAY_LENGTH_COL = 2;
    private Table table;

    public ArrayDBAdapterV0(DBHandle handle) throws VersionException {
        this.table = handle.getTable(ARRAY_TABLE_NAME);
        if (this.table == null) {
            throw new VersionException("Missing Table: Arrays");
        }
        if (this.table.getSchema().getVersion() != 0) {
            throw new VersionException("Expected version 0 for table Arrays but got " + this.table.getSchema().getVersion());
        }
    }

    @Override
    public Record createRecord(long dataTypeID, int numberOfElements, int length, long catID) throws IOException {
        return null;
    }

    @Override
    public Record getRecord(long arrayID) throws IOException {
        return this.translateRecord(this.table.getRecord(arrayID));
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.table.iterator());
    }

    @Override
    public boolean removeRecord(long dataID) throws IOException {
        return false;
    }

    @Override
    public void updateRecord(Record record) throws IOException {
    }

    private Record translateRecord(Record oldRec) {
        if (oldRec == null) {
            return null;
        }
        Record rec = ArrayDBAdapter.SCHEMA.createRecord(oldRec.getKey());
        rec.setLongValue(0, oldRec.getLongValue(0));
        rec.setIntValue(1, oldRec.getIntValue(1));
        rec.setIntValue(2, oldRec.getIntValue(2));
        rec.setLongValue(3, 0L);
        return rec;
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(ARRAY_TABLE_NAME);
    }

    @Override
    long[] getRecordIdsInCategory(long categoryID) throws IOException {
        return new long[0];
    }

    private class TranslatedRecordIterator
    implements RecordIterator {
        private RecordIterator it;

        TranslatedRecordIterator(RecordIterator it) {
            this.it = it;
        }

        public boolean delete() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() throws IOException {
            return this.it.hasNext();
        }

        public boolean hasPrevious() throws IOException {
            return this.it.hasPrevious();
        }

        public Record next() throws IOException {
            Record rec = this.it.next();
            return ArrayDBAdapterV0.this.translateRecord(rec);
        }

        public Record previous() throws IOException {
            Record rec = this.it.previous();
            return ArrayDBAdapterV0.this.translateRecord(rec);
        }
    }
}

