/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import ghidra.program.database.data.ParentChildDBAdapterNoTable;
import ghidra.program.database.data.ParentChildDBAdapterV0;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class ParentChildAdapter {
    static final String TABLE_NAME = "DT_PARENT_CHILD";

    ParentChildAdapter() {
    }

    static ParentChildAdapter getAdapter(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == 0) {
            return new ParentChildDBAdapterV0(handle, true);
        }
        try {
            return new ParentChildDBAdapterV0(handle, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            ParentChildAdapter adapter = ParentChildAdapter.findReadOnlyAdapter(handle);
            if (openMode == 3) {
                adapter = ParentChildAdapter.upgrade(handle, adapter);
            }
            return adapter;
        }
    }

    static ParentChildAdapter findReadOnlyAdapter(DBHandle handle) {
        return new ParentChildDBAdapterNoTable(handle);
    }

    static ParentChildAdapter upgrade(DBHandle handle, ParentChildAdapter oldAdapter) throws VersionException, IOException {
        ParentChildDBAdapterV0 adapter = new ParentChildDBAdapterV0(handle, true);
        adapter.setNeedsInitializing();
        return adapter;
    }

    abstract boolean needsInitializing();

    abstract int getVersion();

    abstract void createRecord(long var1, long var3) throws IOException;

    abstract void removeRecord(long var1, long var3) throws IOException;

    abstract long[] getParentIds(long var1) throws IOException;

    abstract void removeAllRecordsForParent(long var1) throws IOException;

    abstract void removeAllRecordsForChild(long var1) throws IOException;
}

