/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.program.database.data.SourceArchiveImpl;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.util.UniversalID;
import java.util.HashMap;
import java.util.Map;

public class SourceArchiveUpgradeMap {
    private static final long OLD_CLIB_ARCHIVE_ID = 2585014296036210369L;
    private static final long OLD_WINDOWS_ARCHIVE_ID = 2592694847825635591L;
    private static final long OLD_NTDDK_ARCHIVE_ID = 2585014353215059675L;
    private static final long[] oldArchiveIds = new long[]{2585014296036210369L, 2585014353215059675L, 2592694847825635591L};
    private CompilerSpecID WINDOWS_CSPEC_ID = new CompilerSpecID("windows");
    private Map<UniversalID, SourceArchive> windowsMap;
    private Map<UniversalID, SourceArchive> defaultMap;

    public SourceArchiveUpgradeMap() {
        UniversalID NEW_WINDOWS_SUPER_ARCHIVE_ID = new UniversalID(2644092282468053077L);
        UniversalID NEW_DEFAULT_CLIB_ARCHIVE_ID = new UniversalID(2644097909188870631L);
        String NEW_WINDOWS_SUPER_ARCHIVE_NAME = "windows_vs12_32";
        String NEW_DEFAULT_CLIB_ARCHIVE_NAME = "generic_clib";
        SourceArchiveImpl newWindowsArchive = new SourceArchiveImpl(NEW_WINDOWS_SUPER_ARCHIVE_ID, NEW_WINDOWS_SUPER_ARCHIVE_NAME);
        SourceArchiveImpl newDefaultClibArchive = new SourceArchiveImpl(NEW_DEFAULT_CLIB_ARCHIVE_ID, NEW_DEFAULT_CLIB_ARCHIVE_NAME);
        this.windowsMap = new HashMap<UniversalID, SourceArchive>();
        this.windowsMap.put(new UniversalID(2585014296036210369L), newWindowsArchive);
        this.windowsMap.put(new UniversalID(2592694847825635591L), newWindowsArchive);
        this.windowsMap.put(new UniversalID(2585014353215059675L), newWindowsArchive);
        this.defaultMap = new HashMap<UniversalID, SourceArchive>();
        this.defaultMap.put(new UniversalID(2585014296036210369L), newDefaultClibArchive);
        SourceArchiveImpl removedSourceArchive = new SourceArchiveImpl();
        this.defaultMap.put(new UniversalID(2592694847825635591L), removedSourceArchive);
        this.defaultMap.put(new UniversalID(2585014353215059675L), removedSourceArchive);
    }

    public SourceArchive getMappedSourceArchive(SourceArchive sourceArchive, CompilerSpec compiler) {
        SourceArchive replacementSourceArchive;
        CompilerSpecID compilerSpecID;
        if (compiler != null && this.WINDOWS_CSPEC_ID.equals(compilerSpecID = compiler.getCompilerSpecID()) && (replacementSourceArchive = this.windowsMap.get(sourceArchive.getSourceArchiveID())) != null) {
            return replacementSourceArchive;
        }
        return this.defaultMap.get(sourceArchive.getSourceArchiveID());
    }

    public static boolean isReplacedSourceArchive(long id) {
        for (long oldId : oldArchiveIds) {
            if (id != oldId) continue;
            return true;
        }
        return false;
    }

    public static String[] getTypedefReplacements() {
        return new String[]{"short", "int", "long", "longlong", "wchar_t", "bool"};
    }
}

