/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import ghidra.program.database.mem.ByteSourceRange;
import ghidra.program.model.mem.MemoryBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ByteSourceRangeList
implements Iterable<ByteSourceRange> {
    List<ByteSourceRange> ranges = new ArrayList<ByteSourceRange>();

    public ByteSourceRangeList(ByteSourceRange bsRange) {
        this();
        this.ranges.add(bsRange);
    }

    public ByteSourceRangeList() {
    }

    @Override
    public Iterator<ByteSourceRange> iterator() {
        return this.ranges.iterator();
    }

    public void add(ByteSourceRange range) {
        if (range != null) {
            this.ranges.add(range);
        }
    }

    public void add(ByteSourceRangeList byteSourceList) {
        this.ranges.addAll(byteSourceList.ranges);
    }

    public int getRangeCount() {
        return this.ranges.size();
    }

    public ByteSourceRange get(int i) {
        return this.ranges.get(i);
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public Set<MemoryBlock> getOverlappingBlocks() {
        ArrayList<BlockRangeEntry> entries = new ArrayList<BlockRangeEntry>();
        for (ByteSourceRange range : this.ranges) {
            entries.add(new BlockRangeStart(this, range));
            entries.add(new BlockRangeEnd(this, range));
        }
        Collections.sort(entries);
        return this.findOverlappingBlocks(entries);
    }

    public ByteSourceRangeList intersect(ByteSourceRangeList rangeList) {
        ArrayList<BlockRangeEntry> entries = new ArrayList<BlockRangeEntry>();
        for (ByteSourceRange range : this.ranges) {
            entries.add(new BlockRangeStart(this, range));
            entries.add(new BlockRangeEnd(this, range));
        }
        for (ByteSourceRange range : rangeList) {
            entries.add(new BlockRangeStart(rangeList, range));
            entries.add(new BlockRangeEnd(rangeList, range));
        }
        Collections.sort(entries);
        return this.getIntersectingRanges(entries);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ranges == null ? 0 : this.ranges.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteSourceRangeList other = (ByteSourceRangeList)obj;
        return !(this.ranges == null ? other.ranges != null : !this.ranges.equals(other.ranges));
    }

    private ByteSourceRangeList getIntersectingRanges(List<BlockRangeEntry> entries) {
        ByteSourceRangeList result = new ByteSourceRangeList();
        HashSet<ByteSourceRange> currentSet = new HashSet<ByteSourceRange>();
        for (BlockRangeEntry entry : entries) {
            if (entry.isStart()) {
                currentSet.add(entry.range);
                continue;
            }
            currentSet.remove(entry.range);
            this.addIntersections(result, entry, currentSet);
        }
        return result;
    }

    private void addIntersections(ByteSourceRangeList set, BlockRangeEntry entry, Set<ByteSourceRange> currentSet) {
        if (currentSet.isEmpty()) {
            return;
        }
        for (ByteSourceRange byteSourceRange : currentSet) {
            if (entry.owner == this) {
                set.add(entry.range.intersect(byteSourceRange));
                continue;
            }
            set.add(byteSourceRange.intersect(entry.range));
        }
    }

    private Set<MemoryBlock> findOverlappingBlocks(List<BlockRangeEntry> entries) {
        HashSet<MemoryBlock> overlappingBlocks = new HashSet<MemoryBlock>();
        HashSet<ByteSourceRange> currentSet = new HashSet<ByteSourceRange>();
        for (BlockRangeEntry entry : entries) {
            if (entry.isStart()) {
                currentSet.add(entry.range);
                continue;
            }
            currentSet.remove(entry.range);
            if (currentSet.isEmpty()) continue;
            overlappingBlocks.add(entry.range.block);
            for (ByteSourceRange byteSourceRange : currentSet) {
                overlappingBlocks.add(byteSourceRange.block);
            }
        }
        return overlappingBlocks;
    }

    class BlockRangeEnd
    extends BlockRangeEntry {
        BlockRangeEnd(ByteSourceRangeList owner, ByteSourceRange range) {
            super(owner, range, range.getOffset() + range.size - 1L);
        }

        @Override
        boolean isStart() {
            return false;
        }
    }

    class BlockRangeStart
    extends BlockRangeEntry {
        BlockRangeStart(ByteSourceRangeList owner, ByteSourceRange range) {
            super(owner, range, range.getOffset());
        }

        @Override
        boolean isStart() {
            return true;
        }
    }

    abstract class BlockRangeEntry
    implements Comparable<BlockRangeEntry> {
        private ByteSourceRange range;
        private long sourceId;
        private long offset;
        private ByteSourceRangeList owner;

        BlockRangeEntry(ByteSourceRangeList owner, ByteSourceRange range, long offset) {
            this.owner = owner;
            this.range = range;
            this.offset = offset;
            this.sourceId = range.getSourceId();
        }

        abstract boolean isStart();

        @Override
        public int compareTo(BlockRangeEntry o) {
            if (this.sourceId != o.sourceId) {
                return this.sourceId > o.sourceId ? 1 : -1;
            }
            if (this.offset == o.offset) {
                return this.isStart() == o.isStart() ? 0 : (this.isStart() ? -1 : 1);
            }
            return this.offset > o.offset ? 1 : -1;
        }
    }
}

