/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.oldfunction;

import db.Record;
import ghidra.program.database.oldfunction.OldFunctionDataDB;
import ghidra.program.database.oldfunction.OldFunctionManager;
import ghidra.program.database.oldfunction.OldStackVariableDBAdapter;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.StackVariableComparator;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableImpl;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class OldStackFrameDB
implements StackFrame {
    private int localSize;
    private int paramStart;
    private int returnStart;
    private List<Variable> variables;
    private OldFunctionDataDB function;
    private OldFunctionManager functionManager;
    private OldStackVariableDBAdapter adapter;
    private static final Variable[] emptyArray = new Variable[0];

    OldStackFrameDB(OldFunctionDataDB function) {
        this.function = function;
        this.functionManager = function.getFunctionManager();
        this.adapter = this.functionManager.getStackVariableAdapter();
        this.refresh();
    }

    void refresh() {
        this.paramStart = this.function.getStackParamOffset();
        this.returnStart = this.function.getStackReturnOffset();
        this.localSize = this.function.getStackLocalSize();
        this.variables = null;
        this.loadStackVariables();
    }

    OldFunctionManager getFunctionManager() {
        return this.functionManager;
    }

    OldFunctionDataDB getFunctionData() {
        return this.function;
    }

    @Override
    public Function getFunction() {
        return null;
    }

    private void loadStackVariables() {
        if (this.variables != null) {
            return;
        }
        try {
            this.variables = new ArrayList<Variable>();
            long[] keys = this.adapter.getStackVariableKeys(this.function.getKey());
            for (int i = 0; i < keys.length; ++i) {
                Record varRec = this.adapter.getStackVariableRecord(keys[i]);
                this.variables.add(this.getStackVariable(varRec));
            }
            Collections.sort(this.variables, StackVariableComparator.get());
        }
        catch (IOException e) {
            this.functionManager.dbError(e);
        }
    }

    private Variable getStackVariable(Record record) {
        VariableImpl var;
        int offset = record.getIntValue(1);
        long dataTypeId = record.getLongValue(2);
        String name = record.getString(3);
        String comment = record.getString(4);
        DataType dataType = this.functionManager.getDataType(dataTypeId);
        try {
            var = this.isParameterOffset(offset) ? new ParameterImpl(name, dataType, offset, (Program)this.functionManager.getProgram()) : new LocalVariableImpl(name, dataType, offset, this.functionManager.getProgram());
        }
        catch (InvalidInputException e) {
            throw new RuntimeException(e);
        }
        catch (AddressOutOfBoundsException e) {
            Msg.error((Object)this, (Object)("Invalid stack variable '" + name + "' in function at " + this.function.getEntryPoint() + ": " + e.getMessage()));
            try {
                var = new LocalVariableImpl(name, 0, dataType, VariableStorage.BAD_STORAGE, (Program)this.functionManager.getProgram());
            }
            catch (InvalidInputException e1) {
                throw new RuntimeException(e);
            }
        }
        if (comment != null && comment.length() != 0) {
            var.setComment(comment);
        }
        return var;
    }

    @Override
    public Variable createVariable(String name, int offset, DataType dataType, SourceType source) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable[] getStackVariables() {
        OldFunctionDataDB oldFunctionDataDB = this.function;
        synchronized (oldFunctionDataDB) {
            this.loadStackVariables();
            if (this.variables.isEmpty()) {
                return emptyArray;
            }
            return this.variables.toArray(emptyArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable[] getLocals() {
        OldFunctionDataDB oldFunctionDataDB = this.function;
        synchronized (oldFunctionDataDB) {
            this.loadStackVariables();
            if (this.paramStart >= 0) {
                return this.getNegativeVariables();
            }
            return this.getPositiveVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable[] getParameters() {
        OldFunctionDataDB oldFunctionDataDB = this.function;
        synchronized (oldFunctionDataDB) {
            this.loadStackVariables();
            return this.paramStart >= 0 ? this.getPositiveVariables() : this.getNegativeVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFrameSize() {
        OldFunctionDataDB oldFunctionDataDB = this.function;
        synchronized (oldFunctionDataDB) {
            int size = this.getLocalSize();
            int n = this.growsNegative() ? this.getPositiveSize() : this.getNegativeSize();
            return size += n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLocalSize() {
        OldFunctionDataDB oldFunctionDataDB = this.function;
        synchronized (oldFunctionDataDB) {
            if (this.localSize > 0) {
                return this.localSize;
            }
            if (this.growsNegative()) {
                return this.getNegativeSize();
            }
            return this.getPositiveSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean growsNegative() {
        OldFunctionDataDB oldFunctionDataDB = this.function;
        synchronized (oldFunctionDataDB) {
            return this.paramStart >= 0;
        }
    }

    @Override
    public void setLocalSize(int size) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getParameterSize() {
        OldFunctionDataDB oldFunctionDataDB = this.function;
        synchronized (oldFunctionDataDB) {
            if (this.growsNegative()) {
                return this.getPositiveSize() - this.getParameterOffset();
            }
            return this.getNegativeSize() + this.getParameterOffset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getParameterCount() {
        OldFunctionDataDB oldFunctionDataDB = this.function;
        synchronized (oldFunctionDataDB) {
            this.loadStackVariables();
            if (this.growsNegative()) {
                return this.getPositiveCount();
            }
            return this.getNegativeCount();
        }
    }

    @Override
    public void clearVariable(int offset) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getParameterOffset() {
        OldFunctionDataDB oldFunctionDataDB = this.function;
        synchronized (oldFunctionDataDB) {
            if (this.paramStart == 0 && !this.variables.isEmpty()) {
                Variable var;
                this.loadStackVariables();
                Integer key = new Integer(0);
                int loc = Collections.binarySearch(this.variables, key, StackVariableComparator.get());
                int n = loc = loc < 0 ? -1 - loc : loc;
                if (loc < this.variables.size() && (var = this.variables.get(loc)) != null) {
                    return var.getStackOffset();
                }
            }
            return this.paramStart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getReturnAddressOffset() {
        OldFunctionDataDB oldFunctionDataDB = this.function;
        synchronized (oldFunctionDataDB) {
            return this.returnStart;
        }
    }

    @Override
    public void setReturnAddressOffset(int offset) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable getVariableContaining(int offset) {
        OldFunctionDataDB oldFunctionDataDB = this.function;
        synchronized (oldFunctionDataDB) {
            this.loadStackVariables();
            Integer key = new Integer(offset);
            int index = Collections.binarySearch(this.variables, key, StackVariableComparator.get());
            if (index >= 0) {
                return this.variables.get(index);
            }
            index = -index - 1;
            if (--index < 0) {
                return null;
            }
            Variable var = this.variables.get(index);
            int stackOffset = var.getStackOffset();
            if (stackOffset + var.getLength() > offset) {
                return var;
            }
            return null;
        }
    }

    private int getNegativeSize() {
        if (this.variables.isEmpty()) {
            return this.growsNegative() ? 0 : -this.paramStart;
        }
        Variable var = this.variables.get(0);
        int stackOffset = var.getStackOffset();
        if (stackOffset >= 0) {
            return this.growsNegative() ? 0 : -this.paramStart;
        }
        return 0 - stackOffset;
    }

    private int getPositiveSize() {
        if (this.variables.isEmpty()) {
            return this.growsNegative() ? this.paramStart : 0;
        }
        Variable var = this.variables.get(this.variables.size() - 1);
        int stackOffset = var.getStackOffset();
        if (stackOffset < 0) {
            return this.growsNegative() ? this.paramStart : 0;
        }
        return stackOffset + var.getLength();
    }

    private Variable[] getNegativeVariables() {
        Variable var;
        int stackOffset;
        int start;
        if (this.variables.isEmpty()) {
            return emptyArray;
        }
        int length = this.variables.size();
        int index = 0;
        for (index = 0; index < length && (start = (stackOffset = (var = this.variables.get(index)).getStackOffset())) < 0 && start <= this.paramStart; ++index) {
        }
        if (index == 0) {
            return emptyArray;
        }
        List<Variable> vars = this.variables.subList(0, index);
        int size = vars.size();
        Variable[] retvars = new Variable[size];
        int pos = size - 1;
        int i = 0;
        while (i < size) {
            retvars[pos] = vars.get(i);
            ++i;
            --pos;
        }
        return retvars;
    }

    private Variable[] getPositiveVariables() {
        Variable var;
        int stackOffset;
        if (this.variables.isEmpty()) {
            return emptyArray;
        }
        int length = this.variables.size();
        int index = 0;
        for (index = 0; index < length && ((stackOffset = (var = this.variables.get(index)).getStackOffset()) < 0 || stackOffset < this.paramStart); ++index) {
        }
        if (index == length) {
            return emptyArray;
        }
        List<Variable> vars = this.variables.subList(index, length);
        return vars.toArray(emptyArray);
    }

    private int getNegativeCount() {
        Variable var;
        int stackOffset;
        if (this.variables.isEmpty()) {
            return 0;
        }
        int length = this.variables.size();
        int index = 0;
        for (index = 0; index < length && (stackOffset = (var = this.variables.get(index)).getStackOffset()) < 0 && stackOffset < this.paramStart; ++index) {
        }
        if (index == 0) {
            return 0;
        }
        return index;
    }

    private int getPositiveCount() {
        Variable var;
        int stackOffset;
        if (this.variables.isEmpty()) {
            return 0;
        }
        int length = this.variables.size();
        int index = 0;
        for (index = 0; index < length && ((stackOffset = (var = this.variables.get(index)).getStackOffset()) < 0 || stackOffset < this.paramStart); ++index) {
        }
        if (index == length) {
            return 0;
        }
        return length - index;
    }

    @Override
    public boolean isParameterOffset(int offset) {
        return offset >= 0 ? this.growsNegative() : !this.growsNegative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        OldFunctionDataDB oldFunctionDataDB = this.function;
        synchronized (oldFunctionDataDB) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof OldStackFrameDB)) {
                return false;
            }
            OldStackFrameDB otherFrame = (OldStackFrameDB)obj;
            if (this.getLocalSize() != otherFrame.getLocalSize() || this.getParameterOffset() != otherFrame.getParameterOffset() || this.returnStart != otherFrame.returnStart || this.variables.size() != otherFrame.variables.size()) {
                return false;
            }
            Iterator<Variable> myIter = this.variables.iterator();
            Iterator<Variable> otherIter = otherFrame.variables.iterator();
            while (myIter.hasNext() && otherIter.hasNext()) {
                Variable otherVar;
                Variable myVar = myIter.next();
                if (myVar.equals(otherVar = otherIter.next())) continue;
                return false;
            }
            return true;
        }
    }
}

