/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SpecialAddress;
import java.math.BigInteger;

public interface Address
extends Comparable<Address> {
    public static final Address NO_ADDRESS = new SpecialAddress("NO ADDRESS");
    public static final Address EXT_FROM_ADDRESS = new SpecialAddress("Entry Point");
    public static final char SEPARATOR_CHAR = ':';

    public Address getAddress(String var1) throws AddressFormatException;

    public Address getNewAddress(long var1);

    public Address getNewAddress(long var1, boolean var3) throws AddressOutOfBoundsException;

    public Address getNewTruncatedAddress(long var1, boolean var3);

    public int getPointerSize();

    public Address next();

    public Address previous();

    public long getOffset();

    public BigInteger getOffsetAsBigInteger();

    public long getUnsignedOffset();

    public long getAddressableWordOffset();

    public AddressSpace getAddressSpace();

    public boolean hasSameAddressSpace(Address var1);

    public int getSize();

    public long subtract(Address var1);

    public Address subtractWrap(long var1);

    public Address subtractWrapSpace(long var1);

    public Address subtractNoWrap(long var1) throws AddressOverflowException;

    public Address subtract(long var1);

    public Address addWrap(long var1);

    public Address addWrapSpace(long var1);

    public Address addNoWrap(long var1) throws AddressOverflowException;

    public Address addNoWrap(BigInteger var1) throws AddressOverflowException;

    public Address add(long var1) throws AddressOutOfBoundsException;

    public boolean isSuccessor(Address var1);

    public String toString();

    public String toString(String var1);

    public String toString(boolean var1);

    public String toString(boolean var1, boolean var2);

    public String toString(boolean var1, int var2);

    public boolean equals(Object var1);

    public int hashCode();

    public Address getPhysicalAddress();

    public boolean isMemoryAddress();

    public boolean isLoadedMemoryAddress();

    public boolean isNonLoadedMemoryAddress();

    public boolean isStackAddress();

    public boolean isUniqueAddress();

    public boolean isConstantAddress();

    public boolean isHashAddress();

    public boolean isRegisterAddress();

    public boolean isVariableAddress();

    public boolean isExternalAddress();
}

