/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.database.register.AddressRangeObjectMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionError;
import ghidra.program.model.listing.Instruction;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class InstructionSet
implements Iterable<InstructionBlock> {
    private Map<Address, InstructionBlock> blockMap = new HashMap<Address, InstructionBlock>();
    private AddressRangeObjectMap<InstructionBlock> blockRangeMap = new AddressRangeObjectMap();
    private Set<Address> startAddresses = new HashSet<Address>();
    private List<InstructionBlock> emptyBlocks = new ArrayList<InstructionBlock>();
    private AddressSet addressSet = new AddressSet();
    private int instructionCount = 0;

    public InstructionSet(AddressFactory addrFactory) {
    }

    public void addBlock(InstructionBlock block) {
        InstructionBlock oldBlock;
        if (block.isEmpty()) {
            this.emptyBlocks.add(block);
            return;
        }
        if (block.isFlowStart() || this.blockRangeMap.getObject(block.getFlowFromAddress()) == null) {
            this.startAddresses.add(block.getStartAddress());
        }
        if ((oldBlock = this.blockMap.put(block.getStartAddress(), block)) != null && oldBlock != block) {
            throw new AssertException("More than one block exists with the same start address");
        }
        this.addressSet.addRange(block.getStartAddress(), block.getMaxAddress());
        this.instructionCount += block.getInstructionCount();
        this.blockRangeMap.setObject(block.getStartAddress(), block.getMaxAddress(), block);
    }

    public InstructionBlock getInstructionBlockContaining(Address address) {
        InstructionBlock block = this.blockRangeMap.getObject(address);
        if (block != null) {
            return block;
        }
        return this.blockMap.get(address);
    }

    public InstructionBlock findFirstIntersectingBlock(Address min, Address max) {
        InstructionBlock intersectBlock = null;
        for (InstructionBlock block : this.blockMap.values()) {
            Address blockMax;
            Address blockMin = block.getStartAddress();
            if (blockMin.compareTo(max) > 0 || (blockMax = block.getMaxAddress()).compareTo(min) < 0 || intersectBlock != null && intersectBlock.getStartAddress().compareTo(blockMin) < 0) continue;
            intersectBlock = block;
        }
        return intersectBlock;
    }

    public Instruction getInstructionAt(Address address) {
        InstructionBlock block = this.getInstructionBlockContaining(address);
        return block != null ? block.getInstructionAt(address) : null;
    }

    public Address getMinAddress() {
        return this.addressSet.getMinAddress();
    }

    public AddressSetView getAddressSet() {
        return this.addressSet;
    }

    public String toString() {
        return this.addressSet.toString();
    }

    public int getInstructionCount() {
        return this.instructionCount;
    }

    public boolean containsBlockAt(Address blockAddr) {
        return this.blockMap.containsKey(blockAddr);
    }

    public boolean intersects(Address minAddress, Address maxAddress) {
        return this.addressSet.intersects(minAddress, maxAddress);
    }

    @Override
    public Iterator<InstructionBlock> iterator() {
        return new BlockIterator();
    }

    public Iterator<InstructionBlock> emptyBlockIterator() {
        return this.emptyBlocks.iterator();
    }

    public List<InstructionError> getConflicts() {
        ArrayList<InstructionError> conflictList = new ArrayList<InstructionError>();
        for (InstructionBlock block : this) {
            if (!block.hasInstructionError()) continue;
            conflictList.add(block.getInstructionConflict());
        }
        return conflictList;
    }

    static class FlowQueue {
        private SortedSet<Address> set = new TreeSet<Address>();
        private Address first;

        FlowQueue() {
        }

        void addToFront(Address address) {
            this.set.add(address);
            this.first = address;
        }

        void add(Address address) {
            this.set.add(address);
        }

        boolean contains(Address address) {
            return this.set.contains(address);
        }

        boolean isEmpty() {
            return this.set.isEmpty();
        }

        Address removeNext() {
            Address next = this.first;
            this.first = null;
            if (next == null) {
                next = this.set.first();
            }
            this.set.remove(next);
            return next;
        }
    }

    class BlockIterator
    implements Iterator<InstructionBlock> {
        private InstructionBlock currentBlock;
        private Set<Address> visitedBlockSet = new HashSet<Address>();
        private FlowQueue flowQueue = new FlowQueue();

        BlockIterator() {
            for (Address startAddr : InstructionSet.this.startAddresses) {
                this.flowQueue.add(startAddr);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.flowQueue.isEmpty()) {
                this.addFlows(this.currentBlock);
            }
            return !this.flowQueue.isEmpty();
        }

        @Override
        public InstructionBlock next() {
            this.addFlows(this.currentBlock);
            InstructionBlock instructionBlock = this.currentBlock = this.flowQueue.isEmpty() ? null : InstructionSet.this.blockMap.get(this.flowQueue.removeNext());
            if (this.currentBlock != null) {
                this.visitedBlockSet.add(this.currentBlock.getStartAddress());
            }
            return this.currentBlock;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported for this iterator");
        }

        private void addFlows(InstructionBlock block) {
            Address fallThrough;
            if (block == null) {
                return;
            }
            if (!block.hasInstructionError() && (fallThrough = block.getFallThrough()) != null && !InstructionSet.this.startAddresses.contains(fallThrough) && this.isNotVisitedAndHasBlock(fallThrough)) {
                this.flowQueue.addToFront(fallThrough);
            }
            Address conflictAddr = null;
            if (block.hasInstructionError() && (conflictAddr = block.getInstructionConflict().getInstructionAddress()) == null) {
                return;
            }
            for (Address address : block.getBranchFlows()) {
                if (InstructionSet.this.startAddresses.contains(address) || !this.isNotVisitedAndHasBlock(address) || !this.flowsFromBeforeCutoff(address, conflictAddr)) continue;
                this.flowQueue.add(address);
            }
        }

        private boolean flowsFromBeforeCutoff(Address blockAddr, Address cutoffAddr) {
            if (cutoffAddr == null) {
                return true;
            }
            InstructionBlock block = InstructionSet.this.blockMap.get(blockAddr);
            if (block == null) {
                return false;
            }
            return block.getFlowFromAddress().compareTo(cutoffAddr) < 0;
        }

        private boolean isNotVisitedAndHasBlock(Address blockAddr) {
            if (this.visitedBlockSet.contains(blockAddr)) {
                return false;
            }
            return InstructionSet.this.blockMap.containsKey(blockAddr);
        }
    }
}

