/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.rtti;

import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.rtti.AbstractCreateRttiDataModel;
import ghidra.app.cmd.data.rtti.Rtti3Model;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ImageBaseOffset32DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;

public class Rtti1Model
extends AbstractCreateRttiDataModel {
    public static final String DATA_TYPE_NAME = "RTTIBaseClassDescriptor";
    private static String STRUCTURE_NAME = "_s__RTTIBaseClassDescriptor";
    private static final int NUM_BASES_ORDINAL = 1;
    private static final int MEMBER_DISP_ORDINAL = 2;
    private static final int ATTRIBUTES_ORDINAL = 3;
    private static final int CLASS_HIERARCHY_POINTER_ORDINAL = 4;
    private static final int TYPE_DESC_POINTER_OFFSET = 0;
    private static final int NUM_BASES_OFFSET = 4;
    private static final int CLASS_HIERARCHY_POINTER_OFFSET = 24;
    private static final int MDISP_ORDINAL = 0;
    private static final int PDISP_ORDINAL = 1;
    private static final int VDISP_ORDINAL = 2;
    private DataType dataType;
    private TypeDescriptorModel rtti0Model;
    private Rtti3Model rtti3Model;

    public Rtti1Model(Program program, Address rtti1Address, DataValidationOptions validationOptions) {
        super(program, 1, rtti1Address, validationOptions);
    }

    @Override
    public String getName() {
        return DATA_TYPE_NAME;
    }

    @Override
    protected void validateModelSpecificInfo() throws InvalidDataTypeException {
        Program program = this.getProgram();
        Memory memory = program.getMemory();
        Address startAddress = this.getAddress();
        DataType rtti1Dt = this.getDataType();
        DataType baseDt = DataTypeUtils.getBaseDataType((DataType)rtti1Dt);
        Structure rtti1Struct = (Structure)baseDt;
        int length = rtti1Dt.getLength();
        MSDataTypeUtils.getBytes((Memory)memory, (Address)startAddress, (int)length);
        boolean validateReferredToData = this.validationOptions.shouldValidateReferredToData();
        Address rtti0Address = MSDataTypeUtils.getReferencedAddress((Program)program, (Address)startAddress);
        if (rtti0Address == null) {
            this.invalid();
        }
        this.rtti0Model = new TypeDescriptorModel(program, rtti0Address, this.validationOptions);
        if (validateReferredToData) {
            try {
                this.rtti0Model.validate();
            }
            catch (Exception e) {
                this.invalid(e);
            }
        } else if (!this.rtti0Model.isLoadedAndInitializedAddress()) {
            this.invalid("Data referencing " + this.rtti0Model.getName() + " data type isn't a loaded and initialized address " + rtti0Address + ".");
        }
        try {
            int vDisp;
            int pDisp;
            int numBases = memory.getInt(startAddress.add(4L));
            if (numBases < 0) {
                this.invalid();
            }
            DataTypeComponent pmdComponent = rtti1Struct.getComponent(2);
            DataType pmdDt = pmdComponent.getDataType();
            DataType baseDataType = DataTypeUtils.getBaseDataType((DataType)pmdDt);
            Structure pmdDataType = (Structure)baseDataType;
            int pmdOffset = pmdComponent.getOffset();
            int mdispOffset = pmdDataType.getComponent(0).getOffset();
            int pdispOffset = pmdDataType.getComponent(1).getOffset();
            int vdispOffset = pmdDataType.getComponent(2).getOffset();
            int mDisp = memory.getInt(startAddress.add((long)(pmdOffset + mdispOffset)));
            if (mDisp < 0) {
                this.invalid();
            }
            if ((pDisp = memory.getInt(startAddress.add((long)(pmdOffset + pdispOffset)))) < -1) {
                this.invalid();
            }
            if ((vDisp = memory.getInt(startAddress.add((long)(pmdOffset + vdispOffset)))) < 0) {
                this.invalid();
            }
        }
        catch (AddressOutOfBoundsException | MemoryAccessException e) {
            this.invalid();
        }
        Address rtti3Address = MSDataTypeUtils.getReferencedAddress((Program)program, (Address)startAddress.add(24L));
        if (rtti3Address == null) {
            this.invalid();
        }
        DataValidationOptions dontFollowOptions = new DataValidationOptions(this.validationOptions);
        dontFollowOptions.setValidateReferredToData(false);
        this.rtti3Model = new Rtti3Model(program, rtti3Address, dontFollowOptions);
        if (validateReferredToData) {
            try {
                this.rtti3Model.validate();
            }
            catch (Exception e) {
                this.invalid(e);
            }
        } else if (!this.rtti3Model.isLoadedAndInitializedAddress()) {
            this.invalid("Data referencing " + this.rtti3Model.getName() + " data type isn't a loaded and initialized address " + rtti3Address + ".");
        }
    }

    public static DataType getDataType(Program program) {
        DataType rtti1Dt = Rtti1Model.getSimpleDataType(program);
        DataType rtti3Dt = Rtti3Model.getSimpleDataType(program);
        Rtti1Model.setRtti3DataType(rtti1Dt, program, rtti3Dt);
        Rtti3Model.setRtti1DataType(rtti3Dt, program, rtti1Dt);
        return MSDataTypeUtils.getMatchingDataType((Program)program, (DataType)rtti1Dt);
    }

    static void setRtti3DataType(DataType rtti1Dt, Program program, DataType rtti3Dt) {
        DataTypeManager dataTypeManager = program.getDataTypeManager();
        boolean is64Bit = MSDataTypeUtils.is64Bit((Program)program);
        Structure rtti1Struct = (Structure)DataTypeUtils.getBaseDataType((DataType)rtti1Dt);
        ImageBaseOffset32DataType rtti3RefDt = is64Bit ? new ImageBaseOffset32DataType(dataTypeManager) : new PointerDataType(rtti3Dt);
        rtti1Struct.replace(4, (DataType)rtti3RefDt, rtti3RefDt.getLength(), "pClassHierarchyDescriptor", "ref to ClassHierarchyDescriptor (RTTI 3) for class");
    }

    static DataType getSimpleDataType(Program program) {
        DataTypeManager dataTypeManager = program.getDataTypeManager();
        boolean is64Bit = MSDataTypeUtils.is64Bit((Program)program);
        DataType rtti0Dt = TypeDescriptorModel.getDataType(program);
        ImageBaseOffset32DataType rtti0RefDt = is64Bit ? new ImageBaseOffset32DataType(dataTypeManager) : new PointerDataType(rtti0Dt);
        ImageBaseOffset32DataType rtti3RefDt = is64Bit ? new ImageBaseOffset32DataType(dataTypeManager) : new PointerDataType();
        CategoryPath categoryPath = new CategoryPath(CATEGORY_PATH);
        StructureDataType struct = MSDataTypeUtils.getAlignedPack4Structure((DataTypeManager)dataTypeManager, (CategoryPath)categoryPath, (String)STRUCTURE_NAME);
        struct.add((DataType)rtti0RefDt, "pTypeDescriptor", "ref to TypeDescriptor (RTTI 0) for class");
        DWordDataType dWordDataType = new DWordDataType(dataTypeManager);
        struct.add((DataType)dWordDataType, "numContainedBases", "count of extended classes in BaseClassArray (RTTI 2)");
        Structure pmdDataType = MSDataTypeUtils.getPMDDataType((Program)program);
        struct.add((DataType)pmdDataType, "where", "member displacement structure");
        struct.add((DataType)dWordDataType, "attributes", "bit flags");
        struct.add((DataType)rtti3RefDt, "pClassHierarchyDescriptor", "ref to ClassHierarchyDescriptor (RTTI 3) for class");
        return new TypedefDataType(categoryPath, DATA_TYPE_NAME, (DataType)struct, dataTypeManager);
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = Rtti1Model.getDataType(this.getProgram());
        }
        return this.dataType;
    }

    @Override
    protected int getDataTypeLength() {
        return this.getDataType().getLength();
    }

    public Address getRtti0Address() throws InvalidDataTypeException {
        this.checkValidity();
        Program program = this.getProgram();
        Address rtti1Address = this.getAddress();
        Address rtti0ComponentAddress = rtti1Address.add(0L);
        return MSDataTypeUtils.getReferencedAddress((Program)program, (Address)rtti0ComponentAddress);
    }

    public int getNumBases() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getIntegerValue(this.getDataType(), 1, this.getMemBuffer());
    }

    private int getPmdValue(int pmdOrdinal) throws InvalidDataTypeException {
        this.checkValidity();
        DataType rtti1Dt = this.getDataType();
        DataType baseDt = DataTypeUtils.getBaseDataType((DataType)rtti1Dt);
        Structure rtti1Struct = (Structure)baseDt;
        DataTypeComponent component = rtti1Struct.getComponent(2);
        int pmdOffset = component.getOffset();
        Address rtti1Address = this.getAddress();
        Address pmdAddress = rtti1Address.add((long)pmdOffset);
        DataType pmdDataType = component.getDataType();
        DumbMemBufferImpl pmdMemBuffer = new DumbMemBufferImpl(this.getProgram().getMemory(), pmdAddress);
        return EHDataTypeUtilities.getIntegerValue(pmdDataType, pmdOrdinal, (MemBuffer)pmdMemBuffer);
    }

    public int getMDisp() throws InvalidDataTypeException {
        return this.getPmdValue(0);
    }

    public int getPDisp() throws InvalidDataTypeException {
        return this.getPmdValue(1);
    }

    public int getVDisp() throws InvalidDataTypeException {
        return this.getPmdValue(2);
    }

    public int getAttributes() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getIntegerValue(this.getDataType(), 3, this.getMemBuffer());
    }

    public Address getRtti3Address() throws InvalidDataTypeException {
        this.checkValidity();
        Program program = this.getProgram();
        Address rtti1Address = this.getAddress();
        Address rtti3ComponentAddress = rtti1Address.add(24L);
        return MSDataTypeUtils.getReferencedAddress((Program)program, (Address)rtti3ComponentAddress);
    }

    @Override
    public boolean refersToRtti0(Address rtti0Address) {
        Address referredToAddress;
        try {
            referredToAddress = this.getRtti0Address();
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        return rtti0Address.equals((Object)referredToAddress);
    }

    public TypeDescriptorModel getRtti0Model() {
        try {
            this.checkValidity();
        }
        catch (InvalidDataTypeException e) {
            return null;
        }
        return this.rtti0Model;
    }
}

