/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import java.util.Iterator;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Renderers.ByteRenderer;
import org.jf.dexlib.Code.Format.ArrayDataPseudoInstruction;
import org.jf.dexlib.CodeItem;
import org.jf.util.IndentingWriter;

public class ArrayDataMethodItem
extends InstructionMethodItem<ArrayDataPseudoInstruction> {
    public ArrayDataMethodItem(CodeItem codeItem, int codeAddress, ArrayDataPseudoInstruction instruction) {
        super(codeItem, codeAddress, instruction);
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        writer.write(".array-data 0x");
        writer.printUnsignedLongAsHex((long)((ArrayDataPseudoInstruction)this.instruction).getElementWidth());
        writer.write(10);
        writer.indent(4);
        Iterator iterator = ((ArrayDataPseudoInstruction)this.instruction).getElements();
        while (iterator.hasNext()) {
            ArrayDataPseudoInstruction.ArrayElement element = (ArrayDataPseudoInstruction.ArrayElement)iterator.next();
            for (int i = 0; i < element.elementWidth; ++i) {
                if (i != 0) {
                    writer.write(32);
                }
                ByteRenderer.writeUnsignedTo(writer, element.buffer[element.bufferIndex + i]);
            }
            writer.write(10);
        }
        writer.deindent(4);
        writer.write(".end array-data");
        return true;
    }
}

