/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.omf.OmfFileHeader;
import ghidra.app.util.bin.format.omf.OmfLibraryRecord;
import ghidra.file.formats.omf.OmfArchiveFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryFull;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeFull;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;

public class OmfArchiveFileSystemFactory
implements GFileSystemFactoryFull<OmfArchiveFileSystem>,
GFileSystemProbeFull {
    public OmfArchiveFileSystem create(FSRL containerFSRL, FSRLRoot targetFSRL, ByteProvider byteProvider, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        OmfArchiveFileSystem fs = new OmfArchiveFileSystem(targetFSRL, byteProvider);
        fs.mount(monitor);
        return fs;
    }

    public boolean probe(FSRL containerFSRL, ByteProvider byteProvider, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        if (byteProvider.length() < 11L) {
            return false;
        }
        try {
            BinaryReader reader = OmfFileHeader.createReader((ByteProvider)byteProvider);
            return OmfLibraryRecord.checkMagicNumer((BinaryReader)reader);
        }
        catch (IOException e) {
            return false;
        }
    }
}

