/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.zip;

import ghidra.file.formats.zip.ZipFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryWithFile;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;

public class ZipFileSystemFactory
implements GFileSystemFactoryWithFile<ZipFileSystem>,
GFileSystemProbeBytesOnly {
    public static final int START_BYTES_REQUIRED = 2;

    public ZipFileSystem create(FSRL containerFSRL, FSRLRoot targetFSRL, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        ZipFileSystem fs = new ZipFileSystem(targetFSRL);
        try {
            fs.mount(containerFile, monitor);
            return fs;
        }
        catch (IOException ioe) {
            fs.close();
            throw ioe;
        }
    }

    public int getBytesRequired() {
        return 2;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return startBytes[0] == 80 && startBytes[1] == 75;
    }
}

