/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.query.TextFilter;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.extractor.TextExtractor;

public class TextFilterExtractor
implements TextExtractor {
    private final String[] types;
    private final TextFilter filter;

    public TextFilterExtractor(String[] types, TextFilter filter) {
        this.types = types;
        this.filter = filter;
    }

    public TextFilterExtractor(String type, TextFilter filter) {
        this(new String[]{type}, filter);
    }

    public String[] getContentTypes() {
        return this.types;
    }

    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        InternalValue v = null;
        try {
            final InternalValue value = v = InternalValue.createTemporary(stream);
            PropertyState state = new PropertyState((PropertyId)null, 1, true);
            state.setValues(new InternalValue[]{value});
            Map fields = this.filter.doFilter(state, encoding);
            Object fulltext = fields.get(FieldNames.FULLTEXT);
            if (fulltext instanceof Reader) {
                return new FilterReader((Reader)fulltext){

                    public void close() throws IOException {
                        super.close();
                        value.getBLOBFileValue().discard();
                    }
                };
            }
            value.getBLOBFileValue().discard();
            return new StringReader("");
        }
        catch (RepositoryException e) {
            if (v != null) {
                v.getBLOBFileValue().discard();
            }
            return new StringReader("");
        }
    }
}

