/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.core.security.user.NodeResolver;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.util.ISO9075;

class IndexNodeResolver
extends NodeResolver {
    private final QueryManager queryManager;

    IndexNodeResolver(Session session, NamePathResolver resolver) throws RepositoryException {
        super(session, resolver);
        this.queryManager = session.getWorkspace().getQueryManager();
    }

    public Node findNode(Name nodeName, Name ntName) throws RepositoryException {
        Query query = this.buildQuery(nodeName, ntName);
        NodeIterator res = query.execute().getNodes();
        if (res.hasNext()) {
            return res.nextNode();
        }
        return null;
    }

    public Node findNode(Name propertyName, String value, Name ntName) throws RepositoryException {
        Query query = this.buildQuery(value, Collections.singleton(propertyName), ntName, true, 1L);
        NodeIterator res = query.execute().getNodes();
        if (res.hasNext()) {
            return res.nextNode();
        }
        return null;
    }

    public NodeIterator findNodes(Set propertyNames, String value, Name ntName, boolean exact, long maxSize) throws RepositoryException {
        Query query = this.buildQuery(value, propertyNames, ntName, exact, maxSize);
        return query.execute().getNodes();
    }

    private Query buildQuery(Name nodeName, Name ntName) throws RepositoryException {
        StringBuffer stmt = new StringBuffer("/jcr:root");
        stmt.append(this.getSearchRoot(ntName));
        stmt.append("//element(");
        stmt.append(ISO9075.encode(this.getNamePathResolver().getJCRName(nodeName)));
        stmt.append(",");
        stmt.append(this.getNamePathResolver().getJCRName(ntName));
        stmt.append(")");
        return this.queryManager.createQuery(stmt.toString(), "xpath");
    }

    private Query buildQuery(String value, Set props, Name ntName, boolean exact, long maxSize) throws RepositoryException {
        StringBuffer stmt = new StringBuffer("/jcr:root");
        stmt.append(this.getSearchRoot(ntName));
        stmt.append("//element(*,");
        stmt.append(this.getNamePathResolver().getJCRName(ntName));
        if (value == null) {
            stmt.append(")");
        } else {
            stmt.append(")[");
            int i = 0;
            Iterator itr = props.iterator();
            while (itr.hasNext()) {
                stmt.append(exact ? "@" : "jcr:like(@");
                String pName = this.getNamePathResolver().getJCRName((Name)itr.next());
                stmt.append(ISO9075.encode(pName));
                stmt.append(exact ? "='" : ",'%");
                stmt.append(value);
                stmt.append(exact ? "'" : "%')");
                if (++i >= props.size()) continue;
                stmt.append(" or ");
            }
            stmt.append("]");
        }
        return this.queryManager.createQuery(stmt.toString(), "xpath");
    }
}

