/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.layout;

import edu.uci.ics.jung.algorithms.layout.Layout;
import ghidra.graph.graphs.JungDirectedVisualGraph;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.AbstractLayoutProvider;
import ghidra.graph.viewer.layout.JungLayout;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Objects;
import javax.swing.Icon;
import resources.ResourceManager;

public abstract class JungLayoutProvider<V extends VisualVertex, E extends VisualEdge<V>, G extends JungDirectedVisualGraph<V, E>>
extends AbstractLayoutProvider<V, E, G> {
    private static final Icon DEFAULT_ICON = ResourceManager.loadImage((String)"images/color_swatch.png");

    protected abstract Layout<V, E> createLayout(G var1);

    @Override
    public VisualGraphLayout<V, E> getLayout(G g, TaskMonitor monitor) throws CancelledException {
        Objects.requireNonNull(g);
        Layout<V, E> jungLayout = this.createLayout(g);
        this.initVertexLocations(g, jungLayout);
        return new JungLayout<V, E>(jungLayout);
    }

    @Override
    public Icon getActionIcon() {
        return DEFAULT_ICON;
    }
}

