/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Leb128Utils;
import org.jf.dexlib.Util.ReadOnlyArrayList;

public class ClassDataItem
extends Item<ClassDataItem> {
    @Nullable
    private EncodedField[] staticFields = null;
    @Nullable
    private EncodedField[] instanceFields = null;
    @Nullable
    private EncodedMethod[] directMethods = null;
    @Nullable
    private EncodedMethod[] virtualMethods = null;

    public ClassDataItem(DexFile dexFile) {
        super(dexFile);
    }

    private ClassDataItem(DexFile dexFile, @Nullable EncodedField[] staticFields, @Nullable EncodedField[] instanceFields, @Nullable EncodedMethod[] directMethods, @Nullable EncodedMethod[] virtualMethods) {
        super(dexFile);
        this.staticFields = staticFields;
        this.instanceFields = instanceFields;
        this.directMethods = directMethods;
        this.virtualMethods = virtualMethods;
    }

    public static ClassDataItem internClassDataItem(DexFile dexFile, @Nullable List<EncodedField> staticFields, @Nullable List<EncodedField> instanceFields, @Nullable List<EncodedMethod> directMethods, @Nullable List<EncodedMethod> virtualMethods) {
        EncodedField[] staticFieldsArray = null;
        EncodedField[] instanceFieldsArray = null;
        EncodedMethod[] directMethodsArray = null;
        EncodedMethod[] virtualMethodsArray = null;
        if (staticFields != null && staticFields.size() > 0) {
            TreeSet<EncodedField> staticFieldsSet = new TreeSet<EncodedField>();
            for (EncodedField staticField : staticFields) {
                if (staticFieldsSet.contains(staticField)) {
                    System.err.println(String.format("Ignoring duplicate static field definition: %s", staticField.field.getFieldString()));
                    continue;
                }
                staticFieldsSet.add(staticField);
            }
            staticFieldsArray = new EncodedField[staticFieldsSet.size()];
            staticFieldsArray = staticFieldsSet.toArray(staticFieldsArray);
        }
        if (instanceFields != null && instanceFields.size() > 0) {
            TreeSet<EncodedField> instanceFieldsSet = new TreeSet<EncodedField>();
            for (EncodedField instanceField : instanceFields) {
                if (instanceFieldsSet.contains(instanceField)) {
                    System.err.println(String.format("Ignoring duplicate instance field definition: %s", instanceField.field.getFieldString()));
                    continue;
                }
                instanceFieldsSet.add(instanceField);
            }
            instanceFieldsArray = new EncodedField[instanceFieldsSet.size()];
            instanceFieldsArray = instanceFieldsSet.toArray(instanceFieldsArray);
        }
        TreeSet<EncodedMethod> directMethodSet = new TreeSet<EncodedMethod>();
        if (directMethods != null && directMethods.size() > 0) {
            for (EncodedMethod directMethod : directMethods) {
                if (directMethodSet.contains(directMethod)) {
                    System.err.println(String.format("Ignoring duplicate direct method definition: %s", directMethod.method.getMethodString()));
                    continue;
                }
                directMethodSet.add(directMethod);
            }
            directMethodsArray = new EncodedMethod[directMethodSet.size()];
            directMethodsArray = directMethodSet.toArray(directMethodsArray);
        }
        if (virtualMethods != null && virtualMethods.size() > 0) {
            TreeSet<EncodedMethod> virtualMethodSet = new TreeSet<EncodedMethod>();
            for (EncodedMethod virtualMethod : virtualMethods) {
                if (directMethodSet.contains(virtualMethod)) {
                    throw new RuntimeException(String.format("Duplicate direct+virtual method definition: %s", virtualMethod.method.getMethodString()));
                }
                if (virtualMethodSet.contains(virtualMethod)) {
                    System.err.println(String.format("Ignoring duplicate virtual method definition: %s", virtualMethod.method.getMethodString()));
                    continue;
                }
                virtualMethodSet.add(virtualMethod);
            }
            virtualMethodsArray = new EncodedMethod[virtualMethodSet.size()];
            virtualMethodsArray = virtualMethodSet.toArray(virtualMethodsArray);
        }
        ClassDataItem classDataItem = new ClassDataItem(dexFile, staticFieldsArray, instanceFieldsArray, directMethodsArray, virtualMethodsArray);
        return dexFile.ClassDataSection.intern(classDataItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        EncodedMethod previousEncodedMethod;
        int i;
        EncodedField previousEncodedField;
        int staticFieldsCount = in.readUnsignedLeb128();
        int instanceFieldsCount = in.readUnsignedLeb128();
        int directMethodsCount = in.readUnsignedLeb128();
        int virtualMethodsCount = in.readUnsignedLeb128();
        if (staticFieldsCount > 0) {
            this.staticFields = new EncodedField[staticFieldsCount];
            previousEncodedField = null;
            for (i = 0; i < staticFieldsCount; ++i) {
                try {
                    this.staticFields[i] = previousEncodedField = new EncodedField(this.dexFile, in, previousEncodedField);
                    continue;
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext(ex, "Error while reading static field at index " + i);
                }
            }
        }
        if (instanceFieldsCount > 0) {
            this.instanceFields = new EncodedField[instanceFieldsCount];
            previousEncodedField = null;
            for (i = 0; i < instanceFieldsCount; ++i) {
                try {
                    this.instanceFields[i] = previousEncodedField = new EncodedField(this.dexFile, in, previousEncodedField);
                    continue;
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext(ex, "Error while reading instance field at index " + i);
                }
            }
        }
        if (directMethodsCount > 0) {
            this.directMethods = new EncodedMethod[directMethodsCount];
            previousEncodedMethod = null;
            for (i = 0; i < directMethodsCount; ++i) {
                try {
                    this.directMethods[i] = previousEncodedMethod = new EncodedMethod(this.dexFile, readContext, in, previousEncodedMethod);
                    continue;
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext(ex, "Error while reading direct method at index " + i);
                }
            }
        }
        if (virtualMethodsCount > 0) {
            this.virtualMethods = new EncodedMethod[virtualMethodsCount];
            previousEncodedMethod = null;
            for (i = 0; i < virtualMethodsCount; ++i) {
                try {
                    this.virtualMethods[i] = previousEncodedMethod = new EncodedMethod(this.dexFile, readContext, in, previousEncodedMethod);
                    continue;
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext(ex, "Error while reading virtual method at index " + i);
                }
            }
        }
    }

    @Override
    protected int placeItem(int offset) {
        Comparable<EncodedField> previousEncodedMethod;
        Comparable<EncodedField> previousEncodedField;
        offset += Leb128Utils.unsignedLeb128Size(this.getStaticFieldCount());
        offset += Leb128Utils.unsignedLeb128Size(this.getInstanceFieldCount());
        offset += Leb128Utils.unsignedLeb128Size(this.getDirectMethodCount());
        offset += Leb128Utils.unsignedLeb128Size(this.getVirtualMethodCount());
        if (this.staticFields != null) {
            previousEncodedField = null;
            for (Comparable<EncodedField> comparable : this.staticFields) {
                offset = ((EncodedField)comparable).place(offset, (EncodedField)previousEncodedField);
                previousEncodedField = comparable;
            }
        }
        if (this.instanceFields != null) {
            previousEncodedField = null;
            for (Comparable<EncodedField> comparable : this.instanceFields) {
                offset = ((EncodedField)comparable).place(offset, (EncodedField)previousEncodedField);
                previousEncodedField = comparable;
            }
        }
        if (this.directMethods != null) {
            previousEncodedMethod = null;
            for (Comparable<EncodedField> comparable : this.directMethods) {
                offset = ((EncodedMethod)comparable).place(offset, (EncodedMethod)previousEncodedMethod);
                previousEncodedMethod = comparable;
            }
        }
        if (this.virtualMethods != null) {
            previousEncodedMethod = null;
            for (Comparable<EncodedField> comparable : this.virtualMethods) {
                offset = ((EncodedMethod)comparable).place(offset, (EncodedMethod)previousEncodedMethod);
                previousEncodedMethod = comparable;
            }
        }
        return offset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeItem(AnnotatedOutput out) {
        block16: {
            Comparable<EncodedField> previousEncodedMethod;
            Comparable<EncodedField> previousEncodedField;
            block15: {
                if (!out.annotates()) break block15;
                int staticFieldCount = this.getStaticFieldCount();
                out.annotate("static_fields_size: 0x" + Integer.toHexString(staticFieldCount) + " (" + staticFieldCount + ")");
                out.writeUnsignedLeb128(staticFieldCount);
                int instanceFieldCount = this.getInstanceFieldCount();
                out.annotate("instance_fields_size: 0x" + Integer.toHexString(instanceFieldCount) + " (" + instanceFieldCount + ")");
                out.writeUnsignedLeb128(instanceFieldCount);
                int directMethodCount = this.getDirectMethodCount();
                out.annotate("direct_methods_size: 0x" + Integer.toHexString(directMethodCount) + " (" + directMethodCount + ")");
                out.writeUnsignedLeb128(directMethodCount);
                int virtualMethodCount = this.getVirtualMethodCount();
                out.annotate("virtual_methods_size: 0x" + Integer.toHexString(virtualMethodCount) + " (" + virtualMethodCount + ")");
                out.writeUnsignedLeb128(virtualMethodCount);
                if (this.staticFields != null) {
                    boolean bl = false;
                    Comparable<EncodedField> previousEncodedField2 = null;
                    for (Comparable<EncodedField> comparable : this.staticFields) {
                        void var6_11;
                        out.annotate("[" + (int)(++var6_11) + "] static_field");
                        out.indent();
                        ((EncodedField)comparable).writeTo(out, (EncodedField)previousEncodedField2);
                        out.deindent();
                        previousEncodedField2 = comparable;
                    }
                }
                if (this.instanceFields != null) {
                    boolean bl = false;
                    Comparable<EncodedField> previousEncodedField2 = null;
                    for (Comparable<EncodedField> comparable : this.instanceFields) {
                        void var6_13;
                        out.annotate("[" + (int)(++var6_13) + "] instance_field");
                        out.indent();
                        ((EncodedField)comparable).writeTo(out, (EncodedField)previousEncodedField2);
                        out.deindent();
                        previousEncodedField2 = comparable;
                    }
                }
                if (this.directMethods != null) {
                    boolean bl = false;
                    Comparable<EncodedField> previousEncodedMethod2 = null;
                    for (Comparable<EncodedField> comparable : this.directMethods) {
                        void var6_15;
                        out.annotate("[" + (int)(++var6_15) + "] direct_method");
                        out.indent();
                        ((EncodedMethod)comparable).writeTo(out, (EncodedMethod)previousEncodedMethod2);
                        out.deindent();
                        previousEncodedMethod2 = comparable;
                    }
                }
                if (this.virtualMethods == null) break block16;
                boolean bl = false;
                Comparable<EncodedField> previousEncodedMethod2 = null;
                for (Comparable<EncodedField> comparable : this.virtualMethods) {
                    void var6_17;
                    out.annotate("[" + (int)(++var6_17) + "] virtual_method");
                    out.indent();
                    ((EncodedMethod)comparable).writeTo(out, (EncodedMethod)previousEncodedMethod2);
                    out.deindent();
                    previousEncodedMethod2 = comparable;
                }
                break block16;
            }
            out.writeUnsignedLeb128(this.getStaticFieldCount());
            out.writeUnsignedLeb128(this.getInstanceFieldCount());
            out.writeUnsignedLeb128(this.getDirectMethodCount());
            out.writeUnsignedLeb128(this.getVirtualMethodCount());
            if (this.staticFields != null) {
                previousEncodedField = null;
                for (Comparable<EncodedField> comparable : this.staticFields) {
                    ((EncodedField)comparable).writeTo(out, (EncodedField)previousEncodedField);
                    previousEncodedField = comparable;
                }
            }
            if (this.instanceFields != null) {
                previousEncodedField = null;
                for (Comparable<EncodedField> comparable : this.instanceFields) {
                    ((EncodedField)comparable).writeTo(out, (EncodedField)previousEncodedField);
                    previousEncodedField = comparable;
                }
            }
            if (this.directMethods != null) {
                previousEncodedMethod = null;
                for (Comparable<EncodedField> comparable : this.directMethods) {
                    ((EncodedMethod)comparable).writeTo(out, (EncodedMethod)previousEncodedMethod);
                    previousEncodedMethod = comparable;
                }
            }
            if (this.virtualMethods != null) {
                previousEncodedMethod = null;
                for (Comparable<EncodedField> comparable : this.virtualMethods) {
                    ((EncodedMethod)comparable).writeTo(out, (EncodedMethod)previousEncodedMethod);
                    previousEncodedMethod = comparable;
                }
            }
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_CLASS_DATA_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        TypeIdItem parentType = this.getParentType();
        if (parentType == null) {
            return "class_data_item @0x" + Integer.toHexString(this.getOffset());
        }
        return "class_data_item @0x" + Integer.toHexString(this.getOffset()) + " (" + parentType.getTypeDescriptor() + ")";
    }

    @Override
    public int compareTo(ClassDataItem other) {
        Preconditions.checkNotNull((Object)other);
        if (this.isEmpty()) {
            if (other.isEmpty()) {
                return 0;
            }
            return -1;
        }
        if (other.isEmpty()) {
            return 1;
        }
        TypeIdItem parentType = this.getParentType();
        TypeIdItem otherParentType = other.getParentType();
        if (parentType == null) {
            if (otherParentType == null) {
                return 0;
            }
            return -1;
        }
        if (otherParentType == null) {
            return 1;
        }
        return parentType.compareTo(otherParentType);
    }

    public int hashCode() {
        TypeIdItem parentType = this.getParentType();
        if (parentType != null) {
            return parentType.hashCode();
        }
        return 0;
    }

    @Nullable
    public TypeIdItem getParentType() {
        if (this.staticFields != null && this.staticFields.length > 0) {
            return this.staticFields[0].field.getContainingClass();
        }
        if (this.instanceFields != null && this.instanceFields.length > 0) {
            return this.instanceFields[0].field.getContainingClass();
        }
        if (this.directMethods != null && this.directMethods.length > 0) {
            return this.directMethods[0].method.getContainingClass();
        }
        if (this.virtualMethods != null && this.virtualMethods.length > 0) {
            return this.virtualMethods[0].method.getContainingClass();
        }
        return null;
    }

    @Nonnull
    public List<EncodedField> getStaticFields() {
        if (this.staticFields == null) {
            return Collections.emptyList();
        }
        return ReadOnlyArrayList.of(this.staticFields);
    }

    @Nonnull
    public List<EncodedField> getInstanceFields() {
        if (this.instanceFields == null) {
            return Collections.emptyList();
        }
        return ReadOnlyArrayList.of(this.instanceFields);
    }

    @Nonnull
    public List<EncodedMethod> getDirectMethods() {
        if (this.directMethods == null) {
            return Collections.emptyList();
        }
        return ReadOnlyArrayList.of(this.directMethods);
    }

    @Nonnull
    public List<EncodedMethod> getVirtualMethods() {
        if (this.virtualMethods == null) {
            return Collections.emptyList();
        }
        return ReadOnlyArrayList.of(this.virtualMethods);
    }

    public int getStaticFieldCount() {
        if (this.staticFields == null) {
            return 0;
        }
        return this.staticFields.length;
    }

    public int getInstanceFieldCount() {
        if (this.instanceFields == null) {
            return 0;
        }
        return this.instanceFields.length;
    }

    public int getDirectMethodCount() {
        if (this.directMethods == null) {
            return 0;
        }
        return this.directMethods.length;
    }

    public int getVirtualMethodCount() {
        if (this.virtualMethods == null) {
            return 0;
        }
        return this.virtualMethods.length;
    }

    public boolean isEmpty() {
        return this.getStaticFieldCount() + this.getInstanceFieldCount() + this.getDirectMethodCount() + this.getVirtualMethodCount() == 0;
    }

    public EncodedMethod findDirectMethodByMethodId(MethodIdItem methodIdItem) {
        return ClassDataItem.findMethodByMethodIdInternal(methodIdItem.index, this.directMethods);
    }

    public EncodedMethod findVirtualMethodByMethodId(MethodIdItem methodIdItem) {
        return ClassDataItem.findMethodByMethodIdInternal(methodIdItem.index, this.virtualMethods);
    }

    public EncodedMethod findMethodByMethodId(MethodIdItem methodIdItem) {
        EncodedMethod encodedMethod = ClassDataItem.findMethodByMethodIdInternal(methodIdItem.index, this.directMethods);
        if (encodedMethod != null) {
            return encodedMethod;
        }
        return ClassDataItem.findMethodByMethodIdInternal(methodIdItem.index, this.virtualMethods);
    }

    private static EncodedMethod findMethodByMethodIdInternal(int methodIdItemIndex, EncodedMethod[] encodedMethods) {
        if (encodedMethods == null) {
            return null;
        }
        int min = 0;
        int max = encodedMethods.length;
        while (min < max) {
            int index = min + max >> 1;
            EncodedMethod encodedMethod = encodedMethods[index];
            int encodedMethodIndex = encodedMethod.method.getIndex();
            if (encodedMethodIndex == methodIdItemIndex) {
                return encodedMethod;
            }
            if (encodedMethodIndex < methodIdItemIndex) {
                if (min == index) break;
                min = index;
                continue;
            }
            if (max == index) break;
            max = index;
        }
        return null;
    }

    public static class EncodedMethod
    implements Comparable<EncodedMethod> {
        public final MethodIdItem method;
        public final int accessFlags;
        public final CodeItem codeItem;

        public EncodedMethod(MethodIdItem method, int accessFlags, CodeItem codeItem) {
            this.method = method;
            this.accessFlags = accessFlags;
            this.codeItem = codeItem;
            if (codeItem != null) {
                codeItem.setParent(this);
            }
        }

        public EncodedMethod(DexFile dexFile, ReadContext readContext, Input in, EncodedMethod previousEncodedMethod) {
            int previousIndex = previousEncodedMethod == null ? 0 : previousEncodedMethod.method.getIndex();
            this.method = dexFile.MethodIdsSection.getItemByIndex(in.readUnsignedLeb128() + previousIndex);
            this.accessFlags = in.readUnsignedLeb128();
            if (dexFile.skipInstructions()) {
                in.readUnsignedLeb128();
                this.codeItem = null;
            } else {
                this.codeItem = (CodeItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_CODE_ITEM, in.readUnsignedLeb128());
            }
            if (this.codeItem != null) {
                this.codeItem.setParent(this);
            }
        }

        private void writeTo(AnnotatedOutput out, EncodedMethod previousEncodedMethod) {
            int previousIndex;
            int n = previousIndex = previousEncodedMethod == null ? 0 : previousEncodedMethod.method.getIndex();
            if (out.annotates()) {
                out.annotate("method: " + this.method.getMethodString());
                out.writeUnsignedLeb128(this.method.getIndex() - previousIndex);
                out.annotate("access_flags: " + AccessFlags.formatAccessFlagsForMethod(this.accessFlags));
                out.writeUnsignedLeb128(this.accessFlags);
                if (this.codeItem != null) {
                    out.annotate("code_off: 0x" + Integer.toHexString(this.codeItem.getOffset()));
                    out.writeUnsignedLeb128(this.codeItem.getOffset());
                } else {
                    out.annotate("code_off: 0x0");
                    out.writeUnsignedLeb128(0);
                }
            } else {
                out.writeUnsignedLeb128(this.method.getIndex() - previousIndex);
                out.writeUnsignedLeb128(this.accessFlags);
                out.writeUnsignedLeb128(this.codeItem == null ? 0 : this.codeItem.getOffset());
            }
        }

        private int place(int offset, EncodedMethod previousEncodedMethod) {
            int previousIndex = previousEncodedMethod == null ? 0 : previousEncodedMethod.method.getIndex();
            offset += Leb128Utils.unsignedLeb128Size(this.method.getIndex() - previousIndex);
            offset += Leb128Utils.unsignedLeb128Size(this.accessFlags);
            return offset += this.codeItem == null ? 1 : Leb128Utils.unsignedLeb128Size(this.codeItem.getOffset());
        }

        @Override
        public int compareTo(EncodedMethod other) {
            return this.method.compareTo(other.method);
        }

        public boolean equals(Object other) {
            if (other instanceof EncodedMethod) {
                return this.compareTo((EncodedMethod)other) == 0;
            }
            return false;
        }

        public boolean isDirect() {
            return (this.accessFlags & (AccessFlags.STATIC.getValue() | AccessFlags.PRIVATE.getValue() | AccessFlags.CONSTRUCTOR.getValue())) != 0;
        }
    }

    public static class EncodedField
    implements Comparable<EncodedField> {
        public final FieldIdItem field;
        public final int accessFlags;

        public EncodedField(FieldIdItem field, int accessFlags) {
            this.field = field;
            this.accessFlags = accessFlags;
        }

        private EncodedField(DexFile dexFile, Input in, @Nullable EncodedField previousEncodedField) {
            int previousIndex = previousEncodedField == null ? 0 : previousEncodedField.field.getIndex();
            this.field = dexFile.FieldIdsSection.getItemByIndex(in.readUnsignedLeb128() + previousIndex);
            this.accessFlags = in.readUnsignedLeb128();
        }

        private void writeTo(AnnotatedOutput out, EncodedField previousEncodedField) {
            int previousIndex;
            int n = previousIndex = previousEncodedField == null ? 0 : previousEncodedField.field.getIndex();
            if (out.annotates()) {
                out.annotate("field: " + this.field.getFieldString());
                out.writeUnsignedLeb128(this.field.getIndex() - previousIndex);
                out.annotate("access_flags: " + AccessFlags.formatAccessFlagsForField(this.accessFlags));
                out.writeUnsignedLeb128(this.accessFlags);
            } else {
                out.writeUnsignedLeb128(this.field.getIndex() - previousIndex);
                out.writeUnsignedLeb128(this.accessFlags);
            }
        }

        private int place(int offset, EncodedField previousEncodedField) {
            int previousIndex = previousEncodedField == null ? 0 : previousEncodedField.field.getIndex();
            offset += Leb128Utils.unsignedLeb128Size(this.field.getIndex() - previousIndex);
            return offset += Leb128Utils.unsignedLeb128Size(this.accessFlags);
        }

        @Override
        public int compareTo(EncodedField other) {
            return this.field.compareTo(other.field);
        }

        public boolean equals(Object other) {
            if (other instanceof EncodedField) {
                return this.compareTo((EncodedField)other) == 0;
            }
            return false;
        }

        public boolean isStatic() {
            return (this.accessFlags & AccessFlags.STATIC.getValue()) != 0;
        }
    }
}

