/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.TreeMap;

public enum ItemType {
    TYPE_HEADER_ITEM(0, 17, 4, "header_item"),
    TYPE_STRING_ID_ITEM(1, 0, 4, "string_id_item"),
    TYPE_TYPE_ID_ITEM(2, 1, 4, "type_id_item"),
    TYPE_PROTO_ID_ITEM(3, 2, 4, "proto_id_item"),
    TYPE_FIELD_ID_ITEM(4, 3, 4, "field_id_item"),
    TYPE_METHOD_ID_ITEM(5, 4, 4, "method_id_item"),
    TYPE_CLASS_DEF_ITEM(6, 5, 4, "class_def_item"),
    TYPE_MAP_LIST(4096, 16, 4, "map_list"),
    TYPE_TYPE_LIST(4097, 6, 4, "type_list"),
    TYPE_ANNOTATION_SET_REF_LIST(4098, 7, 4, "annotation_set_ref_list"),
    TYPE_ANNOTATION_SET_ITEM(4099, 8, 4, "annotation_set_item"),
    TYPE_CLASS_DATA_ITEM(8192, 9, 1, "class_data_item"),
    TYPE_CODE_ITEM(8193, 10, 4, "code_item"),
    TYPE_STRING_DATA_ITEM(8194, 11, 1, "string_data_item"),
    TYPE_DEBUG_INFO_ITEM(8195, 12, 1, "debug_info_item"),
    TYPE_ANNOTATION_ITEM(8196, 13, 1, "annotation_item"),
    TYPE_ENCODED_ARRAY_ITEM(8197, 14, 1, "encoded_array_item"),
    TYPE_ANNOTATIONS_DIRECTORY_ITEM(8198, 15, 4, "annotations_directory_item");

    private static final TreeMap<Integer, ItemType> itemTypeIntegerMap;
    public final int MapValue;
    public final String TypeName;
    public final int SectionIndex;
    public final int ItemAlignment;

    private ItemType(int mapValue, int sectionIndex, int itemAlignment, String typeName) {
        this.MapValue = mapValue;
        this.SectionIndex = sectionIndex;
        this.ItemAlignment = itemAlignment;
        this.TypeName = typeName;
    }

    public static ItemType fromInt(int itemType) {
        return itemTypeIntegerMap.get(itemType);
    }

    public boolean isIndexedItem() {
        return this.MapValue <= 4096;
    }

    static {
        itemTypeIntegerMap = new TreeMap();
        for (ItemType itemType : ItemType.values()) {
            itemTypeIntegerMap.put(itemType.MapValue, itemType);
        }
    }
}

