/*
 * Decompiled with CFR 0.152.
 */
package generic.util;

import ghidra.util.HTMLUtilities;
import ghidra.util.SystemUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class FileLocker {
    private static final String META_TAG = "<META> ";
    private static final String LOCK_TYPE_KEY = "<META> Supports File Channel Locking";
    private static final String FILE_LOCK_TYPE = "File Lock";
    private static final String[] PROPERTY_KEYS = new String[]{"Username", "Hostname", "Timestamp", "OS Name", "OS Architecture", "OS Version"};
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    protected final File lockFile;
    protected final Properties existingLockProperties;
    protected Properties createdLockProperties;
    protected final String existingLockType;
    protected boolean isLocked;

    protected FileLocker(File lockFile) {
        this.lockFile = lockFile;
        this.existingLockProperties = this.loadExistingLockFile();
        this.existingLockType = this.existingLockProperties != null ? this.existingLockProperties.getProperty(LOCK_TYPE_KEY) : null;
    }

    public boolean lock() {
        if (this.existingLockProperties == null) {
            return this.createLockFile();
        }
        return false;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void release() {
        if (this.isLockOwner()) {
            this.lockFile.delete();
        }
        this.isLocked = false;
    }

    public boolean canForceLock() {
        return FILE_LOCK_TYPE.equals(this.existingLockType);
    }

    public boolean forceLock() {
        if (this.canForceLock()) {
            return this.createLockFile();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadExistingLockFile() {
        if (!this.lockFile.exists()) {
            return null;
        }
        Properties properties = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.lockFile);
            properties.load(is);
            Properties properties2 = properties;
            return properties2;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public String getExistingLockFileInformation() {
        if (this.existingLockProperties == null) {
            return "no properties in lock file";
        }
        StringBuilder buf = new StringBuilder("<p><table border=0>");
        for (String name : PROPERTY_KEYS) {
            buf.append("<tr><td>");
            buf.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            buf.append(HTMLUtilities.escapeHTML(name));
            buf.append(": ");
            buf.append("</td><td>");
            buf.append(HTMLUtilities.escapeHTML(this.existingLockProperties.get(name).toString()));
            buf.append("</td></tr>");
        }
        buf.append("</table>");
        return buf.toString();
    }

    protected String getLockType() {
        return FILE_LOCK_TYPE;
    }

    protected boolean createLockFile() {
        Properties properties = new Properties();
        properties.put("Username", System.getProperty("user.name"));
        String hostname = "<Unknown>";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        properties.put("Hostname", hostname);
        properties.put("Timestamp", DATE_FORMAT.format(new Date()));
        properties.put("OS Name", System.getProperty("os.name"));
        properties.put("OS Architecture", System.getProperty("os.arch"));
        properties.put("OS Version", System.getProperty("os.version"));
        properties.put(LOCK_TYPE_KEY, this.getLockType());
        if (!this.storeProperties(properties)) {
            return false;
        }
        if (this.lockFile.exists()) {
            this.createdLockProperties = properties;
            this.isLocked = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeProperties(Properties properties) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.lockFile);
            properties.store(os, "Ghidra Lock File");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean isLockOwner() {
        if (this.createdLockProperties == null) {
            return false;
        }
        Properties currentLockProperties = this.loadExistingLockFile();
        if (currentLockProperties == null) {
            return false;
        }
        for (String key : PROPERTY_KEYS) {
            String currentProperty;
            String originalProperty = this.createdLockProperties.getProperty(key);
            if (SystemUtilities.isEqual((Object)originalProperty, (Object)(currentProperty = currentLockProperties.getProperty(key)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.lockFile;
    }
}

