/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.prop;

import ghidra.util.Msg;
import ghidra.util.ObjectStorageStreamAdapter;
import ghidra.util.Saveable;
import ghidra.util.prop.PropertyPage;
import ghidra.util.prop.PropertySet;
import ghidra.util.prop.PropertyVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SaveableObjectPropertySet
extends PropertySet {
    private static final long serialVersionUID = 1L;

    public SaveableObjectPropertySet(String name, Class<?> objectClass) {
        super(name, objectClass);
        if (!Saveable.class.isAssignableFrom(objectClass)) {
            throw new IllegalArgumentException("Class " + objectClass + "does not implement the Saveable interface");
        }
        try {
            objectClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class " + objectClass + "must be public and have a public, no args, constructor");
        }
    }

    @Override
    public int getDataSize() {
        return 20;
    }

    public void putObject(long index, Saveable value) {
        PropertyPage page = this.getOrCreatePage(this.getPageID(index));
        int n = page.getSize();
        page.addSaveableObject(this.getPageOffset(index), value);
        this.numProperties += page.getSize() - n;
    }

    public Saveable getObject(long index) {
        PropertyPage page = this.getPage(this.getPageID(index));
        if (page != null) {
            return page.getSaveableObject(this.getPageOffset(index));
        }
        return null;
    }

    @Override
    protected void moveIndex(long from, long to) {
        Saveable value = this.getObject(from);
        this.remove(from);
        this.putObject(to, value);
    }

    @Override
    protected void saveProperty(ObjectOutputStream oos, long index) throws IOException {
        Saveable obj = this.getObject(index);
        oos.writeObject(obj.getClass().getName());
        obj.save(new ObjectStorageStreamAdapter(oos));
    }

    @Override
    protected void restoreProperty(ObjectInputStream ois, long index) throws IOException, ClassNotFoundException {
        try {
            String className = (String)ois.readObject();
            Class<?> c = Class.forName(className);
            Saveable obj = (Saveable)c.newInstance();
            obj.restore(new ObjectStorageStreamAdapter(ois));
            this.putObject(index, obj);
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, null, null, (Throwable)e);
        }
    }

    @Override
    public void applyValue(PropertyVisitor visitor, long addr) {
        Saveable obj = this.getObject(addr);
        if (obj != null) {
            visitor.visit(obj);
        }
    }
}

