/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class InvokeInSwingTask
extends Task {
    private final Runnable runnable;

    public InvokeInSwingTask(String title, Runnable runnable) {
        super(title, false, false, true);
        this.runnable = runnable;
    }

    @Override
    public void run(TaskMonitor monitor) {
        try {
            SwingUtilities.invokeAndWait(this.runnable);
        }
        catch (InterruptedException e) {
            Msg.showError((Object)this.runnable, null, (String)"Task Error", (Object)("Task interrupted: " + this.getTaskTitle()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Msg.showError((Object)this.runnable, null, (String)"Task Error", (Object)("Unexpected task exception: " + this.getTaskTitle()), (Throwable)e);
        }
    }
}

