/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.xml;

import ghidra.util.xml.XmlAttributeException;
import ghidra.util.xml.XmlUtilities;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import org.xml.sax.Attributes;

public class XmlParserElement {
    private HashMap<String, Object> attrsMap = new HashMap();
    private boolean isStart;
    private String name;
    private StringBuffer text;
    private int lineNum;

    XmlParserElement(String name, StringBuffer text, int lineNum) {
        this.isStart = false;
        this.name = name.toUpperCase();
        this.text = text;
        this.lineNum = lineNum;
    }

    XmlParserElement(String name, Attributes attrs, int lineNum) {
        this.isStart = true;
        this.name = name.toUpperCase();
        int count = attrs.getLength();
        for (int i = 0; i < count; ++i) {
            this.attrsMap.put(attrs.getQName(i), attrs.getValue(i));
        }
        this.lineNum = lineNum;
    }

    public boolean equals(Object obj) {
        boolean textEquals;
        XmlParserElement that = (XmlParserElement)obj;
        if (this.isStart != that.isStart) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        boolean bl = textEquals = this.text == null && that.text == null || this.text != null && this.text.equals(that.text);
        if (!textEquals) {
            return false;
        }
        for (String lname : this.attrsMap.keySet()) {
            Object thisValue = this.attrsMap.get(lname);
            Object thatValue = that.attrsMap.get(lname);
            if (thisValue == null && thatValue != null) {
                return false;
            }
            if (thisValue != null && thatValue == null) {
                return false;
            }
            if (thisValue == null || thisValue.equals(thatValue)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.name);
        Object[] attrNames = this.getAttrNames();
        Arrays.sort(attrNames);
        for (int i = 0; i < attrNames.length; ++i) {
            if (i == 0) {
                buffer.append(" ");
            }
            buffer.append((String)attrNames[i]);
            buffer.append("=\"");
            buffer.append(this.getAttrValue((String)attrNames[i]));
            buffer.append("\"");
            if (i >= attrNames.length - 1) continue;
            buffer.append(" ");
        }
        buffer.append(this.isStart ? " ->START" : " ->END");
        return buffer.toString();
    }

    public boolean isStart() {
        return this.isStart;
    }

    public boolean isEnd() {
        return !this.isStart;
    }

    public String getName() {
        return this.name;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public String getText() {
        return this.text == null ? "" : this.text.toString();
    }

    StringBuffer getTextBuffer() {
        return this.text;
    }

    public String getAttrValue(String attrName) {
        return (String)this.attrsMap.get(attrName);
    }

    public boolean getAttrValueAsBool(String attrName) {
        String val = this.getAttrValue(attrName);
        if (val == null) {
            throw new XmlAttributeException("Element: " + this.name + ": attribute " + attrName + " does not exist.");
        }
        try {
            return XmlUtilities.parseBoolean(val);
        }
        catch (XmlAttributeException e) {
            throw new XmlAttributeException("Element: " + this.name + ": attribute " + attrName + " is not a valid boolean (y|n): " + this.getAttrValue(attrName));
        }
    }

    public int getAttrValueAsInt(String attrName) {
        try {
            String intStr = this.getAttrValue(attrName);
            return XmlUtilities.parseInt(intStr);
        }
        catch (NullPointerException e) {
            throw new XmlAttributeException("Element: " + this.name + ": attribute " + attrName + " does not exist.");
        }
        catch (NumberFormatException e) {
            throw new XmlAttributeException("Element: " + this.name + ": attribute " + attrName + " is not a valid integer: " + this.getAttrValue(attrName));
        }
    }

    public long getAttrValueAsLong(String attrName) {
        try {
            String longStr = this.getAttrValue(attrName);
            boolean isNegative = longStr.startsWith("-");
            if (isNegative) {
                longStr = longStr.substring(1);
            }
            int radix = 10;
            if (longStr.startsWith("0x")) {
                longStr = longStr.substring(2);
                radix = 16;
            }
            long longVal = new BigInteger(longStr, radix).longValue();
            if (isNegative) {
                longVal *= -1L;
            }
            return longVal;
        }
        catch (NullPointerException e) {
            throw new XmlAttributeException("Element: " + this.name + ": attribute " + attrName + " does not exist.");
        }
        catch (NumberFormatException e) {
            throw new XmlAttributeException("Element: " + this.name + ": attribute " + attrName + " is not a valid long: " + this.getAttrValue(attrName));
        }
    }

    public double getAttrValueAsDouble(String attrName) {
        try {
            return Double.parseDouble(this.getAttrValue(attrName));
        }
        catch (NullPointerException e) {
            throw new XmlAttributeException("Element: " + this.name + ": attribute " + attrName + " does not exist.");
        }
        catch (NumberFormatException e) {
            throw new XmlAttributeException("Element: " + this.name + ": attribute " + attrName + " is not a valid double: " + this.getAttrValue(attrName));
        }
    }

    public String[] getAttrNames() {
        if (this.attrsMap == null) {
            return new String[0];
        }
        String[] names = new String[this.attrsMap.size()];
        this.attrsMap.keySet().toArray(names);
        return names;
    }

    public boolean hasAttr(String attrName) {
        return this.attrsMap.containsKey(attrName);
    }

    public void setAttribute(String name, String value) {
        this.attrsMap.put(name, value);
    }
}

