/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.program;

import generic.DominantPair;
import generic.lsh.KandL;
import generic.lsh.LSHMemoryModel;
import generic.lsh.vector.LSHCosineVectorAccum;
import generic.lsh.vector.LSHVector;
import generic.lsh.vector.VectorCompare;
import ghidra.feature.vt.api.correlator.program.LSHMultiHash;
import ghidra.feature.vt.api.correlator.program.SimilarSymbolNameProgramCorrelatorFactory;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMatchInfo;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTScore;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelator;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimilarSymbolNameProgramCorrelator
extends VTAbstractProgramCorrelator {
    public static double SIMILARITY_THRESHOLD = 0.5;
    HashMap<Symbol, LSHCosineVectorAccum> sourceMap;
    HashMap<Symbol, LSHCosineVectorAccum> destinationMap;
    HashMap<String, Integer> idMap;
    int featureID = 0;
    int minNameLength;

    protected SimilarSymbolNameProgramCorrelator(ServiceProvider serviceProvider, Program sourceProgram, AddressSetView sourceAddressSet, Program destinationProgram, AddressSetView destinationAddressSet, ToolOptions options) {
        super(serviceProvider, sourceProgram, sourceAddressSet, destinationProgram, destinationAddressSet, options);
    }

    @Override
    protected void doCorrelate(VTMatchSet matchSet, TaskMonitor monitor) throws CancelledException {
        this.minNameLength = this.getOptions().getInt("Minimum name length", 6);
        monitor.setMessage("Generating source dictionary");
        LSHMultiHash<Symbol> sourceDictionary = this.generateDictionary(this.getSourceProgram(), matchSet, monitor);
        monitor.setMessage("Finding destination symbols");
        this.findDestinations(matchSet, sourceDictionary, SIMILARITY_THRESHOLD, monitor);
    }

    private void extractNGramFeatures(VTMatchSet matchSet, TaskMonitor monitor, int n) {
        this.sourceMap = new HashMap();
        this.destinationMap = new HashMap();
        this.idMap = new HashMap();
        Program sourceProgram = this.getSourceProgram();
        Program destinationProgram = this.getDestinationProgram();
        SymbolTable sourceSymbolTable = sourceProgram.getSymbolTable();
        SymbolTable destinationSymbolTable = destinationProgram.getSymbolTable();
        SymbolIterator sourceSymbols = sourceSymbolTable.getAllSymbols(false);
        SymbolIterator destinationSymbols = destinationSymbolTable.getAllSymbols(false);
        this.addSymbolsToMap(sourceSymbols, true, n, monitor);
        this.addSymbolsToMap(destinationSymbols, false, n, monitor);
    }

    private void addSymbolsToMap(SymbolIterator symbolIt, boolean isSourceProgram, int n, TaskMonitor monitor) {
        double weight = 1.0 / (double)n;
        AddressSetView addressSet = isSourceProgram ? this.getSourceAddressSet() : this.getDestinationAddressSet();
        while (symbolIt.hasNext() && !monitor.isCancelled()) {
            Symbol symbol = symbolIt.next();
            String symbolName = symbol.getName();
            if (symbolName.length() < this.minNameLength || !addressSet.contains(symbol.getAddress()) || symbol.getSource() == SourceType.DEFAULT || symbol.getSource() == SourceType.ANALYSIS) continue;
            for (int i = 0; i < symbolName.length() - (n - 1); ++i) {
                String threeGram = symbolName.substring(i, i + n);
                LSHCosineVectorAccum vector = isSourceProgram ? this.sourceMap.get(symbol) : this.destinationMap.get(symbol);
                if (vector == null) {
                    vector = new LSHCosineVectorAccum();
                    if (isSourceProgram) {
                        this.sourceMap.put(symbol, vector);
                    } else {
                        this.destinationMap.put(symbol, vector);
                    }
                }
                int id = this.getFeatureID(threeGram);
                vector.addHash(id, weight);
            }
        }
    }

    private int getFeatureID(String threeGram) {
        if (this.idMap.containsKey(threeGram)) {
            return this.idMap.get(threeGram);
        }
        ++this.featureID;
        this.idMap.put(threeGram, this.featureID);
        return this.featureID;
    }

    private LSHMultiHash<Symbol> generateDictionary(Program program, VTMatchSet matchSet, TaskMonitor monitor) {
        LSHMultiHash<Symbol> dictionary = this.generateLSHMultiHash();
        this.extractNGramFeatures(matchSet, monitor, 3);
        dictionary.add(this.sourceMap, monitor);
        return dictionary;
    }

    private void findDestinations(VTMatchSet matchSet, LSHMultiHash<Symbol> sourceDictionary, double threshold, TaskMonitor monitor) {
        monitor.initialize((long)this.destinationMap.size());
        for (Map.Entry<Symbol, LSHCosineVectorAccum> entry : this.destinationMap.entrySet()) {
            if (monitor.isCancelled()) {
                return;
            }
            monitor.incrementProgress(1L);
            Symbol destinationSymbol = entry.getKey();
            LSHCosineVectorAccum vector = entry.getValue();
            Set<DominantPair<Symbol, LSHCosineVectorAccum>> neighbors = sourceDictionary.lookup(vector);
            List<VTMatchInfo> members = this.transform(matchSet, destinationSymbol, vector, neighbors, threshold, monitor);
            for (VTMatchInfo member : members) {
                if (monitor.isCancelled()) {
                    return;
                }
                if (member == null) continue;
                matchSet.addMatch(member);
            }
        }
    }

    private List<VTMatchInfo> transform(VTMatchSet matchSet, Symbol destinationSymbol, LSHCosineVectorAccum destinationVector, Set<DominantPair<Symbol, LSHCosineVectorAccum>> neighbors, double threshold, TaskMonitor monitor) {
        ArrayList<VTMatchInfo> result = new ArrayList<VTMatchInfo>();
        int sourceLength = 0;
        int destinationLength = 0;
        Address destinationAddress = destinationSymbol.getAddress();
        FunctionManager destinationFunctionManager = this.getDestinationProgram().getFunctionManager();
        Function destinationFunction = destinationFunctionManager.getFunctionAt(destinationAddress);
        CodeUnit destinationCodeUnit = null;
        VectorCompare veccompare = new VectorCompare();
        if (destinationFunction == null && (destinationCodeUnit = this.getDestinationProgram().getListing().getCodeUnitAt(destinationAddress)) == null) {
            return result;
        }
        if (destinationFunction != null && destinationFunction.isThunk()) {
            return result;
        }
        for (DominantPair<Symbol, LSHCosineVectorAccum> neighbor : neighbors) {
            LSHCosineVectorAccum sourceVector;
            double similarity;
            VTAssociationType type;
            if (monitor.isCancelled()) break;
            Symbol sourceSymbol = (Symbol)neighbor.first;
            Address sourceAddress = sourceSymbol.getAddress();
            FunctionManager sourceFunctionManager = this.getSourceProgram().getFunctionManager();
            Function sourceFunction = sourceFunctionManager.getFunctionAt(sourceAddress);
            if (destinationFunction != null) {
                if (sourceFunction == null || sourceFunction.isThunk()) continue;
                type = VTAssociationType.FUNCTION;
                sourceLength = (int)sourceFunction.getBody().getNumAddresses();
                destinationLength = (int)destinationFunction.getBody().getNumAddresses();
            } else {
                CodeUnit sourceCodeUnit;
                if (sourceFunction != null || (sourceCodeUnit = this.getSourceProgram().getListing().getCodeUnitAt(sourceAddress)) == null) continue;
                type = VTAssociationType.DATA;
                sourceLength = sourceCodeUnit.getLength();
                destinationLength = destinationCodeUnit.getLength();
            }
            if ((similarity = (sourceVector = (LSHCosineVectorAccum)neighbor.second).compare((LSHVector)destinationVector, veccompare)) < threshold || Double.isNaN(similarity)) continue;
            double confidence = similarity * sourceVector.getLength() * destinationVector.getLength();
            VTMatchInfo match = new VTMatchInfo(matchSet);
            match.setSimilarityScore(new VTScore(similarity));
            match.setConfidenceScore(new VTScore(confidence *= 10.0));
            match.setSourceLength(sourceLength);
            match.setDestinationLength(destinationLength);
            match.setSourceAddress(sourceAddress);
            match.setDestinationAddress(destinationAddress);
            match.setTag(null);
            match.setAssociationType(type);
            result.add(match);
        }
        return result;
    }

    private LSHMultiHash<Symbol> generateLSHMultiHash() {
        LSHMemoryModel model = (LSHMemoryModel)this.getOptions().getEnum("Memory model", (Enum)SimilarSymbolNameProgramCorrelatorFactory.MEMORY_MODEL_DEFAULT);
        int L = KandL.memoryModelToL((LSHMemoryModel)model);
        return new LSHMultiHash<Symbol>(model.getK(), L);
    }

    @Override
    public String getName() {
        return "Similar Symbol Name Match";
    }
}

