/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.stringable;

import ghidra.feature.vt.api.util.Stringable;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.feature.vt.gui.util.VTOptionDefines;
import ghidra.framework.options.ToolOptions;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.FunctionUtility;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class FunctionSignatureStringable
extends Stringable {
    private static final String EMPTY_STRING = "";
    private static final String MAKE_POINTER_PREFIX = "*";
    public static final String SHORT_NAME = "FUNCTION_SIG";
    private static String PARAMETER_STORAGE_DELIMITER = ";";
    private static final String PARAMETER_INFO_DELIMITER = "\n";
    private String signatureString;
    private String originalName;
    private SourceType signatureSource;
    private String callingConventionName;
    private boolean isInline = false;
    private boolean hasNoReturn = false;
    private boolean hasVarargs = false;
    private String callFixup;
    private boolean hasCustomStorage = false;
    private ParameterInfo returnInfo;
    private List<ParameterInfo> parameterInfos = new ArrayList<ParameterInfo>();
    private boolean isThisCall = false;
    private Program program;

    public FunctionSignatureStringable() {
        super(SHORT_NAME);
    }

    public FunctionSignatureStringable(Function function) {
        super(SHORT_NAME);
        this.program = function.getProgram();
        this.originalName = function.getName();
        this.isInline = function.isInline();
        this.hasNoReturn = function.hasNoReturn();
        this.hasVarargs = function.hasVarArgs();
        this.callingConventionName = function.getCallingConventionName();
        this.callFixup = function.getCallFixup();
        this.signatureSource = function.getSignatureSource();
        this.hasCustomStorage = function.hasCustomVariableStorage();
        GenericCallingConvention guessedCallingConvention = GenericCallingConvention.guessFromName((String)function.getCallingConventionName());
        this.isThisCall = guessedCallingConvention == GenericCallingConvention.thiscall;
        this.returnInfo = this.getParameterInfo(function.getReturn(), SourceType.DEFAULT);
        for (Parameter parameter : function.getParameters()) {
            this.parameterInfos.add(this.getParameterInfo(parameter, parameter.getSource()));
        }
        this.callFixup = function.getCallFixup();
    }

    private ParameterInfo getParameterInfo(Parameter parameter, SourceType source) {
        String name = parameter.getName();
        String comment = parameter.getComment();
        DataType dt = parameter.getDataType();
        String paramStorage = parameter.getVariableStorage().getSerializationString();
        return new ParameterInfo(dt, name, paramStorage, source, comment);
    }

    public boolean hasCustomStorage() {
        return this.hasCustomStorage;
    }

    public boolean hasVarArgs() {
        return this.hasVarargs;
    }

    private String getSignatureDisplayString() {
        if (this.signatureString != null) {
            return this.signatureString;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.returnInfo.dataType.getDisplayName());
        buf.append(" ");
        if (this.isInline) {
            buf.append("inline ");
        }
        if (this.hasNoReturn) {
            buf.append("noreturn ");
        }
        if (this.callingConventionName != null && !this.callingConventionName.equals("default") && !this.callingConventionName.equals("unknown")) {
            buf.append(this.callingConventionName);
            buf.append(" ");
        }
        buf.append(this.originalName);
        buf.append("(");
        int paramCnt = this.parameterInfos.size();
        boolean emptyList = true;
        for (int i = 0; i < paramCnt; ++i) {
            ParameterInfo paramInfo = this.parameterInfos.get(i);
            buf.append(paramInfo.dataType.getDisplayName());
            buf.append(" ");
            buf.append(paramInfo.name);
            emptyList = false;
            if (i >= paramCnt - 1 && !this.hasVarargs) continue;
            buf.append(", ");
        }
        if (this.hasVarargs) {
            buf.append("...");
        } else if (emptyList && this.signatureSource != SourceType.DEFAULT) {
            buf.append("void");
        }
        buf.append(")");
        this.signatureString = buf.toString();
        return this.signatureString;
    }

    @Override
    public String getDisplayString() {
        if (this.returnInfo == null) {
            return "undefined FUNCTION_SIG()";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.getSignatureDisplayString());
        if (this.hasCustomStorage && this.program != null) {
            try {
                buf.append("  CustomStorage: ");
                VariableStorage returnVariableStorage = VariableStorage.deserialize((Program)this.program, (String)this.returnInfo.storage);
                buf.append(returnVariableStorage.toString() + " ");
                buf.append("(");
                int numParams = this.parameterInfos.size();
                for (int i = 0; i < numParams; ++i) {
                    String parameterStorageString = this.parameterInfos.get((int)i).storage;
                    VariableStorage variableStorage = VariableStorage.deserialize((Program)this.program, (String)parameterStorageString);
                    buf.append(variableStorage.toString());
                    if (i >= numParams - 1 && !this.hasVarargs) continue;
                    buf.append(", ");
                }
                if (this.hasVarargs) {
                    buf.append("...");
                }
                buf.append(")");
            }
            catch (InvalidInputException e) {
                buf.append("Error getting variable storage.");
                e.printStackTrace();
            }
        }
        if (this.callFixup != null) {
            buf.append(" " + this.callFixup);
        }
        return buf.toString();
    }

    @Override
    protected String doConvertToString(Program desiredProgram) {
        if (this.returnInfo == null) {
            return EMPTY_STRING;
        }
        DataTypeManager dataTypeManager = desiredProgram.getDataTypeManager();
        StringBuilder buildy = new StringBuilder();
        buildy.append(this.getSavableFunctionSignatureSource()).append("\t");
        buildy.append(this.getSavableIsInline()).append("\t");
        buildy.append(this.getSavableHasNoReturn()).append("\t");
        buildy.append(this.getSavableCallingConvention()).append("\t");
        buildy.append(this.getSavableCallFixup()).append("\t");
        buildy.append(this.originalName).append("\t");
        buildy.append(this.getSavableHasCustomStorage()).append("\t");
        buildy.append(this.getSavableReturnType(dataTypeManager)).append("\t");
        buildy.append(this.getSavableReturnStorage()).append("\t");
        buildy.append(this.getSavableParameterStorage()).append("\t");
        buildy.append(this.getSavableVarArgs()).append("\t");
        buildy.append(Boolean.toString(this.isThisCall)).append("\t");
        buildy.append(this.saveParameterInfos());
        return buildy.toString();
    }

    private String getSavableReturnType(DataTypeManager dataTypeManager) {
        DataType dt = this.returnInfo.dataType;
        boolean makePointer = false;
        if (dt instanceof Pointer) {
            makePointer = true;
            dt = ((Pointer)dt).getDataType();
        }
        Object str = Long.toString(dataTypeManager.getResolvedID(dt));
        if (makePointer) {
            str = MAKE_POINTER_PREFIX + (String)str;
        }
        return str;
    }

    private String getSavableFunctionSignatureSource() {
        return this.signatureSource.name();
    }

    private String getSavableIsInline() {
        return Boolean.toString(this.isInline);
    }

    private String getSavableHasNoReturn() {
        return Boolean.toString(this.hasNoReturn);
    }

    private String getSavableCallingConvention() {
        return this.callingConventionName;
    }

    private String getSavableCallFixup() {
        if (this.callFixup == null) {
            return "none";
        }
        return this.callFixup;
    }

    private String getSavableHasCustomStorage() {
        return Boolean.toString(this.hasCustomStorage);
    }

    private String getSavableReturnStorage() {
        return this.returnInfo.storage;
    }

    private String getSavableParameterStorage() {
        StringBuilder storageBuilder = new StringBuilder();
        storageBuilder.append(this.parameterInfos.size()).append(PARAMETER_STORAGE_DELIMITER);
        for (ParameterInfo paramInfo : this.parameterInfos) {
            storageBuilder.append(paramInfo.storage).append(PARAMETER_STORAGE_DELIMITER);
        }
        return storageBuilder.toString();
    }

    private String getSavableVarArgs() {
        return Boolean.toString(this.hasVarargs);
    }

    @Override
    protected void doRestoreFromString(String string, Program desiredProgram) {
        this.signatureString = null;
        StringTokenizer tokenizer = new StringTokenizer(string, "\t");
        LinkedList<String> strings = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            strings.add(tokenizer.nextToken());
        }
        this.program = desiredProgram;
        DataTypeManager dataTypeManager = desiredProgram.getDataTypeManager();
        this.signatureSource = SourceType.valueOf((String)((String)strings.remove(0)));
        this.isInline = Boolean.parseBoolean((String)strings.remove(0));
        this.hasNoReturn = Boolean.parseBoolean((String)strings.remove(0));
        this.callingConventionName = (String)strings.remove(0);
        this.callFixup = (String)strings.remove(0);
        if (this.callFixup.equals("none")) {
            this.callFixup = null;
        }
        this.originalName = (String)strings.remove(0);
        this.hasCustomStorage = Boolean.parseBoolean((String)strings.remove(0));
        String returnTypeID = (String)strings.remove(0);
        String returnStorage = (String)strings.remove(0);
        this.returnInfo = new ParameterInfo(returnTypeID, dataTypeManager, "<RETURN>", returnStorage, SourceType.DEFAULT, null);
        String parameterStorageString = (String)strings.remove(0);
        StringTokenizer parameterTokenizer = new StringTokenizer(parameterStorageString, PARAMETER_STORAGE_DELIMITER);
        LinkedList<String> parameterStorage = new LinkedList<String>();
        while (parameterTokenizer.hasMoreTokens()) {
            parameterStorage.add(parameterTokenizer.nextToken());
        }
        this.hasVarargs = Boolean.parseBoolean((String)strings.remove(0));
        this.isThisCall = Boolean.parseBoolean((String)strings.remove(0));
        while (!strings.isEmpty()) {
            String parameterInfoString = (String)strings.remove(0);
            StringTokenizer parameterInfoTokenizer = new StringTokenizer(parameterInfoString, PARAMETER_INFO_DELIMITER);
            String dtIDString = parameterInfoTokenizer.nextToken();
            String name = parameterInfoTokenizer.nextToken();
            if (name != null && name.isEmpty()) {
                name = null;
            }
            String sourceAsName = parameterInfoTokenizer.nextToken();
            SourceType source = SourceType.valueOf((String)sourceAsName);
            String comment = null;
            try {
                comment = parameterInfoTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (comment == null || comment.isEmpty()) {
                comment = null;
            }
            String decodedComment = FunctionSignatureStringable.decodeString(comment);
            String storage = null;
            int index = this.parameterInfos.size();
            if (parameterStorage.size() > index) {
                storage = (String)parameterStorage.get(index);
            }
            this.parameterInfos.add(new ParameterInfo(dtIDString, dataTypeManager, name, storage, source, decodedComment));
        }
    }

    private boolean isDefaultParameterName(String name) {
        if (name == null) {
            return true;
        }
        return SymbolUtilities.isDefaultParameterName((String)name);
    }

    private String saveParameterInfos() {
        StringBuilder storageBuilder = new StringBuilder();
        int nameCount = this.parameterInfos.size();
        for (int i = 0; i < nameCount; ++i) {
            ParameterInfo parameterInfo = this.parameterInfos.get(i);
            String name = parameterInfo.name;
            SourceType source = parameterInfo.source;
            String comment = parameterInfo.comment;
            if (comment == null) {
                comment = EMPTY_STRING;
            }
            String encodedComment = FunctionSignatureStringable.encodeString(comment);
            boolean makePointer = false;
            DataType dt = parameterInfo.dataType;
            if (dt instanceof Pointer) {
                makePointer = true;
                dt = ((Pointer)dt).getDataType();
            }
            long dataTypeID = this.program.getDataTypeManager().getResolvedID(dt);
            Object serializedDataTypeID = Long.toString(dataTypeID);
            if (makePointer) {
                serializedDataTypeID = MAKE_POINTER_PREFIX + (String)serializedDataTypeID;
            }
            storageBuilder.append((String)serializedDataTypeID).append(PARAMETER_INFO_DELIMITER);
            storageBuilder.append(name).append(PARAMETER_INFO_DELIMITER);
            storageBuilder.append(source.name()).append(PARAMETER_INFO_DELIMITER);
            storageBuilder.append(encodedComment).append(PARAMETER_INFO_DELIMITER);
            storageBuilder.append("\t");
        }
        return storageBuilder.toString();
    }

    @Override
    public int hashCode() {
        if (this.returnInfo == null) {
            return 0;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.originalName.hashCode();
        result = 31 * result + this.returnInfo.dataType.getDisplayName().hashCode();
        for (ParameterInfo paramInfo : this.parameterInfos) {
            result = 31 * result + paramInfo.dataType.getDisplayName().hashCode();
        }
        result = 31 * result + (this.callFixup == null ? 0 : this.callFixup.hashCode());
        result = 31 * result + (this.isInline ? 1 : 0);
        result = 31 * result + (this.hasNoReturn ? 1 : 0);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionSignatureStringable other = (FunctionSignatureStringable)obj;
        if (this.returnInfo == null) {
            return other.returnInfo == null;
        }
        if (this.signatureSource != other.signatureSource) {
            return false;
        }
        if (this.hasCustomStorage != other.hasCustomStorage) {
            return false;
        }
        if (this.isInline != other.isInline) {
            return false;
        }
        if (this.hasNoReturn != other.hasNoReturn) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.callFixup, (Object)other.callFixup)) {
            return false;
        }
        if (this.hasVarargs != other.hasVarargs) {
            return false;
        }
        if (!this.returnInfo.isEquivalent(other.returnInfo)) {
            return false;
        }
        int paramCnt = this.parameterInfos.size();
        if (paramCnt != other.parameterInfos.size()) {
            return false;
        }
        for (int i = 0; i < paramCnt; ++i) {
            if (this.parameterInfos.get(i).isEquivalent(other.parameterInfos.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean sameFunctionSignature(Function function) {
        return this.equals(new FunctionSignatureStringable(function));
    }

    public boolean applyFunctionSignature(Function toFunction, ToolOptions markupOptions, boolean forceApply) throws VersionTrackingApplyException {
        VTMatchApplyChoices.FunctionSignatureChoices functionSignatureChoice = (VTMatchApplyChoices.FunctionSignatureChoices)markupOptions.getEnum("Apply Markup Options.Function Signature", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_SIGNATURE);
        int toParamCount = toFunction.getParameterCount();
        if (functionSignatureChoice == VTMatchApplyChoices.FunctionSignatureChoices.WHEN_SAME_PARAMETER_COUNT && toParamCount != this.parameterInfos.size()) {
            Msg.debug((Object)this, (Object)("Number of parameters differs so function signature not applied at " + toFunction.getEntryPoint() + "."));
            return false;
        }
        VTMatchApplyChoices.CommentChoices commentChoice = (VTMatchApplyChoices.CommentChoices)markupOptions.getEnum("Apply Markup Options.Function Parameter Comments", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_COMMENTS);
        try {
            this.applyInline(toFunction, this.isInline, markupOptions);
            this.applyNoReturn(toFunction, this.hasNoReturn, markupOptions);
            String conventionName = this.getCallingConvention(toFunction, markupOptions);
            boolean useCustomStorage = false;
            if (this.hasCustomStorage != toFunction.hasCustomVariableStorage()) {
                boolean sameLanguage = FunctionUtility.isSameLanguage((Program)toFunction.getProgram(), (Program)this.program);
                if (!this.hasCustomStorage || this.hasCustomStorage && sameLanguage) {
                    useCustomStorage = this.hasCustomStorage;
                }
            }
            Parameter returnParam = this.getReturnParameter(toFunction, markupOptions, forceApply, useCustomStorage);
            List<Parameter> newParams = this.getParameters(toFunction, markupOptions, forceApply, useCustomStorage);
            toFunction.updateFunction(conventionName, (Variable)returnParam, newParams, useCustomStorage ? Function.FunctionUpdateType.CUSTOM_STORAGE : Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, this.signatureSource);
            if (forceApply) {
                toFunction.setSignatureSource(this.signatureSource);
            }
        }
        catch (DuplicateNameException e) {
            throw new VersionTrackingApplyException(e.getMessage(), e);
        }
        catch (InvalidInputException e) {
            throw new VersionTrackingApplyException(e.getMessage(), e);
        }
        boolean hasFromVarArgs = this.hasVarargs;
        boolean hasToVarArgs = toFunction.hasVarArgs();
        if (hasFromVarArgs != hasToVarArgs) {
            this.applyVarArgs(toFunction, hasFromVarArgs, markupOptions);
        }
        this.applyCallFixup(toFunction, this.callFixup, markupOptions);
        if (forceApply) {
            this.forceParameterNames(toFunction);
        } else {
            this.applyParameterNames(toFunction, markupOptions, true, toParamCount);
        }
        this.replaceParameterComments(toFunction, commentChoice);
        return true;
    }

    private void applyInline(Function toFunction, boolean fromFunctionIsInline, ToolOptions markupOptions) {
        VTMatchApplyChoices.ReplaceChoices inlineChoice = (VTMatchApplyChoices.ReplaceChoices)markupOptions.getEnum("Apply Markup Options.Function Inline", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_INLINE);
        if (inlineChoice == VTMatchApplyChoices.ReplaceChoices.EXCLUDE) {
            return;
        }
        boolean toFunctionIsInline = toFunction.isInline();
        if (fromFunctionIsInline == toFunctionIsInline) {
            return;
        }
        if (inlineChoice == VTMatchApplyChoices.ReplaceChoices.REPLACE) {
            toFunction.setInline(fromFunctionIsInline);
        }
    }

    private Parameter getReturnParameter(Function toFunction, ToolOptions markupOptions, boolean forceApply, boolean useCustomStorage) throws InvalidInputException {
        boolean onlyReplaceUndefineds;
        Parameter returnParam = toFunction.getReturn();
        VTMatchApplyChoices.ParameterDataTypeChoices returnTypeChoice = (VTMatchApplyChoices.ParameterDataTypeChoices)markupOptions.getEnum("Apply Markup Options.Function Return Type", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_RETURN_TYPE);
        boolean bl = onlyReplaceUndefineds = returnTypeChoice == VTMatchApplyChoices.ParameterDataTypeChoices.REPLACE_UNDEFINED_DATA_TYPES_ONLY;
        if (returnTypeChoice == VTMatchApplyChoices.ParameterDataTypeChoices.EXCLUDE) {
            return returnParam;
        }
        DataType toReturnType = toFunction.getReturnType();
        DataType fromReturnType = this.returnInfo.dataType;
        boolean isFromDefault = fromReturnType == DataType.DEFAULT;
        boolean isToDefault = toReturnType == DataType.DEFAULT;
        boolean isToUndefined = Undefined.isUndefined((DataType)toReturnType);
        if (!forceApply && onlyReplaceUndefineds && !isToDefault && !isToUndefined) {
            return returnParam;
        }
        if (!forceApply && isFromDefault) {
            return returnParam;
        }
        DataType returnType = forceApply ? fromReturnType : this.getHighestPriorityDataType(fromReturnType, toReturnType, onlyReplaceUndefineds);
        VariableStorage returnVariableStorage = VariableStorage.UNASSIGNED_STORAGE;
        if (useCustomStorage && this.returnInfo.storage != null) {
            returnVariableStorage = VariableStorage.deserialize((Program)toFunction.getProgram(), (String)this.returnInfo.storage);
        }
        return new ReturnParameterImpl(returnType, returnVariableStorage, toFunction.getProgram());
    }

    private void applyNoReturn(Function toFunction, boolean fromFunctionHasNoReturn, ToolOptions markupOptions) {
        VTMatchApplyChoices.ReplaceChoices noReturnChoice = (VTMatchApplyChoices.ReplaceChoices)markupOptions.getEnum("Apply Markup Options.Function No Return", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_NO_RETURN);
        if (noReturnChoice == VTMatchApplyChoices.ReplaceChoices.EXCLUDE) {
            return;
        }
        boolean toFunctionHasNoReturn = toFunction.hasNoReturn();
        if (fromFunctionHasNoReturn == toFunctionHasNoReturn) {
            return;
        }
        if (noReturnChoice == VTMatchApplyChoices.ReplaceChoices.REPLACE) {
            toFunction.setNoReturn(fromFunctionHasNoReturn);
        }
    }

    private void applyVarArgs(Function toFunction, boolean fromFunctionHasVarArgs, ToolOptions markupOptions) {
        VTMatchApplyChoices.ReplaceChoices varArgsChoice = (VTMatchApplyChoices.ReplaceChoices)markupOptions.getEnum("Apply Markup Options.Function Var Args", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_VAR_ARGS);
        if (varArgsChoice == VTMatchApplyChoices.ReplaceChoices.EXCLUDE) {
            return;
        }
        boolean toFunctionHasVarArgs = toFunction.hasVarArgs();
        if (fromFunctionHasVarArgs == toFunctionHasVarArgs) {
            return;
        }
        if (varArgsChoice == VTMatchApplyChoices.ReplaceChoices.REPLACE) {
            toFunction.setVarArgs(fromFunctionHasVarArgs);
        }
    }

    private void applyCallFixup(Function toFunction, String fromFunctionCallFixup, ToolOptions markupOptions) {
        VTMatchApplyChoices.ReplaceChoices callFixupChoice = (VTMatchApplyChoices.ReplaceChoices)markupOptions.getEnum("Apply Markup Options.Function Call Fixup", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_CALL_FIXUP);
        if (callFixupChoice == VTMatchApplyChoices.ReplaceChoices.EXCLUDE) {
            return;
        }
        String toFunctionCallFixup = toFunction.getCallFixup();
        if (SystemUtilities.isEqual((Object)fromFunctionCallFixup, (Object)toFunctionCallFixup)) {
            return;
        }
        if (callFixupChoice == VTMatchApplyChoices.ReplaceChoices.REPLACE && FunctionUtility.isSameLanguage((Program)toFunction.getProgram(), (Program)this.program)) {
            toFunction.setCallFixup(fromFunctionCallFixup);
        }
    }

    private String getCallingConvention(Function toFunction, ToolOptions markupOptions) {
        boolean isFromUnknownCallingConvention = this.callingConventionName == null || this.callingConventionName.equals("unknown");
        VTMatchApplyChoices.CallingConventionChoices callingConventionChoice = (VTMatchApplyChoices.CallingConventionChoices)markupOptions.getEnum("Apply Markup Options.Function Calling Convention", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_CALLING_CONVENTION);
        String toCallingConventionName = toFunction.getCallingConventionName();
        if (SystemUtilities.isEqual((Object)this.callingConventionName, (Object)toCallingConventionName)) {
            return this.callingConventionName;
        }
        Program toProgram = toFunction.getProgram();
        switch (callingConventionChoice) {
            case SAME_LANGUAGE: {
                if (!FunctionUtility.isSameLanguage((Program)this.program, (Program)toProgram)) break;
                return this.callingConventionName;
            }
            case NAME_MATCH: {
                if (!isFromUnknownCallingConvention && !this.hasNamedCallingConvention(this.callingConventionName, toProgram)) break;
                return this.callingConventionName;
            }
        }
        return toCallingConventionName;
    }

    private boolean hasNamedCallingConvention(String myCallingConventionName, Program programToCheck) {
        Language language = programToCheck.getLanguage();
        CompilerSpec defaultCompilerSpec = language.getDefaultCompilerSpec();
        PrototypeModel callingConvention = defaultCompilerSpec.getCallingConvention(myCallingConventionName);
        return callingConvention != null;
    }

    private List<Parameter> getParameters(Function toFunction, ToolOptions markupOptions, boolean forceApply, boolean useCustomStorage) throws InvalidInputException {
        VTMatchApplyChoices.ParameterDataTypeChoices parameterDataTypesChoice = (VTMatchApplyChoices.ParameterDataTypeChoices)markupOptions.getEnum("Apply Markup Options.Function Parameter Data Types", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_DATA_TYPES);
        boolean onlyReplaceUndefineds = parameterDataTypesChoice == VTMatchApplyChoices.ParameterDataTypeChoices.REPLACE_UNDEFINED_DATA_TYPES_ONLY;
        Program toProgram = toFunction.getProgram();
        Parameter[] toParameters = toFunction.getParameters();
        int toCount = toParameters.length;
        int parameterCount = this.parameterInfos.size();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (int i = 0; i < parameterCount; ++i) {
            DataType toDataType;
            ParameterInfo paramInfo = this.parameterInfos.get(i);
            SourceType source = SourceType.DEFAULT;
            String name = source != SourceType.DEFAULT ? null : paramInfo.name;
            String comment = paramInfo.comment;
            if (!forceApply && i < toCount) {
                name = toParameters[i].getName();
                source = toParameters[i].getSource();
                comment = toParameters[i].getComment();
            }
            DataType fromDataType = paramInfo.dataType;
            DataType dataType = toDataType = i < toCount ? toParameters[i].getDataType() : fromDataType;
            DataType dataType2 = forceApply ? fromDataType : (parameterDataTypesChoice == VTMatchApplyChoices.ParameterDataTypeChoices.EXCLUDE ? toDataType : this.getHighestPriorityDataType(fromDataType, toDataType, onlyReplaceUndefineds));
            VariableStorage storage = VariableStorage.UNASSIGNED_STORAGE;
            if (useCustomStorage) {
                if (i < toCount && dataType2 == toDataType) {
                    storage = toParameters[i].getVariableStorage();
                } else if (paramInfo.storage != null) {
                    storage = VariableStorage.deserialize((Program)toProgram, (String)paramInfo.storage);
                }
            }
            ParameterImpl param = new ParameterImpl(name, dataType2, storage, toProgram, source);
            param.setComment(comment);
            parameters.add((Parameter)param);
        }
        return parameters;
    }

    private DataType getHighestPriorityDataType(DataType fromDataType, DataType toDataType, boolean onlyReplaceUndefineds) {
        boolean fromIsDefault = fromDataType == DataType.DEFAULT;
        boolean toIsDefault = toDataType == DataType.DEFAULT;
        boolean fromIsUndefined = Undefined.isUndefined((DataType)fromDataType);
        boolean toIsUndefined = Undefined.isUndefined((DataType)toDataType);
        if (fromIsDefault) {
            return toDataType;
        }
        if (fromIsUndefined) {
            if (toIsDefault || toIsUndefined && !onlyReplaceUndefineds) {
                return fromDataType;
            }
            return toDataType;
        }
        if (toIsDefault || toIsUndefined || !onlyReplaceUndefineds) {
            return fromDataType;
        }
        return toDataType;
    }

    public boolean applyParameterNames(Function toFunction, ToolOptions markupOptions, boolean doNotReplaceWithDefaultNames, int originalToParamCount) throws VersionTrackingApplyException {
        int fromParameterCount;
        int minParameterCount;
        boolean replaceSamePriorityNames;
        VTMatchApplyChoices.HighestSourcePriorityChoices highestPriorityChoice;
        VTMatchApplyChoices.SourcePriorityChoices parameterNamesChoice = (VTMatchApplyChoices.SourcePriorityChoices)markupOptions.getEnum("Apply Markup Options.Function Parameter Names", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_NAMES);
        boolean duplicateNameOccurred = this.tryToSetNames(toFunction, doNotReplaceWithDefaultNames, parameterNamesChoice, highestPriorityChoice = (VTMatchApplyChoices.HighestSourcePriorityChoices)markupOptions.getEnum("Apply Markup Options.Function Parameter Names Highest Name Priority", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_HIGHEST_NAME_PRIORITY), replaceSamePriorityNames = markupOptions.getBoolean("Apply Markup Options.Function Parameter Names Replace If Same Priority", VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_NAMES_REPLACE_IF_SAME_PRIORITY), minParameterCount = Math.min(fromParameterCount = this.parameterInfos.size(), originalToParamCount));
        if (duplicateNameOccurred) {
            this.tryToSetNames(toFunction, doNotReplaceWithDefaultNames, parameterNamesChoice, highestPriorityChoice, replaceSamePriorityNames, minParameterCount);
        }
        return true;
    }

    private boolean tryToSetNames(Function toFunction, boolean doNotReplaceWithDefaultNames, VTMatchApplyChoices.SourcePriorityChoices parameterNamesChoice, VTMatchApplyChoices.HighestSourcePriorityChoices highestPriorityChoice, boolean replaceSamePriorityNames, int minParameterCount) throws VersionTrackingApplyException {
        boolean duplicateNameOccurred = false;
        int paramCnt = this.parameterInfos.size();
        block11: for (int i = 0; i < paramCnt; ++i) {
            boolean toIsDefaultName;
            ParameterInfo parameterInfo = this.parameterInfos.get(i);
            String fromName = parameterInfo.name;
            SourceType fromSource = parameterInfo.source;
            boolean fromIsDefaultName = fromSource == SourceType.DEFAULT || fromName == null;
            Parameter toParameter = toFunction.getParameter(i);
            SourceType toSource = toParameter.getSource();
            String toName = toSource != SourceType.DEFAULT ? toParameter.getName() : null;
            boolean bl = toIsDefaultName = toSource == SourceType.DEFAULT || toName == null;
            if (fromIsDefaultName && (doNotReplaceWithDefaultNames || toIsDefaultName) || SystemUtilities.isEqual((Object)fromName, (Object)toName)) continue;
            if (i < minParameterCount) {
                switch (parameterNamesChoice) {
                    case PRIORITY_REPLACE: {
                        if (!(highestPriorityChoice == VTMatchApplyChoices.HighestSourcePriorityChoices.IMPORT_PRIORITY_HIGHEST ? !this.isFirstHigherPriorityWhenImportedPriority(fromSource, toSource, replaceSamePriorityNames) : !this.isFirstHigherPriorityWhenUserPriority(fromSource, toSource, replaceSamePriorityNames))) break;
                        continue block11;
                    }
                    case REPLACE_DEFAULTS_ONLY: {
                        if (toIsDefaultName && !fromIsDefaultName) break;
                        continue block11;
                    }
                    case REPLACE: {
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
            }
            try {
                toParameter.setName(fromName, fromSource);
                continue;
            }
            catch (DuplicateNameException e) {
                SymbolTable symbolTable = toFunction.getProgram().getSymbolTable();
                String uniqueParameterName = FunctionSignatureStringable.getUniqueParameterName(symbolTable, toFunction, fromName);
                try {
                    toParameter.setName(uniqueParameterName, fromSource);
                    duplicateNameOccurred = true;
                    continue;
                }
                catch (DuplicateNameException e1) {
                    throw new VersionTrackingApplyException(e1.getMessage(), e1);
                }
                catch (InvalidInputException e1) {
                    throw new VersionTrackingApplyException(e1.getMessage(), e1);
                }
            }
            catch (InvalidInputException e) {
                throw new VersionTrackingApplyException(e.getMessage(), e);
            }
        }
        return duplicateNameOccurred;
    }

    private boolean forceParameterNames(Function toFunction) throws VersionTrackingApplyException {
        boolean duplicateNameOccurred = this.tryToForceNames(toFunction);
        if (duplicateNameOccurred) {
            this.tryToForceNames(toFunction);
        }
        return true;
    }

    private boolean tryToForceNames(Function toFunction) throws VersionTrackingApplyException {
        boolean duplicateNameOccurred = false;
        int paramCnt = this.parameterInfos.size();
        for (int i = 0; i < paramCnt; ++i) {
            String toName;
            ParameterInfo parameterInfo = this.parameterInfos.get(i);
            String fromName = parameterInfo.name;
            SourceType fromSource = parameterInfo.source;
            Parameter toParameter = toFunction.getParameter(i);
            if (toParameter.isAutoParameter()) continue;
            SourceType toSource = toParameter.getSource();
            String string = toName = toSource != SourceType.DEFAULT ? toParameter.getName() : null;
            if (SystemUtilities.isEqual((Object)fromName, (Object)toName)) continue;
            try {
                toParameter.setName(fromName, fromSource);
                continue;
            }
            catch (DuplicateNameException e) {
                SymbolTable symbolTable = toFunction.getProgram().getSymbolTable();
                String uniqueParameterName = FunctionSignatureStringable.getUniqueParameterName(symbolTable, toFunction, fromName);
                try {
                    toParameter.setName(uniqueParameterName, fromSource);
                    duplicateNameOccurred = true;
                    continue;
                }
                catch (DuplicateNameException e1) {
                    throw new VersionTrackingApplyException(e1.getMessage(), e1);
                }
                catch (InvalidInputException e1) {
                    throw new VersionTrackingApplyException(e1.getMessage(), e1);
                }
            }
            catch (InvalidInputException e) {
                throw new VersionTrackingApplyException(e.getMessage(), e);
            }
        }
        return duplicateNameOccurred;
    }

    private boolean isFirstHigherPriorityWhenUserPriority(SourceType first, SourceType second, boolean replaceSamePriorityNames) {
        if (first == second && first != SourceType.DEFAULT) {
            return replaceSamePriorityNames;
        }
        if (first == SourceType.USER_DEFINED) {
            return second == SourceType.IMPORTED || second == SourceType.ANALYSIS || second == SourceType.DEFAULT;
        }
        if (first == SourceType.IMPORTED) {
            return second == SourceType.ANALYSIS || second == SourceType.DEFAULT;
        }
        if (first == SourceType.ANALYSIS) {
            return second == SourceType.DEFAULT;
        }
        return false;
    }

    private boolean isFirstHigherPriorityWhenImportedPriority(SourceType first, SourceType second, boolean replaceSamePriorityNames) {
        if (first == second && first != SourceType.DEFAULT) {
            return replaceSamePriorityNames;
        }
        if (first == SourceType.IMPORTED) {
            return second == SourceType.USER_DEFINED || second == SourceType.ANALYSIS || second == SourceType.DEFAULT;
        }
        if (first == SourceType.USER_DEFINED) {
            return second == SourceType.ANALYSIS || second == SourceType.DEFAULT;
        }
        if (first == SourceType.ANALYSIS) {
            return second == SourceType.DEFAULT;
        }
        return false;
    }

    private void replaceParameterComments(Function toFunction, VTMatchApplyChoices.CommentChoices commentChoice) {
        if (commentChoice == VTMatchApplyChoices.CommentChoices.EXCLUDE) {
            return;
        }
        int fromParameterCount = this.parameterInfos.size();
        int toParameterCount = toFunction.getParameterCount();
        int minParameterCount = Math.min(fromParameterCount, toParameterCount);
        for (int i = 0; i < minParameterCount; ++i) {
            ParameterInfo parameterInfo = this.parameterInfos.get(i);
            String fromComment = parameterInfo.comment;
            Parameter toParameter = toFunction.getParameter(i);
            String toComment = toParameter.getComment();
            if (SystemUtilities.isEqual((Object)fromComment, (Object)toComment)) continue;
            if (commentChoice == VTMatchApplyChoices.CommentChoices.APPEND_TO_EXISTING) {
                String mergedComment = StringUtilities.mergeStrings((String)toComment, (String)fromComment);
                if (mergedComment != null && mergedComment.length() == 0) {
                    mergedComment = null;
                }
                if (!SystemUtilities.isEqual((Object)mergedComment, (Object)toComment)) {
                    toParameter.setComment(mergedComment);
                }
            }
            if (commentChoice != VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING) continue;
            if (fromComment != null && fromComment.length() == 0) {
                fromComment = null;
            }
            toParameter.setComment(fromComment);
        }
    }

    private static String getUniqueParameterName(SymbolTable symbolTable, Function function, String baseName) {
        Object name = baseName;
        if (name != null) {
            int cnt = 0;
            while (symbolTable.getVariableSymbol((String)name, function) != null) {
                name = baseName + ++cnt;
            }
        }
        return name;
    }

    private class ParameterInfo {
        private final DataType dataType;
        private final String name;
        private final SourceType source;
        private final String comment;
        private final String storage;

        private ParameterInfo(DataType dataType, String name, String storage, SourceType source, String comment) {
            this.dataType = dataType;
            this.name = name;
            this.storage = storage;
            this.source = source;
            this.comment = comment;
            if (comment != null && comment.trim().length() == 0) {
                comment = null;
            }
        }

        private ParameterInfo(String serializedDataTypeID, DataTypeManager dtMgr, String name, String storage, SourceType source, String comment) {
            long dataTypeID = -1L;
            boolean makePtr = false;
            if (serializedDataTypeID != null && !serializedDataTypeID.isEmpty()) {
                if (serializedDataTypeID.startsWith(FunctionSignatureStringable.MAKE_POINTER_PREFIX)) {
                    makePtr = true;
                    serializedDataTypeID = serializedDataTypeID.substring(FunctionSignatureStringable.MAKE_POINTER_PREFIX.length());
                }
                dataTypeID = Long.parseLong(serializedDataTypeID);
            }
            DataType dt = dtMgr.getDataType(dataTypeID);
            if (makePtr) {
                dt = new PointerDataType(dt, dtMgr);
            }
            this.dataType = dt;
            this.name = name;
            this.storage = storage;
            this.source = source;
            this.comment = comment;
            if (comment != null && comment.trim().length() == 0) {
                comment = null;
            }
        }

        boolean isEquivalent(ParameterInfo other) {
            if (this.source != other.source) {
                return false;
            }
            if (this.source != SourceType.DEFAULT && !this.name.equals(other.name)) {
                return false;
            }
            if (!SystemUtilities.isEqual((Object)this.comment, (Object)other.comment)) {
                return false;
            }
            return DataTypeUtilities.isSameOrEquivalentDataType((DataType)this.dataType, (DataType)other.dataType);
        }

        public String toString() {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("[");
            strBuilder.append(this.dataType.getName());
            strBuilder.append(" ");
            strBuilder.append(this.name);
            strBuilder.append("@");
            strBuilder.append(this.storage);
            strBuilder.append("]");
            return strBuilder.toString();
        }
    }
}

