/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.util;

import docking.widgets.table.DisplayStringProvider;
import ghidra.program.model.listing.Program;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.exception.AssertException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class Stringable
implements ExtensionPoint,
DisplayStringProvider {
    private static Map<String, Class<? extends Stringable>> shortNameToClassnameMap;
    public static final String DELIMITER = "\t";
    public static final String DOUBLE_DELIMITER = "\n";
    private final String shortName;

    private static void initializeNameMap() {
        shortNameToClassnameMap = new HashMap<String, Class<? extends Stringable>>();
        Set classes = ClassSearcher.getClasses(Stringable.class);
        for (Class clazz : classes) {
            String name = Stringable.getShortNameFieldValue(clazz);
            shortNameToClassnameMap.put(name, clazz);
        }
    }

    private static String getShortNameFieldValue(Class<? extends Stringable> clazz) {
        try {
            Field field = clazz.getField("SHORT_NAME");
            if (field == null) {
                throw new AssertException("Found a Stringable that did not define a public static field named \"SHORT_NAME\"");
            }
            String name = (String)field.get(null);
            if (name == null) {
                throw new AssertException("Error reading Stringable SHORT_NAME field for class: ");
            }
            return name;
        }
        catch (SecurityException e) {
            throw new AssertException("Error reading Stringable SHORT_NAME field for class: " + clazz, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new AssertException("Error reading Stringable SHORT_NAME field for class: " + clazz, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertException("Error reading Stringable SHORT_NAME field for class: " + clazz, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertException("Error reading Stringable SHORT_NAME field for class: " + clazz, (Throwable)e);
        }
    }

    private static Map<String, Class<? extends Stringable>> getNameMap() {
        if (shortNameToClassnameMap == null) {
            Stringable.initializeNameMap();
        }
        return shortNameToClassnameMap;
    }

    protected Stringable(String shortName) {
        this.shortName = shortName;
        Stringable.getNameMap().put(shortName, this.getClass());
    }

    public abstract String getDisplayString();

    protected abstract String doConvertToString(Program var1);

    protected abstract void doRestoreFromString(String var1, Program var2);

    public static String getString(Stringable stringable, Program program) {
        if (stringable == null) {
            return null;
        }
        return stringable.shortName + DELIMITER + stringable.doConvertToString(program);
    }

    public static Stringable getStringable(String valueString, Program program) {
        if (valueString == null) {
            return null;
        }
        int delimiterIndex = valueString.indexOf(DELIMITER);
        String shortName = valueString.substring(0, delimiterIndex);
        Stringable newInstance = Stringable.createStringable(shortName);
        int contentOffset = delimiterIndex + DELIMITER.length();
        newInstance.doRestoreFromString(valueString.substring(contentOffset), program);
        return newInstance;
    }

    private static Stringable createStringable(String name) {
        Class<? extends Stringable> clazz = Stringable.getNameMap().get(name);
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public String toString() {
        return this.getDisplayString();
    }

    protected static String encodeString(String unencodedComment) {
        int i;
        StringBuffer buffer = new StringBuffer();
        int startIndex = 0;
        int length = unencodedComment.length();
        block6: for (i = 0; i < length; ++i) {
            char charAt = unencodedComment.charAt(i);
            switch (charAt) {
                case '\t': {
                    startIndex = Stringable.saveSubStringAndEscapedCharacter(unencodedComment, buffer, startIndex, i, 't');
                    continue block6;
                }
                case '\r': {
                    startIndex = Stringable.saveSubStringAndEscapedCharacter(unencodedComment, buffer, startIndex, i, 'r');
                    continue block6;
                }
                case '\n': {
                    startIndex = Stringable.saveSubStringAndEscapedCharacter(unencodedComment, buffer, startIndex, i, 'n');
                    continue block6;
                }
                case '\f': {
                    startIndex = Stringable.saveSubStringAndEscapedCharacter(unencodedComment, buffer, startIndex, i, 'f');
                    continue block6;
                }
            }
        }
        if (i > startIndex) {
            buffer.append(unencodedComment.substring(startIndex, i));
        }
        return buffer.toString();
    }

    private static int saveSubStringAndEscapedCharacter(String comment, StringBuffer buffer, int startIndex, int endIndex, char escapedChar) {
        buffer.append(comment.substring(startIndex, endIndex));
        buffer.append('\\');
        buffer.append(escapedChar);
        startIndex = endIndex + 1;
        return startIndex;
    }

    protected static String decodeString(String encodedComment) {
        if (encodedComment == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int startIndex = 0;
        int index = encodedComment.indexOf(92, startIndex);
        while (index != -1) {
            buffer.append(encodedComment.substring(startIndex, index));
            char charAt = encodedComment.charAt(++index);
            switch (charAt) {
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                default: {
                    buffer.append(92 + charAt);
                }
            }
            startIndex = ++index;
            index = encodedComment.indexOf(92, startIndex);
        }
        if (startIndex < encodedComment.length()) {
            buffer.append(encodedComment.substring(startIndex));
        }
        return buffer.toString();
    }
}

