/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchContext;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

public class CreateSelectionAction
extends DockingAction {
    public static final String NAME = "Create Match Table Selection";
    private static final String MENU_GROUP = "Selection";
    private static final Icon ICON = ResourceManager.loadImage((String)"images/text_align_justify.png");
    private final VTController controller;

    public CreateSelectionAction(VTController controller) {
        super(NAME, VTPlugin.OWNER);
        this.controller = controller;
        this.setToolBarData(new ToolBarData(ICON, MENU_GROUP));
        this.setPopupMenuData(new MenuData(new String[]{"Make Selections"}, ICON, MENU_GROUP));
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Make Selections"));
        this.setDescription("Makes selections in both the source and destination tools for the selected matches.");
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof VTMatchContext)) {
            return false;
        }
        VTMatchContext matchContext = (VTMatchContext)context;
        List<VTMatch> matches = matchContext.getSelectedMatches();
        return matches.size() != 0;
    }

    public void actionPerformed(ActionContext context) {
        Program sourceProgram = this.controller.getSourceProgram();
        Program destinationProgram = this.controller.getDestinationProgram();
        AddressSet sourceSet = new AddressSet();
        AddressSet destinationSet = new AddressSet();
        VTMatchContext matchContext = (VTMatchContext)context;
        List<VTMatch> matches = matchContext.getSelectedMatches();
        for (VTMatch vtMatch : matches) {
            VTAssociation association = vtMatch.getAssociation();
            sourceSet.add(association.getSourceAddress());
            destinationSet.add(association.getDestinationAddress());
        }
        this.controller.setSelectionInSourceTool((AddressSetView)sourceSet);
        this.controller.setSelectionInDestinationTool((AddressSetView)destinationSet);
    }
}

