/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import docking.widgets.checkbox.GCheckBox;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.filters.CheckBoxBasedAncillaryFilter;
import ghidra.feature.vt.gui.filters.CheckBoxInfo;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;

public class AssociationStatusFilter
extends CheckBoxBasedAncillaryFilter<VTMatch> {
    public AssociationStatusFilter() {
        super("Association Status");
    }

    @Override
    protected void createCheckBoxInfos() {
        VTAssociationStatus[] values;
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AssociationStatusFilter.this.fireStatusChanged(AssociationStatusFilter.this.getFilterStatus());
            }
        };
        for (VTAssociationStatus status : values = VTAssociationStatus.values()) {
            GCheckBox checkBox = new GCheckBox(status.getDisplayName(), true);
            checkBox.addItemListener(listener);
            AssociationStatusCheckBoxInfo info = new AssociationStatusCheckBoxInfo((JCheckBox)checkBox, status);
            this.checkBoxInfos.add(info);
        }
    }

    private class AssociationStatusCheckBoxInfo
    extends CheckBoxInfo<VTMatch> {
        private VTAssociationStatus associationStatus;

        public AssociationStatusCheckBoxInfo(JCheckBox checkBox, VTAssociationStatus associationStatus) {
            super(checkBox);
            this.associationStatus = associationStatus;
        }

        @Override
        public boolean matchesStatus(VTMatch match) {
            if (!this.isSelected()) {
                return false;
            }
            return match.getAssociation().getStatus().equals((Object)this.associationStatus);
        }
    }
}

