/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemConsideredStatus;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class TagMarkupItemTask
extends VtTask {
    protected final List<VTMarkupItem> markupItems;
    protected final VTMarkupItemConsideredStatus tag;

    public TagMarkupItemTask(VTSession session, List<VTMarkupItem> markupItems, VTMarkupItemConsideredStatus tag) {
        this(tag.name() + " Markup Items", session, markupItems, tag);
    }

    protected TagMarkupItemTask(String title, VTSession session, List<VTMarkupItem> markupItems, VTMarkupItemConsideredStatus tag) {
        super(title, session);
        this.markupItems = markupItems;
        this.tag = tag;
    }

    @Override
    protected boolean doWork(TaskMonitor monitor) throws Exception {
        monitor.initialize((long)this.markupItems.size());
        for (VTMarkupItem markupItem : this.markupItems) {
            monitor.checkCanceled();
            markupItem.setConsidered(this.tag);
            monitor.incrementProgress(1L);
        }
        return true;
    }
}

