/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.MappedTableColumn;
import ghidra.docking.settings.Settings;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.MappedProgramLocationTableColumn;
import ghidra.util.table.ProgramLocationTableRowMapper;
import ghidra.util.table.field.ProgramLocationTableColumn;

public class VTMatchSourceAddressToProgramLocationTableRowMapper
extends ProgramLocationTableRowMapper<VTMatch, ProgramLocation> {
    public <COLUMN_TYPE> DynamicTableColumn<VTMatch, COLUMN_TYPE, Program> createMappedTableColumn(DynamicTableColumn<ProgramLocation, COLUMN_TYPE, Program> destinationColumn) {
        if (destinationColumn instanceof ProgramLocationTableColumn) {
            ProgramLocationTableColumn programColumn = (ProgramLocationTableColumn)destinationColumn;
            return new VTMatchSourceWrappedMappedProgramLocationTableColumn(this, programColumn);
        }
        return new VTMatchSourceWrappedMappedTableColumn<COLUMN_TYPE>(this, destinationColumn);
    }

    public ProgramLocation map(VTMatch rowObject, Program program, ServiceProvider serviceProvider) {
        VTAssociation association = rowObject.getAssociation();
        Address sourceAddress = association.getSourceAddress();
        return new ProgramLocation(program, sourceAddress);
    }

    private class VTMatchSourceWrappedMappedTableColumn<COLUMN_TYPE>
    extends MappedTableColumn<VTMatch, ProgramLocation, COLUMN_TYPE, Program> {
        public VTMatchSourceWrappedMappedTableColumn(ProgramLocationTableRowMapper<VTMatch, ProgramLocation> mapper, DynamicTableColumn<ProgramLocation, COLUMN_TYPE, Program> tableColumn) {
            super(mapper, tableColumn, "VTMatchSource." + tableColumn.getUniqueIdentifier());
        }

        public String getColumnDisplayName(Settings settings) {
            return "Source " + super.getColumnDisplayName(settings);
        }

        public String getColumnDescription() {
            return super.getColumnName() + " (for a match's source address)";
        }

        public String getColumnName() {
            return "Source " + super.getColumnName();
        }
    }

    private class VTMatchSourceWrappedMappedProgramLocationTableColumn<COLUMN_TYPE>
    extends MappedProgramLocationTableColumn<VTMatch, ProgramLocation, COLUMN_TYPE> {
        public VTMatchSourceWrappedMappedProgramLocationTableColumn(ProgramLocationTableRowMapper<VTMatch, ProgramLocation> mapper, ProgramLocationTableColumn<ProgramLocation, COLUMN_TYPE> tableColumn) {
            super(mapper, tableColumn, "VTMatchSource." + tableColumn.getUniqueIdentifier());
        }

        public String getColumnDisplayName(Settings settings) {
            return "Source " + super.getColumnDisplayName(settings);
        }

        public String getColumnDescription() {
            return super.getColumnName() + " (for a match's source address)";
        }

        public String getColumnName() {
            return "Source " + super.getColumnName();
        }
    }
}

