/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import docking.wizard.AbstractMageJPanel;
import docking.wizard.WizardPanelDisplayability;
import docking.wizard.WizardState;
import ghidra.feature.vt.api.impl.VTProgramCorrelatorInfo;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.wizard.VTProgramTableCorrelatorModel;
import ghidra.feature.vt.gui.wizard.VTWizardStateKey;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CorrelatorPanel
extends AbstractMageJPanel<VTWizardStateKey>
implements Scrollable {
    private VTProgramTableCorrelatorModel model;
    private GhidraTable table;

    CorrelatorPanel(VTSession session) {
        this.setLayout(new BorderLayout());
        this.table = this.createBasicTable(this.getPreviouslyRunAlgorithms(session));
        this.add(new JScrollPane((Component)this.table), "Center");
    }

    private GhidraTable createBasicTable(Set<String> previouslyRunCorrelators) {
        this.model = new VTProgramTableCorrelatorModel(this, previouslyRunCorrelators);
        this.table = new GhidraTable((TableModel)((Object)this.model));
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setColumnHeaderPopupEnabled(false);
        this.table.setDefaultRenderer(Icon.class, (TableCellRenderer)((Object)new PreviouslyRunColumnRenderer()));
        this.setColumnSizes();
        return this.table;
    }

    protected void notifyListenersOfValidityChanged() {
        super.notifyListenersOfValidityChanged();
    }

    public Dimension getPreferredSize() {
        return new Dimension(1000, 400);
    }

    private void setColumnSizes() {
        TableColumnModel columnModel = this.table.getColumnModel();
        int width = 0;
        for (int col = 0; col < columnModel.getColumnCount(); ++col) {
            TableColumn column = columnModel.getColumn(col);
            if ("Select".equals(column.getHeaderValue())) {
                width = 30;
                column.setMinWidth(width);
            } else if ("Name".equals(column.getHeaderValue())) {
                width = 250;
            } else if ("Previous".equals(column.getHeaderValue())) {
                width = 30;
                column.setMinWidth(width);
            } else if ("Description".equals(column.getHeaderValue())) {
                width = 650;
            }
            column.setPreferredWidth(width);
        }
    }

    private Set<String> getPreviouslyRunAlgorithms(VTSession session) {
        HashSet<String> set = new HashSet<String>();
        List<VTMatchSet> matchSets = session.getMatchSets();
        for (VTMatchSet vtMatchSet : matchSets) {
            VTProgramCorrelatorInfo info = vtMatchSet.getProgramCorrelatorInfo();
            set.add(info.getName());
        }
        return set;
    }

    public void dispose() {
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("VersionTrackingPlugin", "Correlator_Panel");
    }

    public void enterPanel(WizardState<VTWizardStateKey> state) {
    }

    static WizardPanelDisplayability correlatorDisplayability(WizardState<VTWizardStateKey> state) {
        return WizardPanelDisplayability.MUST_BE_DISPLAYED;
    }

    public WizardPanelDisplayability getPanelDisplayabilityAndUpdateState(WizardState<VTWizardStateKey> state) {
        return CorrelatorPanel.correlatorDisplayability(state);
    }

    public void leavePanel(WizardState<VTWizardStateKey> state) {
        this.updateStateObjectWithPanelInfo(state);
    }

    public void updateStateObjectWithPanelInfo(WizardState<VTWizardStateKey> state) {
        List<VTProgramCorrelatorFactory> selectedFactories = this.model.getSelectedFactories();
        if (!selectedFactories.isEmpty()) {
            state.put((Object)VTWizardStateKey.PROGRAM_CORRELATOR_FACTORY_LIST, selectedFactories);
        }
    }

    public String getTitle() {
        return "Select Correlation Algorithm(s)";
    }

    public void initialize() {
    }

    public boolean isValidInformation() {
        return !this.model.getSelectedFactories().isEmpty();
    }

    public void addDependencies(WizardState<VTWizardStateKey> state) {
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 25;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    private class PreviouslyRunColumnRenderer
    extends GTableCellRenderer {
        PreviouslyRunColumnRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            renderer.setIcon((Icon)value);
            renderer.setText(null);
            renderer.setToolTipText(value == null ? null : "Correlator has already been run at least once.");
            return renderer;
        }
    }
}

