/*
 * Decompiled with CFR 0.152.
 */
package help.validator.model;

import help.validator.LinkDatabase;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class TOCItem {
    protected static final String[] INDENTS = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t", "\t\t\t\t\t\t", "\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t"};
    private static final String TOC_TAG_NAME = "tocitem";
    private static final String TEXT = "text";
    private static final String TARGET = "target";
    private static final String MERGE_TYPE_ATTRIBUTE = "mergetype=\"javax.help.SortMerge\"";
    protected static final String TOC_ITEM_CLOSE_TAG = "</tocitem>";
    private String sortPreference;
    private final String IDAttribute;
    protected String textAttribute;
    protected String targetAttribute;
    private final Path sourceFile;
    protected TOCItem parentItem;
    private Set<TOCItem> children = new HashSet<TOCItem>();
    private int lineNumber;

    public TOCItem(TOCItem parentItem, Path sourceFile, String ID2, int lineNumber) {
        this(parentItem, sourceFile, ID2, null, null, null, lineNumber);
    }

    TOCItem(TOCItem parentItem, Path sourceFile, String ID2, String text, String target, String sortPreference, int lineNumber) {
        this.parentItem = parentItem;
        this.sourceFile = sourceFile;
        this.IDAttribute = ID2;
        this.textAttribute = text;
        this.targetAttribute = target;
        this.sortPreference = sortPreference != null ? sortPreference.toLowerCase() : (this.textAttribute == null ? "" : this.textAttribute.toLowerCase());
        this.lineNumber = lineNumber;
        if (parentItem != null) {
            parentItem.addChild(this);
        }
    }

    public abstract boolean validate(LinkDatabase var1);

    protected int childCount() {
        return this.children.size();
    }

    protected void addChild(TOCItem child) {
        if (this == child) {
            throw new IllegalArgumentException("TOCItem cannot be added to itself");
        }
        this.children.add(child);
    }

    protected void removeChild(TOCItem child) {
        this.children.remove(child);
    }

    protected Collection<TOCItem> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    public String getSortPreference() {
        return this.sortPreference;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public TOCItem getParent() {
        return this.parentItem;
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    public String getIDAttribute() {
        return this.IDAttribute;
    }

    public String getTextAttribute() {
        return this.textAttribute;
    }

    public String getTargetAttribute() {
        return this.targetAttribute;
    }

    protected String printChildren() {
        return this.printChildren(1);
    }

    protected String printChildren(int tabCount) {
        StringBuilder buildy = new StringBuilder();
        for (TOCItem item : this.children) {
            buildy.append(INDENTS[tabCount]).append(item.toString());
            buildy.append('\n').append(item.printChildren(tabCount + 1));
        }
        return buildy.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.IDAttribute == null ? 0 : this.IDAttribute.hashCode());
        result = 31 * result + (this.sortPreference == null ? 0 : this.sortPreference.hashCode());
        result = 31 * result + (this.sourceFile == null ? 0 : this.sourceFile.hashCode());
        result = 31 * result + (this.targetAttribute == null ? 0 : this.targetAttribute.hashCode());
        result = 31 * result + (this.textAttribute == null ? 0 : this.textAttribute.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TOCItem other = (TOCItem)obj;
        if (this.IDAttribute == null ? other.IDAttribute != null : !this.IDAttribute.equals(other.IDAttribute)) {
            return false;
        }
        if (this.sortPreference == null ? other.sortPreference != null : !this.sortPreference.equals(other.sortPreference)) {
            return false;
        }
        if (this.sourceFile == null ? other.sourceFile != null : !this.sourceFile.equals(other.sourceFile)) {
            return false;
        }
        if (this.targetAttribute == null ? other.targetAttribute != null : !this.targetAttribute.equals(other.targetAttribute)) {
            return false;
        }
        return !(this.textAttribute == null ? other.textAttribute != null : !this.textAttribute.equals(other.textAttribute));
    }

    public boolean isEquivalent(TOCItem other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (this.IDAttribute == null ? other.IDAttribute != null : !this.IDAttribute.equals(other.IDAttribute)) {
            return false;
        }
        if (this.sortPreference == null ? other.sortPreference != null : !this.sortPreference.equals(other.sortPreference)) {
            return false;
        }
        if (this.targetAttribute == null ? other.targetAttribute != null : !this.targetAttribute.equals(other.targetAttribute)) {
            return false;
        }
        return !(this.textAttribute == null ? other.textAttribute != null : !this.textAttribute.equals(other.textAttribute));
    }

    public void writeContents(LinkDatabase linkDatabase, PrintWriter writer, int indentLevel) {
        if (this.children.size() == 0) {
            writer.println(this.generateTOCItemTag(linkDatabase, true, indentLevel));
        } else {
            writer.println(this.generateTOCItemTag(linkDatabase, false, indentLevel));
            int nextIndentLevel = indentLevel + 1;
            for (TOCItem item : this.children) {
                item.writeContents(linkDatabase, writer, nextIndentLevel);
            }
            writer.println(INDENTS[indentLevel] + TOC_ITEM_CLOSE_TAG);
        }
    }

    public String generateTOCItemTag(LinkDatabase linkDatabase, boolean isInlineTag, int indentLevel) {
        StringBuilder buildy = new StringBuilder();
        buildy.append(INDENTS[indentLevel]);
        buildy.append('<').append(TOC_TAG_NAME).append(' ');
        buildy.append(TEXT).append("=\"").append(this.sortPreference).append("\" ");
        if (this.targetAttribute != null) {
            String ID2 = linkDatabase.getIDForLink(this.targetAttribute);
            if (ID2 == null) {
                ID2 = this.targetAttribute;
            }
            buildy.append(TARGET).append("=\"").append(ID2).append("\" ");
        }
        buildy.append(MERGE_TYPE_ATTRIBUTE);
        buildy.append(' ').append("display").append("=\"").append(this.textAttribute).append("\"");
        buildy.append(' ').append("toc_id").append("=\"").append(this.IDAttribute).append("\"");
        if (isInlineTag) {
            buildy.append(" />");
        } else {
            buildy.append(">");
        }
        return buildy.toString();
    }

    public String generateEndTag(int indentLevel) {
        return INDENTS[indentLevel] + TOC_ITEM_CLOSE_TAG;
    }

    public void writeContents(LinkDatabase linkDatabase, PrintWriter writer) {
        this.writeContents(linkDatabase, writer, 0);
    }
}

