/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BTreeNode;
import db.LongKeyInteriorNode;
import db.LongKeyRecordNode;
import db.NodeMgr;
import db.buffers.DataBuffer;
import java.io.IOException;

abstract class LongKeyNode
implements BTreeNode {
    private static final int KEY_COUNT_SIZE = 4;
    private static final int KEY_COUNT_OFFSET = 1;
    static final int LONGKEY_NODE_HEADER_SIZE = 5;
    protected NodeMgr nodeMgr;
    protected DataBuffer buffer;
    protected LongKeyInteriorNode parent;
    protected int keyCount;

    LongKeyNode(NodeMgr nodeMgr, DataBuffer buf) {
        this.nodeMgr = nodeMgr;
        this.buffer = buf;
        this.keyCount = this.buffer.getInt(1);
        nodeMgr.addNode(this);
    }

    LongKeyNode(NodeMgr nodeMgr, byte nodeType) throws IOException {
        this.nodeMgr = nodeMgr;
        this.buffer = nodeMgr.getBufferMgr().createBuffer();
        NodeMgr.setNodeType(this.buffer, nodeType);
        this.setKeyCount(0);
        nodeMgr.addNode(this);
    }

    @Override
    public int getBufferId() {
        return this.buffer.getId();
    }

    @Override
    public DataBuffer getBuffer() {
        return this.buffer;
    }

    LongKeyNode getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    @Override
    public int getKeyCount() {
        return this.keyCount;
    }

    @Override
    public void setKeyCount(int cnt) {
        this.keyCount = cnt;
        this.buffer.putInt(1, this.keyCount);
    }

    abstract long getKey(int var1);

    abstract LongKeyRecordNode getLeafNode(long var1) throws IOException;
}

