/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dalvik.dex.inject;

import ghidra.app.plugin.processors.sleigh.PcodeEmit;
import ghidra.file.formats.android.dex.analyzer.DexAnalysisState;
import ghidra.file.formats.android.dex.format.CodeItem;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.EncodedMethod;
import ghidra.file.formats.android.dex.format.MethodIDItem;
import ghidra.file.formats.android.dex.format.PrototypesIDItem;
import ghidra.file.formats.android.dex.format.TypeItem;
import ghidra.file.formats.android.dex.format.TypeList;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import java.io.IOException;

public class InjectPayloadDexParameters
implements InjectPayload {
    public static final int INPUT_REGISTER_START = 256;
    public static final int REGISTER_START = 4096;
    private InjectPayload.InjectParameter[] noParams = new InjectPayload.InjectParameter[0];
    private boolean analysisStateRecoverable = true;

    public String getName() {
        return "dexparameters";
    }

    public int getType() {
        return 3;
    }

    public String getSource() {
        return "dexparameters";
    }

    public int getParamShift() {
        return 0;
    }

    public InjectPayload.InjectParameter[] getInput() {
        return this.noParams;
    }

    public InjectPayload.InjectParameter[] getOutput() {
        return this.noParams;
    }

    public void inject(InjectContext context, PcodeEmit emit) {
    }

    public PcodeOp[] getPcode(Program program, InjectContext con) {
        DexAnalysisState analysisState;
        if (!this.analysisStateRecoverable) {
            return new PcodeOp[0];
        }
        try {
            analysisState = DexAnalysisState.getState((Program)program);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)e.getMessage(), (Throwable)e);
            this.analysisStateRecoverable = false;
            return new PcodeOp[0];
        }
        DexHeader header = analysisState.getHeader();
        Function func = program.getFunctionManager().getFunctionContaining(con.baseAddr);
        EncodedMethod encodedMethod = null;
        if (func != null) {
            encodedMethod = analysisState.getEncodedMethod(func.getEntryPoint());
        }
        if (encodedMethod == null) {
            return new PcodeOp[0];
        }
        int paramCount = 0;
        if (!encodedMethod.isStatic()) {
            ++paramCount;
        }
        CodeItem codeItem = encodedMethod.getCodeItem();
        int registerIndex = codeItem.getRegistersSize() - codeItem.getIncomingSize();
        MethodIDItem methodIDItem = (MethodIDItem)header.getMethods().get(encodedMethod.getMethodIndex());
        int prototypeIndex = methodIDItem.getProtoIndex() & 0xFFFF;
        PrototypesIDItem prototype = (PrototypesIDItem)header.getPrototypes().get(prototypeIndex);
        TypeList parameters = prototype.getParameters();
        if (parameters != null) {
            paramCount += parameters.getItems().size();
        }
        AddressSpace registerSpace = program.getAddressFactory().getAddressSpace("register");
        PcodeOp[] resOps = new PcodeOp[paramCount];
        long fromOffset = 256L;
        long toOffset = 4096 + 4 * registerIndex;
        int i = 0;
        if (!encodedMethod.isStatic()) {
            Address fromAddr = registerSpace.getAddress(fromOffset);
            Address toAddr = registerSpace.getAddress(toOffset);
            fromOffset += 4L;
            toOffset += 4L;
            PcodeOp op = new PcodeOp(con.baseAddr, i, 1);
            op.setInput(new Varnode(fromAddr, 4), 0);
            op.setOutput(new Varnode(toAddr, 4));
            resOps[i] = op;
            ++i;
        }
        if (parameters != null) {
            for (TypeItem parameterTypeItem : parameters.getItems()) {
                String parameterTypeString = DexUtil.convertTypeIndexToString((DexHeader)header, (short)parameterTypeItem.getType());
                char firstChar = parameterTypeString.charAt(0);
                Address fromAddr = registerSpace.getAddress(fromOffset);
                Address toAddr = registerSpace.getAddress(toOffset);
                int size = firstChar == 'D' || firstChar == 'J' ? 8 : 4;
                fromOffset += (long)size;
                toOffset += (long)size;
                PcodeOp op = new PcodeOp(con.baseAddr, i, 1);
                op.setInput(new Varnode(fromAddr, size), 0);
                op.setOutput(new Varnode(toAddr, size));
                resOps[i++] = op;
            }
        }
        return resOps;
    }

    public boolean isFallThru() {
        return true;
    }
}

