/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import resources.ResourceManager;

public class ButtonPanelFactory {
    public static final char X_AXIS = '0';
    public static final char Y_AXIS = '1';
    public static final int ARROW_UP_TYPE = 0;
    public static final int ARROW_DOWN_TYPE = 1;
    public static final int BROWSE_TYPE = 2;
    public static final int CANCEL_TYPE = 3;
    public static final int EDIT_TYPE = 4;
    public static final int OK_TYPE = 5;
    public static final int ARROW_LEFT_TYPE = 6;
    public static final int ARROW_RIGHT_TYPE = 7;
    public static final Dimension ARROW_SIZE = new Dimension(32, 32);
    public static final Dimension BROWSE_SIZE = new Dimension(30, 25);
    public static final Icon BROWSE_ICON = new Icon(){

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.BLACK);
            g.fillRect(x, y + 5, 2, 2);
            g.fillRect(x + 4, y + 5, 2, 2);
            g.fillRect(x + 8, y + 5, 2, 2);
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    };
    public static final Font BROWSE_FONT = new Font("Dialog", 1, 12);
    private static final int TOP_MARGIN = 8;
    private static final int BOTTOM_MARGIN = 8;
    private static final int SIDE_MARGIN = 20;
    private static final int BUTTON_GAP = 10;
    private static final String CANCEL_LABEL = "Cancel";
    private static final String OK_LABEL = "Ok";
    private static final String UNTITLED = "Untitled Button";
    private static final String BROWSE_TOOLTIP_TEXT = "Browse";

    private ButtonPanelFactory() {
    }

    public static JButton createButton(int buttonType) {
        switch (buttonType) {
            case 1: {
                return ButtonPanelFactory.createImageButton("images/down.png", "DOWN", ARROW_SIZE);
            }
            case 0: {
                return ButtonPanelFactory.createImageButton("images/up.png", "UP", ARROW_SIZE);
            }
            case 6: {
                return ButtonPanelFactory.createImageButton("images/left.png", "LEFT", ARROW_SIZE);
            }
            case 7: {
                return ButtonPanelFactory.createImageButton("images/right.png", "RIGHT", ARROW_SIZE);
            }
            case 2: {
                return ButtonPanelFactory.createBrowseButton();
            }
            case 3: {
                return ButtonPanelFactory.createButton(CANCEL_LABEL);
            }
            case 4: {
                return ButtonPanelFactory.createImageButton("images/accessories-text-editor.png", "Edit", BROWSE_SIZE);
            }
            case 5: {
                return ButtonPanelFactory.createButton(OK_LABEL);
            }
        }
        return ButtonPanelFactory.createButton(UNTITLED);
    }

    public static JButton createButton(String text) {
        return new JButton(text);
    }

    public static JPanel createButtonPanel(JButton[] buttons) {
        return ButtonPanelFactory.createButtonPanel(buttons, 20, '1');
    }

    public static JPanel createButtonPanel(JButton[] buttons, char alignment) {
        return ButtonPanelFactory.createButtonPanel(buttons, 20, alignment);
    }

    public static JPanel createButtonPanel(JButton[] buttons, int sideMargin) {
        return ButtonPanelFactory.createButtonPanel(buttons, sideMargin, '1');
    }

    public static JPanel createButtonPanel(JButton[] buttons, int sideMargin, char alignment) {
        JPanel panel = new JPanel();
        JPanel subPanel = new JPanel();
        panel.add(subPanel);
        subPanel.setLayout(alignment == '1' ? new GridLayout(0, 1, 0, 10) : new GridLayout(1, 0, 10, 0));
        Border inside = BorderFactory.createEmptyBorder(8, sideMargin, 8, sideMargin);
        subPanel.setBorder(inside);
        for (JButton button : buttons) {
            subPanel.add(button);
        }
        return panel;
    }

    public static JButton createImageButton(String imageFile, String alternateText, Dimension preferredSize) {
        ImageIcon buttonIcon = ResourceManager.loadImage((String)imageFile);
        return ButtonPanelFactory.createImageButton(buttonIcon, alternateText, preferredSize);
    }

    public static JButton createImageButton(ImageIcon buttonIcon, String alternateText, Dimension preferredSize) {
        JButton button = ButtonPanelFactory.createButton("");
        if (buttonIcon != null) {
            button.setIcon(buttonIcon);
        } else {
            button.setText(alternateText);
        }
        button.setPreferredSize(preferredSize);
        return button;
    }

    private static JButton createBrowseButton() {
        JButton button = new JButton(BROWSE_ICON);
        button.setName("BrowseButton");
        button.setToolTipText(BROWSE_TOOLTIP_TEXT);
        return button;
    }
}

