/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.DockingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultCaret;

public class HyperlinkComponent
extends JPanel {
    private JTextPane textPane;
    private HashMap<String, List<HyperlinkListener>> hyperlinkListeners;

    public HyperlinkComponent(String htmlTextWithHyperlinks) {
        this.setLayout(new BorderLayout());
        this.textPane = new JTextPane();
        this.textPane.setContentType("text/html");
        this.textPane.setEditable(false);
        DockingUtils.setTransparent(this.textPane);
        this.textPane.setCaret(new NonScrollingCaret());
        this.textPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                String anchorText = e.getDescription();
                List<HyperlinkListener> list = HyperlinkComponent.this.hyperlinkListeners.get(anchorText);
                if (list == null) {
                    return;
                }
                for (HyperlinkListener hyperlinkListener : list) {
                    hyperlinkListener.hyperlinkUpdate(e);
                }
            }
        });
        this.textPane.setBorder(BorderFactory.createEmptyBorder());
        this.textPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.setText(htmlTextWithHyperlinks);
        this.add((Component)this.textPane, "North");
        this.textPane.setPreferredSize(this.getPreferredSize());
        this.hyperlinkListeners = new HashMap();
    }

    public void addHyperlinkListener(String anchorName, HyperlinkListener listener) {
        List<HyperlinkListener> list = this.hyperlinkListeners.get(anchorName);
        if (list == null) {
            list = new ArrayList<HyperlinkListener>();
            this.hyperlinkListeners.put(anchorName, list);
        }
        list.add(listener);
    }

    public void removeHyperlinkListener(String anchorName, HyperlinkListener listener) {
        List<HyperlinkListener> list = this.hyperlinkListeners.get(anchorName);
        if (list == null) {
            return;
        }
        list.remove(listener);
    }

    public void setText(String text) {
        this.textPane.setText(text);
        this.textPane.getPreferredSize();
        this.getPreferredSize();
    }

    public String getText() {
        return this.textPane.getText();
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.textPane.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.textPane.removeMouseListener(l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        this.textPane.addMouseMotionListener(l);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        this.textPane.removeMouseMotionListener(l);
    }

    private class NonScrollingCaret
    extends DefaultCaret {
        private NonScrollingCaret() {
            this.setVisible(false);
        }

        @Override
        protected void adjustVisibility(Rectangle nloc) {
        }
    }
}

