/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import ghidra.util.filechooser.GhidraFileChooserListener;
import ghidra.util.filechooser.GhidraFileChooserModel;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import resources.ResourceManager;

public class LocalFileChooserModel
implements GhidraFileChooserModel {
    private static final ImageIcon PROBLEM_FILE_ICON = ResourceManager.loadImage((String)"images/unknown.gif");
    private FileSystemView fsView = FileSystemView.getFileSystemView();
    private Map<File, String> rootDescripMap = new HashMap<File, String>();
    private Map<File, Icon> rootIconMap = new HashMap<File, Icon>();
    private File[] roots = new File[0];
    private GhidraFileChooserListener listener;

    public char getSeparator() {
        return File.separatorChar;
    }

    public void setListener(GhidraFileChooserListener l) {
        this.listener = l;
    }

    public File getHomeDirectory() {
        return new File(System.getProperty("user.home"));
    }

    public File getDesktopDirectory() {
        String userHomeProp = System.getProperty("user.home");
        if (userHomeProp == null) {
            return null;
        }
        File home = new File(userHomeProp);
        File desktop = new File(home, "Desktop");
        return desktop.isDirectory() ? desktop : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getRoots() {
        if (this.roots.length == 0) {
            this.roots = File.listRoots();
            Map<File, String> map = this.rootDescripMap;
            synchronized (map) {
                for (File r : this.roots) {
                    this.rootDescripMap.put(r, this.getFastRootDescriptionString(r));
                    this.rootIconMap.put(r, this.fsView.getSystemIcon(r));
                }
            }
            FileDescriptionThread backgroundRootScanThread = new FileDescriptionThread();
            backgroundRootScanThread.start();
        }
        return this.roots;
    }

    protected String getFastRootDescriptionString(File root) {
        String fsvSTD = "Unknown status";
        try {
            fsvSTD = this.fsView.getSystemTypeDescription(root);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.format("%s (%s)", fsvSTD, this.formatRootPathForDisplay(root));
    }

    protected String getRootDescriptionString(File root) {
        if ("/".equals(root.getAbsolutePath())) {
            return "File system root (/)";
        }
        if (this.fsView.isFloppyDrive(root)) {
            return String.format("Floppy (%s)", root.getAbsolutePath());
        }
        String fsvSTD = null;
        try {
            fsvSTD = this.fsView.getSystemTypeDescription(root);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fsvSTD == null || fsvSTD.toLowerCase().indexOf("removable") != -1) {
            return "Removable Disk (" + root.getAbsolutePath() + ")";
        }
        return this.fsView.getSystemDisplayName(root);
    }

    protected String formatRootPathForDisplay(File root) {
        String s = root.getAbsolutePath();
        return s.length() > 1 && s.endsWith("\\") ? s.substring(0, s.length() - 1) : s;
    }

    public File[] getListing(File directory, FileFilter filter) {
        if (directory == null) {
            return new File[0];
        }
        File[] files = directory.listFiles(filter);
        return files == null ? new File[]{} : files;
    }

    public Icon getIcon(File file) {
        if (this.rootIconMap.containsKey(file)) {
            return this.rootIconMap.get(file);
        }
        if (file != null && file.exists()) {
            try {
                return this.fsView.getSystemIcon(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return PROBLEM_FILE_ICON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription(File file) {
        Map<File, String> map = this.rootDescripMap;
        synchronized (map) {
            if (this.rootDescripMap.containsKey(file)) {
                return this.rootDescripMap.get(file);
            }
        }
        return this.fsView.getSystemTypeDescription(file);
    }

    public boolean createDirectory(File directory, String name) {
        File newDir = new File(directory, name);
        return newDir.mkdir();
    }

    public boolean isDirectory(File file) {
        File[] localRoots = this.getRoots();
        for (int i = 0; i < localRoots.length; ++i) {
            if (!localRoots[i].equals(file)) continue;
            return true;
        }
        return file != null && file.isDirectory();
    }

    public boolean isAbsolute(File file) {
        if (file != null) {
            return file.isAbsolute();
        }
        return false;
    }

    public boolean renameFile(File src, File dest) {
        for (File root : this.roots) {
            if (!root.equals(src)) continue;
            return false;
        }
        return src.renameTo(dest);
    }

    private class FileDescriptionThread
    extends Thread {
        FileDescriptionThread() {
            super("File Chooser - File Description Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<File, String> map = LocalFileChooserModel.this.rootDescripMap;
            synchronized (map) {
                for (File r : LocalFileChooserModel.this.roots) {
                    LocalFileChooserModel.this.rootDescripMap.put(r, LocalFileChooserModel.this.getRootDescriptionString(r));
                }
            }
            if (LocalFileChooserModel.this.listener != null) {
                LocalFileChooserModel.this.listener.modelChanged();
            }
        }
    }
}

