/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.tree.AbstractGTreeNode;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.tasks.GTreeLoadChildrenTask;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class GTreeSlowLoadingNode
extends AbstractGTreeNode {
    public abstract List<GTreeNode> generateChildren(TaskMonitor var1) throws CancelledException;

    @Override
    protected final void loadChildren() {
        GTree tree = this.getTree();
        if (SystemUtilities.isEventDispatchThread()) {
            if (this.isChildrenLoadedOrInProgress()) {
                return;
            }
            this.setInProgress();
            if (tree != null) {
                GTreeLoadChildrenTask loadTask = new GTreeLoadChildrenTask(tree, this);
                tree.runTask(loadTask);
                return;
            }
        }
        if (this.isChildrenLoadedOrInProgress() && !this.isInProgress()) {
            return;
        }
        this.setInProgress();
        this.doLoadChildren(tree, this.getMonitor(tree));
    }

    private TaskMonitor getMonitor(GTree tree) {
        if (tree == null) {
            return TaskMonitorAdapter.DUMMY_MONITOR;
        }
        return tree.getThreadLocalMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadChildren(final GTree tree, TaskMonitor monitor) {
        if (this.isChildrenLoaded()) {
            this.setChildren(this.doGetAllChildren());
            return;
        }
        long progressValue = monitor.getProgress();
        long maxValue = monitor.getMaximum();
        try {
            this.setChildren(this.generateChildren(monitor));
        }
        catch (CancelledException e) {
            SystemUtilities.runSwingNow((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (tree != null) {
                        tree.collapseAll(tree.getRootNode());
                    }
                }
            });
            this.doSetChildren(null, true);
        }
        finally {
            monitor.initialize(maxValue);
            monitor.setProgress(progressValue);
        }
    }

    @Override
    protected void swingSetChildren(List<GTreeNode> childList, boolean notify, boolean onlyIfInProgress) {
        super.swingSetChildren(childList, notify, true);
    }

    @Override
    public void addNode(int index, GTreeNode node) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new AssertException("You may not invoke this method on a GTReeSlowLoadingNode from the Swing thread");
        }
        super.addNode(index, node);
    }
}

