/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;

public class ClangFuncNameToken
extends ClangToken {
    private HighFunction hfunc;
    private PcodeOp op;

    public ClangFuncNameToken(ClangNode par, HighFunction hf) {
        super(par);
        this.hfunc = hf;
        this.op = null;
    }

    public HighFunction getHighFunction() {
        return this.hfunc;
    }

    @Override
    public PcodeOp getPcodeOp() {
        return this.op;
    }

    @Override
    public Address getMinAddress() {
        if (this.op == null) {
            return null;
        }
        return this.op.getSeqnum().getTarget().getPhysicalAddress();
    }

    @Override
    public Address getMaxAddress() {
        if (this.op == null) {
            return null;
        }
        return this.op.getSeqnum().getTarget().getPhysicalAddress();
    }

    @Override
    public void restoreFromXML(XmlElement el, XmlElement end, PcodeFactory pfactory) {
        super.restoreFromXML(el, end, pfactory);
        String oprefstring = el.getAttribute("opref");
        if (oprefstring != null) {
            int refid = SpecXmlUtils.decodeInt((String)oprefstring);
            this.op = pfactory.getOpRef(refid);
        }
    }
}

