/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.ToolBarData;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class CloneDecompilerAction
extends AbstractDecompilerAction {
    private final DecompilerProvider provider;
    private DecompilerController controller;

    public CloneDecompilerAction(DecompilerProvider provider, DecompilerController controller) {
        super("Decompile Clone");
        this.provider = provider;
        this.controller = controller;
        ImageIcon image = ResourceManager.loadImage((String)"images/camera-photo.png");
        this.setToolBarData(new ToolBarData((Icon)image, "ZZZ"));
        this.setDescription("Create a snapshot (disconnected) copy of this Decompiler window ");
        this.setHelpLocation(new HelpLocation("Snapshots", "Snapshots_Start"));
        this.setKeyBindingData(new KeyBindingData(84, 192));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        return this.controller.getFunction() != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        this.provider.cloneWindow();
    }
}

